/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.parts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.varia.Logging;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class SyringeItem
extends Item {
    private IIcon[] filledLevel = new IIcon[6];

    public SyringeItem() {
        this.func_77625_d(1);
        this.func_111206_d("rftools:parts/syringeItem0");
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        super.func_94581_a(iconRegister);
        for (int i = 0; i <= 5; ++i) {
            this.filledLevel[i] = iconRegister.func_94245_a("rftools:parts/syringeItem" + i);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                String mob = tagCompound.func_74779_i("mobName");
                if (mob != null) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.BLUE + "Mob: " + mob));
                }
                int level = tagCompound.func_74762_e("level");
                level = level * 100 / DimletConstructionConfiguration.maxMobInjections;
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.BLUE + "Essence level: " + level + "%"));
            }
            return stack;
        }
        return stack;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        String mob = this.findSelectedMobName(entity);
        if (mob != null) {
            String prevMob = null;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                prevMob = tagCompound.func_74779_i("mobName");
            } else {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            if (prevMob == null || !prevMob.equals(mob)) {
                tagCompound.func_74778_a("mobName", mob);
                tagCompound.func_74768_a("level", 1);
            } else {
                int level = tagCompound.func_74762_e("level");
                if (++level > DimletConstructionConfiguration.maxMobInjections) {
                    level = DimletConstructionConfiguration.maxMobInjections;
                }
                tagCompound.func_74768_a("level", level);
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private String findSelectedMobName(Entity entity) {
        Class<? extends EntityLiving> entityClass;
        for (Map.Entry<DimletKey, MobDescriptor> entry : DimletObjectMapping.idtoMob.entrySet()) {
            entityClass = entry.getValue().getEntityClass();
            if (entityClass == null || !entityClass.equals(entity.getClass())) continue;
            DimletKey key = entry.getKey();
            return key.getName();
        }
        for (Map.Entry<DimletKey, MobDescriptor> entry : DimletObjectMapping.idtoMob.entrySet()) {
            entityClass = entry.getValue().getEntityClass();
            if (entityClass == null || !entityClass.isAssignableFrom(entity.getClass())) continue;
            DimletKey key = entry.getKey();
            return key.getName();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            String mob = tagCompound.func_74779_i("mobName");
            if (mob != null) {
                list.add(EnumChatFormatting.BLUE + "Mob: " + mob);
            }
            int level = tagCompound.func_74762_e("level");
            level = level * 100 / DimletConstructionConfiguration.maxMobInjections;
            list.add(EnumChatFormatting.BLUE + "Essence level: " + level + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Use this to extract essence from mobs. This");
            list.add(EnumChatFormatting.WHITE + "essence can then be used in the Dimlet");
            list.add(EnumChatFormatting.WHITE + "Workbench. Be careful!");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int level = 0;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            level = tagCompound.func_74762_e("level");
        }
        if (level <= 0) {
            return this.filledLevel[0];
        }
        if (level >= DimletConstructionConfiguration.maxMobInjections) {
            return this.filledLevel[5];
        }
        level = (level - 1) * 4 / (DimletConstructionConfiguration.maxMobInjections - 1) + 1;
        return this.filledLevel[level];
    }
}

