/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionSetup;
import mcjty.rftools.blocks.dimletconstruction.TimeAbsorberTileEntity;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.types.DimletCraftingTools;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class TimeDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_time";
    private static int rarity = 2;
    private static int baseCreationCost = 300;
    private static int baseMaintainCost = 20;
    private static int baseTickCost = 10;

    @Override
    public String getName() {
        return "Time";
    }

    @Override
    public String getOpcode() {
        return "t";
    }

    @Override
    public String getTextureName() {
        return "timeDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the time dimlet type");
        rarity = cfg.get(CATEGORY_TYPE, "rarity", rarity, "Default rarity for this dimlet type").getInt();
        baseCreationCost = cfg.get(CATEGORY_TYPE, "creation.cost", baseCreationCost, "Dimlet creation cost (how much power this dimlets adds during creation time of a dimension)").getInt();
        baseMaintainCost = cfg.get(CATEGORY_TYPE, "maintenance.cost", baseMaintainCost, "Dimlet maintenance cost (how much power this dimlet will use up to keep the dimension running)").getInt();
        baseTickCost = cfg.get(CATEGORY_TYPE, "tick.cost", baseTickCost, "Dimlet tick cost (how long it takes to make a dimension with this dimlet in it)").getInt();
    }

    @Override
    public int getRarity() {
        return rarity;
    }

    @Override
    public int getCreationCost() {
        return baseCreationCost;
    }

    @Override
    public int getMaintenanceCost() {
        return baseMaintainCost;
    }

    @Override
    public int getTickCost() {
        return baseTickCost;
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return false;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return true;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
        dimensionInformation.setCelestialAngle(DimletObjectMapping.idToCelestialAngle.get(key));
        dimensionInformation.setTimeSpeed(DimletObjectMapping.idToSpeed.get(key));
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        Float celestialAngle = null;
        Float timeSpeed = null;
        if ((dimlets = DimensionInformation.extractType(DimletType.DIMLET_TIME, dimlets)).isEmpty()) {
            if (random.nextFloat() < DimletConfiguration.randomSpecialTimeChance) {
                celestialAngle = null;
                timeSpeed = null;
            } else {
                ArrayList<DimletKey> keys = new ArrayList<DimletKey>(DimletObjectMapping.idToCelestialAngle.keySet());
                DimletKey key = (DimletKey)keys.get(random.nextInt(keys.size()));
                celestialAngle = DimletObjectMapping.idToCelestialAngle.get(key);
                timeSpeed = DimletObjectMapping.idToSpeed.get(key);
            }
        } else {
            DimletKey key = (DimletKey)dimlets.get(random.nextInt(dimlets.size())).getKey();
            celestialAngle = DimletObjectMapping.idToCelestialAngle.get(key);
            timeSpeed = DimletObjectMapping.idToSpeed.get(key);
        }
        dimensionInformation.setCelestialAngle(celestialAngle);
        dimensionInformation.setTimeSpeed(timeSpeed);
    }

    @Override
    public String[] getInformation() {
        return new String[]{"Control the flow of time."};
    }

    private static boolean isValidTimeEssence(ItemStack stackEssence, NBTTagCompound essenceCompound) {
        Block essenceBlock = BlockTools.getBlock((ItemStack)stackEssence);
        if (essenceBlock != DimletConstructionSetup.timeAbsorberBlock) {
            return false;
        }
        if (essenceCompound == null) {
            return false;
        }
        int absorbing = essenceCompound.func_74762_e("absorbing");
        float angle = essenceCompound.func_74760_g("angle");
        return absorbing <= 0 && !(angle < -0.01f);
    }

    private static DimletKey findTimeDimlet(ItemStack stackEssence) {
        float angle = stackEssence.func_77978_p().func_74760_g("angle");
        return TimeAbsorberTileEntity.findBestTimeDimlet(angle);
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        if (!TimeDimletType.isValidTimeEssence(stackEssence, stackEssence.func_77978_p())) {
            return null;
        }
        DimletKey timeDimlet = TimeDimletType.findTimeDimlet(stackEssence);
        if (timeDimlet == null) {
            return null;
        }
        if (!DimletCraftingTools.matchDimletRecipe(timeDimlet, stackController, stackMemory, stackEnergy)) {
            return null;
        }
        return timeDimlet;
    }
}

