/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.rftools.items.dimlets.types.Patreons;
import mcjty.varia.BlockMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;

public class TerrainDimletType
implements IDimletType {
    private static final String CATEGORY_TYPE = "type_terrain";
    private static int rarity = 0;
    private static int baseCreationCost = 100;
    private static int baseMaintainCost = 1;
    private static int baseTickCost = 1;
    private static float materialCreationCostFactor = 5.0f;
    private static float liquidCreationCostFactor = 5.0f;
    private static float materialMaintenanceCostFactor = 5.0f;
    private static float liquidMaintenanceCostFactor = 5.0f;
    private static float materialTickCostFactor = 2.0f;
    private static float liquidTickCostFactor = 2.0f;

    @Override
    public String getName() {
        return "Terrain";
    }

    @Override
    public String getOpcode() {
        return "T";
    }

    @Override
    public String getTextureName() {
        return "terrainDimlet";
    }

    @Override
    public void setupFromConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_TYPE, "Settings for the terrain dimlet type");
        rarity = cfg.get(CATEGORY_TYPE, "rarity", rarity, "Default rarity for this dimlet type").getInt();
        baseCreationCost = cfg.get(CATEGORY_TYPE, "creation.cost", baseCreationCost, "Dimlet creation cost (how much power this dimlets adds during creation time of a dimension)").getInt();
        baseMaintainCost = cfg.get(CATEGORY_TYPE, "maintenance.cost", baseMaintainCost, "Dimlet maintenance cost (how much power this dimlet will use up to keep the dimension running)").getInt();
        baseTickCost = cfg.get(CATEGORY_TYPE, "tick.cost", baseTickCost, "Dimlet tick cost (how long it takes to make a dimension with this dimlet in it)").getInt();
        materialCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.creation.factor", (double)materialCreationCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidCreationCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.creation.factor", (double)liquidCreationCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
        materialMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.maintenance.factor", (double)materialMaintenanceCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidMaintenanceCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.maintenance.factor", (double)liquidMaintenanceCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
        materialTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "material.tick.factor", (double)materialTickCostFactor, "The cost factor for a material dimlet modifier when used in combination with this terrain").getDouble();
        liquidTickCostFactor = (float)cfg.get(CATEGORY_TYPE, "liquid.tick.factor", (double)liquidTickCostFactor, "The cost factor for a liquid dimlet modifier when used in combination with this terrain").getDouble();
    }

    @Override
    public int getRarity() {
        return rarity;
    }

    @Override
    public int getCreationCost() {
        return baseCreationCost;
    }

    @Override
    public int getMaintenanceCost() {
        return baseMaintainCost;
    }

    @Override
    public int getTickCost() {
        return baseTickCost;
    }

    @Override
    public boolean isModifier() {
        return false;
    }

    @Override
    public boolean isModifiedBy(DimletType type) {
        return type == DimletType.DIMLET_MATERIAL || type == DimletType.DIMLET_LIQUID;
    }

    @Override
    public float getModifierCreateCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.idToTerrainType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialCreationCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidCreationCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public float getModifierMaintainCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.idToTerrainType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialMaintenanceCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidMaintenanceCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public float getModifierTickCostFactor(DimletType modifierType, DimletKey key) {
        TerrainType terrainType = DimletObjectMapping.idToTerrainType.get(key);
        if (modifierType == DimletType.DIMLET_MATERIAL) {
            return materialTickCostFactor * terrainType.getMaterialCostFactor();
        }
        if (modifierType == DimletType.DIMLET_LIQUID) {
            return liquidTickCostFactor * terrainType.getLiquidCostFactor();
        }
        return 1.0f;
    }

    @Override
    public boolean isInjectable() {
        return false;
    }

    @Override
    public void inject(DimletKey key, DimensionInformation dimensionInformation) {
    }

    @Override
    public void constructDimension(List<Pair<DimletKey, List<DimletKey>>> dimlets, Random random, DimensionInformation dimensionInformation) {
        Block fluidForTerrain;
        BlockMeta baseBlockForTerrain;
        List modifiers;
        DimletKey key;
        dimlets = DimensionInformation.extractType(DimletType.DIMLET_TERRAIN, dimlets);
        TerrainType terrainType = TerrainType.TERRAIN_VOID;
        if (dimlets.isEmpty()) {
            ArrayList<DimletKey> idList = new ArrayList<DimletKey>(DimletObjectMapping.idToTerrainType.keySet());
            key = (DimletKey)idList.get(random.nextInt(idList.size()));
            dimensionInformation.updateCostFactor(key);
            terrainType = DimletObjectMapping.idToTerrainType.get(key);
            modifiers = Collections.emptyList();
        } else {
            int index = random.nextInt(dimlets.size());
            key = (DimletKey)dimlets.get(index).getLeft();
            terrainType = DimletObjectMapping.idToTerrainType.get(key);
            modifiers = (List)dimlets.get(index).getRight();
        }
        ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
        ArrayList<Block> fluids = new ArrayList<Block>();
        DimensionInformation.getMaterialAndFluidModifiers(modifiers, blocks, fluids);
        dimensionInformation.setTerrainType(terrainType);
        if (dimensionInformation.isPatreonBitSet(Patreons.PATREON_LAYEREDMETA)) {
            baseBlockForTerrain = new BlockMeta(Blocks.field_150325_L, 127);
        } else if (!blocks.isEmpty()) {
            baseBlockForTerrain = (BlockMeta)blocks.get(random.nextInt(blocks.size()));
            if (baseBlockForTerrain == null) {
                baseBlockForTerrain = BlockMeta.STONE;
            }
        } else if (random.nextFloat() < DimletConfiguration.randomBaseBlockChance) {
            DimletKey key2 = DimletRandomizer.getRandomMaterialBlock(random, false);
            dimensionInformation.updateCostFactor(key2);
            baseBlockForTerrain = DimletObjectMapping.idToBlock.get(key2);
        } else {
            baseBlockForTerrain = BlockMeta.STONE;
        }
        dimensionInformation.setBaseBlockForTerrain(baseBlockForTerrain);
        if (!fluids.isEmpty()) {
            fluidForTerrain = (Block)fluids.get(random.nextInt(fluids.size()));
            if (fluidForTerrain == null) {
                fluidForTerrain = Blocks.field_150355_j;
            }
        } else if (random.nextFloat() < DimletConfiguration.randomOceanLiquidChance) {
            DimletKey key3 = DimletRandomizer.getRandomFluidBlock(random, false);
            dimensionInformation.updateCostFactor(key3);
            fluidForTerrain = DimletObjectMapping.idToFluid.get(key3);
        } else {
            fluidForTerrain = Blocks.field_150355_j;
        }
        dimensionInformation.setFluidForTerrain(fluidForTerrain);
    }

    @Override
    public String[] getInformation() {
        return new String[]{"This affects the type of terrain", "that you will get in a dimension", "This dimlet can receive liquid and material", "modifiers which have to come in front of the terrain."};
    }

    @Override
    public DimletKey attemptDimletCrafting(ItemStack stackController, ItemStack stackMemory, ItemStack stackEnergy, ItemStack stackEssence) {
        return null;
    }
}

