/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.shards.AbstractDirectionalBlock;
import mcjty.rftools.blocks.special.SpecialSetup;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.world.WorldGenerationTools;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.dimlets.types.Patreons;
import mcjty.varia.BlockMeta;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.Logging;
import mcjty.varia.WeightedRandomSelector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class GenericWorldGenerator
implements IWorldGenerator {
    private static int[][] puppeteerSpawnPlatform = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {15, 15, 15, 15, 0, 0, 0, 0, 0, 0, 0, 15, 15, 15, 15, 0, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 0, 0, 15, 0, 15, 0, 0, 15, 15, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 0, 0, 0, 0, 0, 15, 15, 15, 0, 15, 15, 15, 0, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -2, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {15, 15, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, 15, 15, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, -1, -1}, {-1, -1, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, 15, 15, 15, 15, 15, 15, 0, 15, 0, 15, 0, 15, 0, 15, 15, 15, 15, 15, 15, -1, -1, -1}, {-1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1}, {-1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 15, 15, 15, 15, 15, 15, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        if (manager.getDimensionDescriptor(world.field_73011_w.field_76574_g) == null) {
            return;
        }
        DimensionInformation information = manager.getDimensionInformation(world.field_73011_w.field_76574_g);
        BlockMeta baseBlock = information.getBaseBlockForTerrain();
        if (information.hasFeatureType(FeatureType.FEATURE_OREGEN)) {
            for (BlockMeta block : information.getExtraOregen()) {
                this.addOreSpawn(block.getBlock(), block.getMeta(), baseBlock.getBlock(), world, random, chunkX * 16, chunkZ * 16, 7, 10, 12, 2, 60);
            }
        }
        this.addOreSpawn(DimletSetup.dimensionalShardBlock, (byte)0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 5, 8, 3, 2, 40);
        if (information.isPatreonBitSet(Patreons.PATREON_PUPPETEER) && Math.abs(chunkX) <= 1 && Math.abs(chunkZ) <= 1) {
            this.generateBigSpawnPlatform(world, chunkX, chunkZ, puppeteerSpawnPlatform);
        } else if (chunkX == 0 && chunkZ == 0) {
            this.generateSpawnPlatform(world);
        } else if (!(Math.abs(chunkX) <= 6 && Math.abs(chunkZ) <= 6 || information.hasFeatureType(FeatureType.FEATURE_NODIMLETBUILDINGS) || random.nextInt(DimletConfiguration.dungeonChance) != 1)) {
            this.generateDimletDungeon(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 2 || Math.abs(chunkZ) >= 2) && information.isPatreonBitSet(Patreons.PATREON_COLOREDPRISMS) && random.nextInt(10) == 1) {
            this.generatePrism(chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 1 || Math.abs(chunkZ) >= 1) && information.isPatreonBitSet(Patreons.PATREON_PINKPILLARS) && random.nextInt(2) == 1) {
            this.generatePillar(random, chunkX, chunkZ, world);
        }
        if ((Math.abs(chunkX) >= 3 || Math.abs(chunkZ) >= 3) && information.hasFeatureType(FeatureType.FEATURE_VOLCANOES) && random.nextInt(DimletConfiguration.volcanoChance) == 1) {
            this.generateVolcano(random, chunkX, chunkZ, world);
        }
    }

    private void generateDimletDungeon(Random random, int chunkX, int chunkZ, World world) {
        int starty4;
        int starty3;
        int starty2;
        int midx = chunkX * 16 + 8;
        int midz = chunkZ * 16 + 8;
        int starty1 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz - 3);
        int starty = (starty1 + (starty2 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz - 3)) + (starty3 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz + 3)) + (starty4 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz + 3))) / 4;
        if (starty > 1 && starty < world.func_72800_K() - 20) {
            this.generateDungeon(world, random, midx, starty, midz);
        }
    }

    private void generateVolcano(Random random, int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + random.nextInt(16);
        int z = chunkZ * 16 + random.nextInt(16);
        int cntsolid = 0;
        for (int y = world.func_72825_h(x, z); y > 3; --y) {
            if (WorldGenerationTools.isSolid(world, x, y, z)) {
                if (++cntsolid <= 5) continue;
                world.func_147465_d(x, y, z, (Block)SpecialSetup.volcanicCoreBlock, 0, 3);
                Logging.log((String)("Spawned volcano block at " + x + "," + y + "," + z));
                break;
            }
            cntsolid = 0;
        }
    }

    private void generatePrism(int chunkX, int chunkZ, World world) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        int y = world.func_72825_h(x, z);
        int y1 = world.func_72825_h(x - 7, z - 7);
        if (y1 < y) {
            y = y1;
        }
        if ((y1 = world.func_72825_h(x + 7, z - 7)) < y) {
            y = y1;
        }
        if ((y1 = world.func_72825_h(x - 7, z + 7)) < y) {
            y = y1;
        }
        if ((y1 = world.func_72825_h(x + 7, z + 7)) < y) {
            y = y1;
        }
        if (y > 10 && y < 230) {
            for (int i = 7; i >= 0; --i) {
                if (i == 0) {
                    this.setStainedGlassIfAir(world, x, y, z, i);
                } else {
                    for (int j = -i; j <= i - 1; ++j) {
                        this.setStainedGlassIfAir(world, x + j + 1, y, z + i, i);
                        this.setStainedGlassIfAir(world, x + i, y, z + j, i);
                        this.setStainedGlassIfAir(world, x - j - 1, y, z - i, i);
                        this.setStainedGlassIfAir(world, x - i, y, z - j, i);
                    }
                }
                ++y;
            }
        }
    }

    private void setStainedGlassIfAir(World world, int x, int y, int z, int i) {
        if (world.func_147437_c(x, y, z)) {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, i, 2);
        }
    }

    private void generatePillar(Random random, int chunkX, int chunkZ, World world) {
        int z;
        int x = chunkX * 16 + random.nextInt(16);
        int y = world.func_72825_h(x, z = chunkZ * 16 + random.nextInt(16));
        if (y > 10 && y < 240) {
            for (int i = 0; i < random.nextInt(3) + 2; ++i) {
                world.func_147465_d(x, y++, z, Blocks.field_150406_ce, 6, 2);
            }
            world.func_147465_d(x, y, z, (Block)Blocks.field_150399_cn, 6, 2);
        }
    }

    private boolean isReceiverPresent(World world, int midx, int midz, int starty, int[][] platform) {
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            for (int z = sz; z < sz + r; ++z) {
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color != -2 || world.func_147439_a(x + midx, starty, z + midz) != TeleporterSetup.matterReceiverBlock) continue;
                return true;
            }
        }
        return false;
    }

    private void generateBigSpawnPlatform(World world, int chunkX, int chunkZ, int[][] platform) {
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.field_76574_g);
        int midx = 8;
        int midz = 8;
        int starty = WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        if (this.isReceiverPresent(world, midx, midz, starty - 1, platform)) {
            --starty;
        }
        int r = platform.length;
        int sx = -r / 2;
        int sz = -r / 2;
        for (int x = sx; x < sx + r; ++x) {
            int cx = x + midx >> 4;
            if (chunkX != cx) continue;
            for (int z = sz; z < sz + r; ++z) {
                int cz = z + midz >> 4;
                if (chunkZ != cz) continue;
                int color = platform[r - x - r / 2 - 1][z + r / 2];
                if (color == -2) {
                    world.func_147465_d(x + midx, starty, z + midz, (Block)TeleporterSetup.matterReceiverBlock, 0, 2);
                    MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_147438_o(x + midx, starty, z + midz);
                    matterReceiverTileEntity.modifyEnergyStored(TeleportConfiguration.RECEIVER_MAXENERGY);
                    matterReceiverTileEntity.setName(information.getName());
                    matterReceiverTileEntity.func_70296_d();
                } else if (color != -1) {
                    world.func_147465_d(x + midx, starty, z + midz, Blocks.field_150406_ce, color, 2);
                } else {
                    world.func_147468_f(x + midx, starty, z + midz);
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_147468_f(x + midx, starty + y, z + midz);
                }
            }
        }
        if (chunkX == 0 && chunkZ == 0) {
            this.createReceiver(world, dimensionManager, information, midx, midz, starty);
        }
    }

    private void generateSpawnPlatform(World world) {
        int z;
        int x;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.field_76574_g);
        int midx = 8;
        int midz = 8;
        int starty = information.getTerrainType() == TerrainType.TERRAIN_SOLID ? 64 : WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        boolean shelter = information.isShelter();
        if (information.getTerrainType() == TerrainType.TERRAIN_LIQUID) {
            shelter = true;
        }
        int bounds = 3;
        if (shelter) {
            bounds = 4;
        }
        for (x = -bounds; x <= bounds; ++x) {
            for (z = -bounds; z <= bounds; ++z) {
                if (x == 0 && z == 0) {
                    world.func_147465_d(x + midx, starty, z + midz, (Block)TeleporterSetup.matterReceiverBlock, 0, 2);
                    MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_147438_o(x + midx, starty, z + midz);
                    matterReceiverTileEntity.modifyEnergyStored(TeleportConfiguration.RECEIVER_MAXENERGY);
                    matterReceiverTileEntity.setName(information.getName());
                    matterReceiverTileEntity.func_70296_d();
                } else if (x == 0 && (z == 2 || z == -2)) {
                    world.func_147465_d(x + midx, starty, z + midz, Blocks.field_150426_aN, 0, 3);
                } else {
                    world.func_147465_d(x + midx, starty, z + midz, Blocks.field_150406_ce, 3, 2);
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_147468_f(x + midx, starty + y, z + midz);
                }
                if (world.func_147437_c(x + midx, starty + 4, z + midz)) continue;
                world.func_147465_d(x + midx, starty + 4, z + midz, Blocks.field_150406_ce, 3, 2);
            }
        }
        if (shelter) {
            for (int y = 1; y <= 3; ++y) {
                for (int x2 = -bounds; x2 <= bounds; ++x2) {
                    for (int z2 = -bounds; z2 <= bounds; ++z2) {
                        if (x2 != -bounds && x2 != bounds && z2 != -bounds && z2 != bounds) continue;
                        if (z2 == 0 && y >= 2 && y <= 3 || x2 == 0 && y >= 2 && y <= 3 && z2 == bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150410_aZ, 0, 2);
                            continue;
                        }
                        if (x2 == 0 && y == 1 && z2 == -bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150454_av, 1, 2);
                            continue;
                        }
                        if (x2 == 0 && y == 2 && z2 == -bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150454_av, 8, 2);
                            continue;
                        }
                        world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150406_ce, 9, 2);
                    }
                }
            }
            for (x = -bounds; x <= bounds; ++x) {
                for (z = -bounds; z <= bounds; ++z) {
                    world.func_147465_d(x + midx, starty + 4, z + midz, Blocks.field_150406_ce, 9, 2);
                }
            }
            world.func_147465_d(midx - 1, starty + 2, midz - bounds - 1, Blocks.field_150430_aB, 4, 2);
            world.func_147465_d(midx + 1, starty + 2, midz - bounds + 1, Blocks.field_150430_aB, 3, 2);
            world.func_147465_d(midx + 1, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx - 1, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx + 1, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx - 1, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
        }
        this.createReceiver(world, dimensionManager, information, midx, midz, starty);
    }

    private void createReceiver(World world, RfToolsDimensionManager dimensionManager, DimensionInformation information, int midx, int midz, int starty) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        Coordinate spawnPoint = new Coordinate(midx, starty, midz);
        GlobalCoordinate gc = new GlobalCoordinate(spawnPoint, world.field_73011_w.field_76574_g);
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(information.getName());
        destinations.save(world);
        information.setSpawnPoint(spawnPoint);
        dimensionManager.save(world);
    }

    private void generateDungeon(World world, Random random, int midx, int starty, int midz) {
        int x;
        AbstractDirectionalBlock cornerBlock;
        boolean doSmallAntenna = random.nextInt(4) == 0;
        boolean doExtraFeature = random.nextInt(4) == 0;
        switch (random.nextInt(3)) {
            case 0: {
                cornerBlock = DimletSetup.dimensionalCrossBlock;
                break;
            }
            case 1: {
                cornerBlock = DimletSetup.dimensionalPattern1Block;
                break;
            }
            case 2: {
                cornerBlock = DimletSetup.dimensionalPattern2Block;
                break;
            }
            default: {
                cornerBlock = DimletSetup.dimensionalCross2Block;
            }
        }
        Block buildingBlock = Blocks.field_150406_ce;
        int color = random.nextInt(5);
        if (color == 0) {
            color = 3;
        } else if (color == 1) {
            color = 9;
        } else if (color == 2) {
            color = 11;
        } else {
            color = 0;
            buildingBlock = DimletSetup.dimensionalBlankBlock;
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int z = midz - 3; z <= midz + 3; ++z) {
                boolean corner = !(x != midx - 3 && x != midx + 3 || z != midz - 3 && z != midz + 3);
                boolean xside = x == midx - 3 || x == midx + 3;
                boolean zside = z == midz - 3 || z == midz + 3;
                boolean antenna = x == midx - 2 && z == midz - 2;
                boolean smallAntenna = doSmallAntenna && x == midx + 2 && z == midz + 2;
                world.func_147465_d(x, starty, z, (Block)Blocks.field_150334_T, 0, 2);
                if (corner) {
                    world.func_147465_d(x, starty + 1, z, (Block)cornerBlock, 1, 2);
                    world.func_147465_d(x, starty + 2, z, (Block)cornerBlock, 1, 2);
                    world.func_147465_d(x, starty + 3, z, (Block)cornerBlock, 1, 2);
                } else if (xside) {
                    world.func_147465_d(x, starty + 1, z, buildingBlock, color, 2);
                    if (z >= midz - 1 && z <= midz + 1) {
                        world.func_147465_d(x, starty + 2, z, Blocks.field_150410_aZ, 0, 2);
                    } else {
                        world.func_147465_d(x, starty + 2, z, buildingBlock, color, 2);
                    }
                    world.func_147465_d(x, starty + 3, z, buildingBlock, color, 2);
                } else if (zside) {
                    world.func_147465_d(x, starty + 1, z, buildingBlock, color, 2);
                    world.func_147465_d(x, starty + 2, z, buildingBlock, color, 2);
                    world.func_147465_d(x, starty + 3, z, buildingBlock, color, 2);
                } else {
                    world.func_147468_f(x, starty + 1, z);
                    world.func_147468_f(x, starty + 2, z);
                    world.func_147468_f(x, starty + 3, z);
                }
                if (antenna) {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150334_T, 0, 2);
                    world.func_147465_d(x, starty + 5, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 6, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 7, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 8, z, Blocks.field_150426_aN, 0, 3);
                } else if (smallAntenna) {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150334_T, 0, 2);
                    world.func_147465_d(x, starty + 5, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147468_f(x, starty + 6, z);
                    world.func_147468_f(x, starty + 7, z);
                    world.func_147468_f(x, starty + 8, z);
                } else {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150333_U, 0, 2);
                    world.func_147468_f(x, starty + 5, z);
                    world.func_147468_f(x, starty + 6, z);
                    world.func_147468_f(x, starty + 7, z);
                    world.func_147468_f(x, starty + 8, z);
                }
                WorldGenerationTools.fillEmptyWithStone(world, x, starty - 1, z);
            }
        }
        if (doExtraFeature) {
            if (!WorldGenerationTools.isSolid(world, midx + 4, starty, midz - 3)) {
                world.func_147465_d(midx + 4, starty, midz - 3, Blocks.field_150411_aY, 0, 2);
            }
            world.func_147465_d(midx + 4, starty + 1, midz - 3, Blocks.field_150411_aY, 0, 2);
            world.func_147465_d(midx + 4, starty + 2, midz - 3, Blocks.field_150411_aY, 0, 2);
            if (!WorldGenerationTools.isSolid(world, midx + 5, starty, midz - 3)) {
                world.func_147465_d(midx + 5, starty, midz - 3, buildingBlock, color, 2);
            }
            world.func_147465_d(midx + 5, starty + 1, midz - 3, buildingBlock, color, 2);
            world.func_147465_d(midx + 5, starty + 2, midz - 3, buildingBlock, color, 2);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 4, starty - 1, midz - 3);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 5, starty - 1, midz - 3);
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int y = starty + 1; y <= starty + 3; ++y) {
                world.func_147468_f(x, y, midz - 4);
            }
        }
        world.func_147465_d(midx - 1, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx + 1, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx, starty + 1, midz - 3, Blocks.field_150454_av, 1, 2);
        world.func_147465_d(midx, starty + 2, midz - 3, Blocks.field_150454_av, 8, 2);
        world.func_147465_d(midx - 1, starty + 2, midz - 4, Blocks.field_150430_aB, 4, 2);
        world.func_147465_d(midx + 1, starty + 2, midz - 2, Blocks.field_150430_aB, 3, 2);
        world.func_147465_d(midx, starty + 3, midz + 3, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(midx, starty + 3, midz + 2, Blocks.field_150442_at, 4, 2);
        world.func_147465_d(midx + 2, starty + 1, midz - 2, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(midx + 2, starty + 1, midz - 2);
        for (int i = 0; i < random.nextInt(2) + 2; ++i) {
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), new ItemStack((Item)DimletSetup.unknownDimlet, random.nextInt(6) + 3));
        }
        WeightedRandomSelector.Distribution goodDistribution = DimletRandomizer.randomDimlets.createDistribution(0.01f);
        for (int i = 0; i < random.nextInt(2) + 1; ++i) {
            DimletKey randomDimlet = DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)goodDistribution, random);
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), KnownDimletConfiguration.makeKnownDimlet(randomDimlet, world));
        }
        WeightedRandomSelector.Distribution bestDistribution = DimletRandomizer.randomDimlets.createDistribution(0.15f);
        EntityItemFrame frame1 = this.spawnItemFrame(world, midx - 1, starty + 2, midz + 2);
        DimletKey rd1 = DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)bestDistribution, random);
        frame1.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd1, world));
        EntityItemFrame frame2 = this.spawnItemFrame(world, midx, starty + 2, midz + 2);
        DimletKey rd2 = DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)bestDistribution, random);
        frame2.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd2, world));
        EntityItemFrame frame3 = this.spawnItemFrame(world, midx + 1, starty + 2, midz + 2);
        DimletKey rd3 = DimletRandomizer.getRandomDimlet((WeightedRandomSelector.Distribution<Integer>)bestDistribution, random);
        frame3.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd3, world));
    }

    private EntityItemFrame spawnItemFrame(World world, int x, int y, int z) {
        EntityItemFrame frame = new EntityItemFrame(world, x, y, z + 1, 2);
        world.func_72838_d((Entity)frame);
        frame.func_70107_b((double)x, (double)y, (double)z);
        frame.field_146063_b = x;
        frame.field_146064_c = y;
        frame.field_146062_d = z + 1;
        frame.func_82328_a(frame.field_82332_a);
        return frame;
    }

    public void addOreSpawn(Block block, byte blockMeta, Block targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, (int)blockMeta, minVeinSize - random.nextInt(maxVeinSize - minVeinSize), targetBlock);
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

