/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mcjty.network.NetworkTools;
import mcjty.rftools.blocks.RFToolsTools;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.description.CelestialBodyDescriptor;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.dimension.description.SkyDescriptor;
import mcjty.rftools.dimension.description.WeatherDescriptor;
import mcjty.rftools.dimension.world.types.CelestialBodyType;
import mcjty.rftools.dimension.world.types.ControllerType;
import mcjty.rftools.dimension.world.types.EffectType;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.SkyType;
import mcjty.rftools.dimension.world.types.StructureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import mcjty.rftools.items.dimlets.BiomeControllerMapping;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.rftools.items.dimlets.types.Patreons;
import mcjty.varia.BlockMeta;
import mcjty.varia.Coordinate;
import mcjty.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionInformation {
    private final DimensionDescriptor descriptor;
    private String name;
    private Coordinate spawnPoint = null;
    private int probeCounter = 0;
    private long forcedDimensionSeed = 0L;
    private long baseSeed = 0L;
    private int worldVersion = 0;
    public static final int VERSION_OLD = 0;
    public static final int VERSION_CORRECTSEED = 1;
    private TerrainType terrainType = TerrainType.TERRAIN_VOID;
    private BlockMeta baseBlockForTerrain = null;
    private Block fluidForTerrain = null;
    private BlockMeta tendrilBlock = null;
    private BlockMeta canyonBlock = null;
    private BlockMeta[] pyramidBlocks = new BlockMeta[]{BlockMeta.STONE};
    private BlockMeta[] sphereBlocks = new BlockMeta[]{BlockMeta.STONE};
    private BlockMeta[] hugeSphereBlocks = new BlockMeta[]{BlockMeta.STONE};
    private BlockMeta[] liquidSphereBlocks = new BlockMeta[]{BlockMeta.STONE};
    private Block[] liquidSphereFluids = new Block[]{Blocks.field_150355_j};
    private BlockMeta[] hugeLiquidSphereBlocks = new BlockMeta[]{BlockMeta.STONE};
    private Block[] hugeLiquidSphereFluids = new Block[]{Blocks.field_150355_j};
    private BlockMeta[] extraOregen = new BlockMeta[0];
    private Block[] fluidsForLakes = new Block[0];
    private List<MobDescriptor> extraMobs = new ArrayList<MobDescriptor>();
    private boolean peaceful = false;
    private boolean noanimals = false;
    private boolean shelter = false;
    private boolean respawnHere = false;
    private Set<FeatureType> featureTypes = new HashSet<FeatureType>();
    private Set<StructureType> structureTypes = new HashSet<StructureType>();
    private Set<EffectType> effectTypes = new HashSet<EffectType>();
    private ControllerType controllerType = null;
    private List<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
    private static final Map<Integer, Integer> biomeMapping = new HashMap<Integer, Integer>();
    private String digitString = "";
    private Float celestialAngle = null;
    private Float timeSpeed = null;
    private SkyDescriptor skyDescriptor;
    private List<CelestialBodyDescriptor> celestialBodyDescriptors;
    private long patreon1 = 0L;
    private String[] dimensionTypes = new String[0];
    private WeatherDescriptor weatherDescriptor;
    private int actualRfCost;

    public DimensionInformation(String name, DimensionDescriptor descriptor, World world) {
        this.name = name;
        this.descriptor = descriptor;
        this.forcedDimensionSeed = descriptor.getForcedSeed();
        this.baseSeed = DimletConfiguration.randomizeSeed ? (long)(Math.random() * 10000.0 + 1.0) : world.func_72905_C();
        this.worldVersion = 1;
        this.setupFromDescriptor(world.func_72905_C());
        this.setupBiomeMapping();
        this.dump(null);
    }

    private void setupFromDescriptor(long seed) {
        List<Pair<DimletKey, List<DimletKey>>> dimlets = this.descriptor.getDimletsWithModifiers();
        Random random = new Random(this.descriptor.calculateSeed(seed));
        this.actualRfCost = 0;
        DimletType.DIMLET_PATREON.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_TERRAIN.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_FEATURE.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_STRUCTURE.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_BIOME.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_DIGIT.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_SKY.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_MOBS.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_SPECIAL.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_TIME.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_EFFECT.dimletType.constructDimension(dimlets, random, this);
        DimletType.DIMLET_WEATHER.dimletType.constructDimension(dimlets, random, this);
        this.actualRfCost += this.descriptor.getRfMaintainCost();
    }

    public String loadFromJson(String filename) {
        NBTTagCompound tagCompound;
        String json;
        File file = new File(filename);
        try {
            json = FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            return "Error reading file!";
        }
        try {
            tagCompound = (NBTTagCompound)JsonToNBT.func_150315_a((String)json);
        }
        catch (NBTException e) {
            return "NBT Error: " + e.getMessage();
        }
        this.readFromNBT(tagCompound);
        return null;
    }

    public String buildJson(String filename) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.writeToNBT(tagCompound);
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\n");
        RFToolsTools.convertNBTtoJson(buffer, tagCompound, 4);
        buffer.append("}");
        String json = buffer.toString();
        try {
            FileWriter writer = new FileWriter(filename);
            writer.write(json);
            writer.close();
        }
        catch (IOException e) {
            return "Error writing file!";
        }
        return null;
    }

    public void injectDimlet(DimletKey key) {
        DimletType type = key.getType();
        IDimletType itype = type.dimletType;
        if (itype.isInjectable()) {
            this.addToCost(key);
            itype.inject(key, this);
        }
    }

    public DimensionInformation(DimensionDescriptor descriptor, NBTTagCompound tagCompound) {
        this.name = tagCompound.func_74779_i("name");
        this.descriptor = descriptor;
        this.setSpawnPoint(Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"spawnPoint"));
        this.setProbeCounter(tagCompound.func_74762_e("probeCounter"));
        int version = tagCompound.func_74762_e("version");
        if (version == 1) {
            this.setupFromNBT(tagCompound);
        } else {
            this.setupFromDescriptor(1L);
        }
        this.setupBiomeMapping();
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.name = tagCompound.func_74779_i("name");
        this.setSpawnPoint(Coordinate.readFromNBT((NBTTagCompound)tagCompound, (String)"spawnPoint"));
        this.setProbeCounter(tagCompound.func_74762_e("probeCounter"));
        this.setupFromNBT(tagCompound);
        this.setupBiomeMapping();
    }

    public static int[] getIntArraySafe(NBTTagCompound tagCompound, String name) {
        if (!tagCompound.func_74764_b(name)) {
            return new int[0];
        }
        NBTBase tag = tagCompound.func_74781_a(name);
        if (tag instanceof NBTTagIntArray) {
            return tagCompound.func_74759_k(name);
        }
        return new int[0];
    }

    private void setupFromNBT(NBTTagCompound tagCompound) {
        this.terrainType = TerrainType.values()[tagCompound.func_74762_e("terrain")];
        this.featureTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "features"), (Enum[])FeatureType.values());
        this.structureTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "structures"), (Enum[])StructureType.values());
        this.effectTypes = DimensionInformation.toEnumSet((int[])DimensionInformation.getIntArraySafe(tagCompound, "effects"), (Enum[])EffectType.values());
        this.biomes.clear();
        for (int a : DimensionInformation.getIntArraySafe(tagCompound, "biomes")) {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)a);
            if (biome != null) {
                this.biomes.add(biome);
                continue;
            }
            this.biomes.add(BiomeGenBase.field_76772_c);
        }
        this.controllerType = tagCompound.func_74764_b("controller") ? ControllerType.values()[tagCompound.func_74762_e("controller")] : (this.biomes.isEmpty() ? ControllerType.CONTROLLER_DEFAULT : ControllerType.CONTROLLER_SINGLE);
        this.digitString = tagCompound.func_74779_i("digits");
        this.forcedDimensionSeed = tagCompound.func_74763_f("forcedSeed");
        this.baseSeed = tagCompound.func_74763_f("baseSeed");
        this.worldVersion = tagCompound.func_74762_e("worldVersion");
        this.baseBlockForTerrain = this.getBlockMeta(tagCompound, "baseBlock");
        this.tendrilBlock = this.getBlockMeta(tagCompound, "tendrilBlock");
        this.canyonBlock = this.getBlockMeta(tagCompound, "canyonBlock");
        this.fluidForTerrain = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e("fluidBlock"));
        this.hugeLiquidSphereFluids = this.readFluidsFromNBT(tagCompound, "hugeLiquidSphereFluids");
        this.hugeLiquidSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "hugeLiquidSphereBlocks");
        Block oldLiquidSphereFluid = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e("liquidSphereFluid"));
        this.liquidSphereFluids = this.readFluidsFromNBT(tagCompound, "liquidSphereFluids");
        if (this.liquidSphereFluids.length == 0) {
            this.liquidSphereFluids = new Block[]{oldLiquidSphereFluid};
        }
        BlockMeta oldLiquidSphereBlock = this.getBlockMeta(tagCompound, "liquidSphereBlock");
        this.liquidSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "liquidSphereBlocks");
        if (this.liquidSphereBlocks.length == 0) {
            this.liquidSphereBlocks = new BlockMeta[]{oldLiquidSphereBlock};
        }
        this.pyramidBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "pyramidBlocks");
        if (this.pyramidBlocks.length == 0) {
            this.pyramidBlocks = new BlockMeta[]{BlockMeta.STONE};
        }
        BlockMeta oldSphereBlock = this.getBlockMeta(tagCompound, "sphereBlock");
        this.sphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "sphereBlocks");
        if (this.sphereBlocks.length == 0) {
            this.sphereBlocks = new BlockMeta[]{oldSphereBlock};
        }
        this.hugeSphereBlocks = DimensionInformation.readBlockArrayFromNBT(tagCompound, "hugeSphereBlocks");
        this.extraOregen = DimensionInformation.readBlockArrayFromNBT(tagCompound, "extraOregen");
        this.fluidsForLakes = this.readFluidsFromNBT(tagCompound, "lakeFluids");
        this.peaceful = tagCompound.func_74767_n("peaceful");
        this.noanimals = tagCompound.func_74767_n("noanimals");
        this.shelter = tagCompound.func_74767_n("shelter");
        this.respawnHere = tagCompound.func_74767_n("respawnHere");
        this.celestialAngle = tagCompound.func_74764_b("celestialAngle") ? Float.valueOf(tagCompound.func_74760_g("celestialAngle")) : null;
        this.timeSpeed = tagCompound.func_74764_b("timeSpeed") ? Float.valueOf(tagCompound.func_74760_g("timeSpeed")) : null;
        this.probeCounter = tagCompound.func_74762_e("probes");
        this.actualRfCost = tagCompound.func_74762_e("actualCost");
        this.skyDescriptor = new SkyDescriptor.Builder().fromNBT(tagCompound).build();
        this.calculateCelestialBodyDescriptors();
        this.patreon1 = tagCompound.func_74763_f("patreon1");
        this.weatherDescriptor = new WeatherDescriptor.Builder().fromNBT(tagCompound).build();
        this.extraMobs.clear();
        NBTTagList list = tagCompound.func_150295_c("mobs", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tc = list.func_150305_b(i);
            String className = tc.func_74779_i("class");
            int chance = tc.func_74762_e("chance");
            int minGroup = tc.func_74762_e("minGroup");
            int maxGroup = tc.func_74762_e("maxGroup");
            int maxLoaded = tc.func_74762_e("maxLoaded");
            Class<?> c = null;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            MobDescriptor mob = new MobDescriptor(null, c, chance, minGroup, maxGroup, maxLoaded);
            this.extraMobs.add(mob);
        }
        String ds = tagCompound.func_74779_i("dimensionTypes");
        this.dimensionTypes = StringUtils.split((String)ds, (String)",");
        if (this.dimensionTypes == null) {
            this.dimensionTypes = new String[0];
        }
    }

    private Block[] readFluidsFromNBT(NBTTagCompound tagCompound, String name) {
        ArrayList<Block> fluids = new ArrayList<Block>();
        for (int a : DimensionInformation.getIntArraySafe(tagCompound, name)) {
            fluids.add((Block)Block.field_149771_c.func_148754_a(a));
        }
        return fluids.toArray(new Block[fluids.size()]);
    }

    private static BlockMeta[] readBlockArrayFromNBT(NBTTagCompound tagCompound, String name) {
        ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
        int[] blockIds = DimensionInformation.getIntArraySafe(tagCompound, name);
        int[] metas = DimensionInformation.getIntArraySafe(tagCompound, name + "_meta");
        for (int i = 0; i < blockIds.length; ++i) {
            int id = blockIds[i];
            Block block = (Block)Block.field_149771_c.func_148754_a(id);
            int meta = 0;
            if (i < metas.length) {
                meta = metas[i];
            }
            blocks.add(new BlockMeta(block, meta));
        }
        return blocks.toArray(new BlockMeta[blocks.size()]);
    }

    private BlockMeta getBlockMeta(NBTTagCompound tagCompound, String name) {
        Block block = (Block)Block.field_149771_c.func_148754_a(tagCompound.func_74762_e(name));
        int meta = tagCompound.func_74762_e(name + "_meta");
        return new BlockMeta(block, meta);
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("name", this.getName());
        Coordinate spawnPoint = this.getSpawnPoint();
        if (spawnPoint != null) {
            Coordinate.writeToNBT((NBTTagCompound)tagCompound, (String)"spawnPoint", (Coordinate)spawnPoint);
        }
        tagCompound.func_74768_a("probeCounter", this.getProbeCounter());
        tagCompound.func_74768_a("version", 1);
        tagCompound.func_74768_a("terrain", this.terrainType == null ? TerrainType.TERRAIN_VOID.ordinal() : this.terrainType.ordinal());
        tagCompound.func_74783_a("features", DimensionInformation.toIntArray(this.featureTypes));
        tagCompound.func_74783_a("structures", DimensionInformation.toIntArray(this.structureTypes));
        tagCompound.func_74783_a("effects", DimensionInformation.toIntArray(this.effectTypes));
        ArrayList<Integer> c = new ArrayList<Integer>(this.biomes.size());
        for (BiomeGenBase t : this.biomes) {
            if (t != null) {
                c.add(t.field_76756_M);
                continue;
            }
            c.add(BiomeGenBase.field_76772_c.field_76756_M);
        }
        tagCompound.func_74783_a("biomes", ArrayUtils.toPrimitive((Integer[])c.toArray(new Integer[c.size()])));
        tagCompound.func_74768_a("controller", this.controllerType == null ? ControllerType.CONTROLLER_DEFAULT.ordinal() : this.controllerType.ordinal());
        tagCompound.func_74778_a("digits", this.digitString);
        tagCompound.func_74772_a("forcedSeed", this.forcedDimensionSeed);
        tagCompound.func_74772_a("baseSeed", this.baseSeed);
        tagCompound.func_74768_a("worldVersion", this.worldVersion);
        this.setBlockMeta(tagCompound, this.baseBlockForTerrain, "baseBlock");
        this.setBlockMeta(tagCompound, this.tendrilBlock, "tendrilBlock");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.pyramidBlocks, "pyramidBlocks");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.sphereBlocks, "sphereBlocks");
        if (this.sphereBlocks.length > 0) {
            this.setBlockMeta(tagCompound, this.sphereBlocks[0], "sphereBlock");
        }
        DimensionInformation.writeBlocksToNBT(tagCompound, this.hugeSphereBlocks, "hugeSphereBlocks");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.hugeLiquidSphereBlocks, "hugeLiquidSphereBlocks");
        DimensionInformation.writeFluidsToNBT(tagCompound, this.hugeLiquidSphereFluids, "hugeLiquidSphereFluids");
        DimensionInformation.writeBlocksToNBT(tagCompound, this.liquidSphereBlocks, "liquidSphereBlocks");
        if (this.liquidSphereBlocks.length > 0) {
            this.setBlockMeta(tagCompound, this.liquidSphereBlocks[0], "liquidSphereBlock");
        }
        DimensionInformation.writeFluidsToNBT(tagCompound, this.liquidSphereFluids, "liquidSphereFluids");
        if (this.liquidSphereFluids.length > 0) {
            tagCompound.func_74768_a("liquidSphereFluid", Block.field_149771_c.func_148757_b((Object)this.liquidSphereFluids[0]));
        }
        this.setBlockMeta(tagCompound, this.canyonBlock, "canyonBlock");
        tagCompound.func_74768_a("fluidBlock", Block.field_149771_c.func_148757_b((Object)this.fluidForTerrain));
        DimensionInformation.writeBlocksToNBT(tagCompound, this.extraOregen, "extraOregen");
        DimensionInformation.writeFluidsToNBT(tagCompound, this.fluidsForLakes, "lakeFluids");
        tagCompound.func_74757_a("peaceful", this.peaceful);
        tagCompound.func_74757_a("noanimals", this.noanimals);
        tagCompound.func_74757_a("shelter", this.shelter);
        tagCompound.func_74757_a("respawnHere", this.respawnHere);
        if (this.celestialAngle != null) {
            tagCompound.func_74776_a("celestialAngle", this.celestialAngle.floatValue());
        }
        if (this.timeSpeed != null) {
            tagCompound.func_74776_a("timeSpeed", this.timeSpeed.floatValue());
        }
        tagCompound.func_74768_a("probes", this.probeCounter);
        tagCompound.func_74768_a("actualCost", this.actualRfCost);
        this.skyDescriptor.writeToNBT(tagCompound);
        this.weatherDescriptor.writeToNBT(tagCompound);
        tagCompound.func_74772_a("patreon1", this.patreon1);
        NBTTagList list = new NBTTagList();
        for (MobDescriptor mob : this.extraMobs) {
            NBTTagCompound tc = new NBTTagCompound();
            if (mob == null || mob.getEntityClass() == null) continue;
            tc.func_74778_a("class", mob.getEntityClass().getName());
            tc.func_74768_a("chance", mob.getSpawnChance());
            tc.func_74768_a("minGroup", mob.getMinGroup());
            tc.func_74768_a("maxGroup", mob.getMaxGroup());
            tc.func_74768_a("maxLoaded", mob.getMaxLoaded());
            list.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("mobs", (NBTBase)list);
        tagCompound.func_74778_a("dimensionTypes", StringUtils.join((Object[])this.dimensionTypes, (String)","));
    }

    private void setBlockMeta(NBTTagCompound tagCompound, BlockMeta blockMeta, String name) {
        tagCompound.func_74768_a(name, Block.field_149771_c.func_148757_b((Object)blockMeta.getBlock()));
        tagCompound.func_74768_a(name + "_meta", (int)blockMeta.getMeta());
    }

    private static void writeFluidsToNBT(NBTTagCompound tagCompound, Block[] fluids, String name) {
        ArrayList<Integer> c = new ArrayList<Integer>(fluids.length);
        for (Block t : fluids) {
            c.add(Block.field_149771_c.func_148757_b((Object)t));
        }
        tagCompound.func_74783_a(name, ArrayUtils.toPrimitive((Integer[])c.toArray(new Integer[c.size()])));
    }

    private static void writeBlocksToNBT(NBTTagCompound tagCompound, BlockMeta[] blocks, String name) {
        ArrayList<Integer> ids = new ArrayList<Integer>(blocks.length);
        ArrayList<Integer> meta = new ArrayList<Integer>(blocks.length);
        for (BlockMeta t : blocks) {
            ids.add(Block.field_149771_c.func_148757_b((Object)t.getBlock()));
            meta.add(Integer.valueOf(t.getMeta()));
        }
        tagCompound.func_74783_a(name, ArrayUtils.toPrimitive((Integer[])ids.toArray(new Integer[ids.size()])));
        tagCompound.func_74783_a(name + "_meta", ArrayUtils.toPrimitive((Integer[])meta.toArray(new Integer[meta.size()])));
    }

    private static <T extends Enum> int[] toIntArray(Collection<T> collection) {
        ArrayList<Integer> c = new ArrayList<Integer>(collection.size());
        for (Enum t : collection) {
            c.add(t.ordinal());
        }
        return ArrayUtils.toPrimitive((Integer[])c.toArray(new Integer[c.size()]));
    }

    private static <T extends Enum> Set<T> toEnumSet(int[] arr, T[] values) {
        HashSet<T> list = new HashSet<T>();
        for (int a : arr) {
            list.add(values[a]);
        }
        return list;
    }

    private void logDebug(EntityPlayer player, String message) {
        if (player == null) {
            Logging.log((String)message);
        } else {
            Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.YELLOW + message));
        }
    }

    public void dump(EntityPlayer player) {
        String digits = this.getDigitString();
        if (!digits.isEmpty()) {
            this.logDebug(player, "    Digits: " + digits);
        }
        if (this.forcedDimensionSeed != 0L) {
            this.logDebug(player, "    Forced seed: " + this.forcedDimensionSeed);
        }
        if (this.baseSeed != 0L) {
            this.logDebug(player, "    Base seed: " + this.baseSeed);
        }
        this.logDebug(player, "    World version: " + this.worldVersion);
        TerrainType terrainType = this.getTerrainType();
        this.logDebug(player, "    Terrain: " + terrainType.toString());
        this.logDebug(player, "        Base block: " + new ItemStack(this.baseBlockForTerrain.getBlock(), 1, (int)this.baseBlockForTerrain.getMeta()).func_82833_r());
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_TENDRILS)) {
            this.logDebug(player, "        Tendril block: " + new ItemStack(this.tendrilBlock.getBlock(), 1, (int)this.tendrilBlock.getMeta()).func_82833_r());
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_PYRAMIDS)) {
            for (BlockMeta blockMeta : this.pyramidBlocks) {
                if (blockMeta == null) continue;
                this.logDebug(player, "        Pyramid blocks: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_ORBS)) {
            for (BlockMeta blockMeta : this.sphereBlocks) {
                if (blockMeta == null) continue;
                this.logDebug(player, "        Orb blocks: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGEORBS)) {
            for (BlockMeta blockMeta : this.hugeSphereBlocks) {
                if (blockMeta == null) continue;
                this.logDebug(player, "        Huge Orb blocks: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_LIQUIDORBS)) {
            for (BlockMeta blockMeta : this.liquidSphereBlocks) {
                if (blockMeta == null) continue;
                this.logDebug(player, "        Liquid Orb blocks: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGELIQUIDORBS)) {
            for (BlockMeta blockMeta : this.hugeLiquidSphereBlocks) {
                if (blockMeta == null) continue;
                this.logDebug(player, "        Huge Liquid Orb blocks: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_CANYONS)) {
            this.logDebug(player, "        Canyon block: " + new ItemStack(this.canyonBlock.getBlock(), 1, (int)this.canyonBlock.getMeta()).func_82833_r());
        }
        this.logDebug(player, "        Base fluid: " + new ItemStack(this.fluidForTerrain).func_82833_r());
        this.logDebug(player, "    Biome controller: " + (this.controllerType == null ? "<null>" : this.controllerType.name()));
        for (BiomeGenBase biome : this.getBiomes()) {
            if (biome == null) continue;
            this.logDebug(player, "    Biome: " + biome.field_76791_y);
        }
        for (FeatureType featureType : this.getFeatureTypes()) {
            this.logDebug(player, "    Feature: " + featureType.toString());
        }
        for (BlockMeta blockMeta : this.extraOregen) {
            if (blockMeta == null) continue;
            this.logDebug(player, "        Extra ore: " + new ItemStack(blockMeta.getBlock(), 1, (int)blockMeta.getMeta()).func_82833_r());
        }
        for (Block block : this.fluidsForLakes) {
            this.logDebug(player, "        Lake fluid: " + new ItemStack(block).func_82833_r());
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_LIQUIDORBS)) {
            for (Block block : this.liquidSphereFluids) {
                this.logDebug(player, "        Liquid orb fluids: " + new ItemStack(block).func_82833_r());
            }
        }
        if (this.featureTypes.contains((Object)FeatureType.FEATURE_HUGELIQUIDORBS)) {
            for (Block block : this.hugeLiquidSphereFluids) {
                this.logDebug(player, "        Huge Liquid orb fluids: " + new ItemStack(block).func_82833_r());
            }
        }
        for (StructureType structureType : this.getStructureTypes()) {
            this.logDebug(player, "    Structure: " + structureType.toString());
        }
        if (this.structureTypes.contains((Object)StructureType.STRUCTURE_RECURRENTCOMPLEX)) {
            for (String string : this.dimensionTypes) {
                this.logDebug(player, "    RR DimensionType: " + (String)string);
            }
        }
        for (EffectType effectType : this.getEffectTypes()) {
            this.logDebug(player, "    Effect: " + effectType.toString());
        }
        this.logDebug(player, "    Sun brightness: " + this.skyDescriptor.getSunBrightnessFactor());
        this.logDebug(player, "    Star brightness: " + this.skyDescriptor.getStarBrightnessFactor());
        float r = this.skyDescriptor.getSkyColorFactorR();
        float g = this.skyDescriptor.getSkyColorFactorG();
        float b = this.skyDescriptor.getSkyColorFactorB();
        this.logDebug(player, "    Sky color: " + r + ", " + g + ", " + b);
        r = this.skyDescriptor.getFogColorFactorR();
        g = this.skyDescriptor.getFogColorFactorG();
        b = this.skyDescriptor.getFogColorFactorB();
        this.logDebug(player, "    Fog color: " + r + ", " + g + ", " + b);
        SkyType skyType = this.skyDescriptor.getSkyType();
        if (skyType != SkyType.SKY_NORMAL) {
            this.logDebug(player, "    Sky type: " + skyType.toString());
        }
        for (CelestialBodyType bodyType : this.skyDescriptor.getCelestialBodies()) {
            this.logDebug(player, "    Sky body: " + bodyType.name());
        }
        if (this.weatherDescriptor.getRainStrength() > -0.5f) {
            this.logDebug(player, "    Weather rain: " + this.weatherDescriptor.getRainStrength());
        }
        if (this.weatherDescriptor.getThunderStrength() > -0.5f) {
            this.logDebug(player, "    Weather thunder " + this.weatherDescriptor.getThunderStrength());
        }
        for (MobDescriptor mob : this.extraMobs) {
            if (mob == null) continue;
            if (mob.getEntityClass() == null) {
                this.logDebug(player, "    Mob: " + mob);
                continue;
            }
            this.logDebug(player, "    Mob: " + mob.getEntityClass().getName());
        }
        if (this.peaceful) {
            this.logDebug(player, "    Peaceful mode");
        }
        if (this.noanimals) {
            this.logDebug(player, "    No animals mode");
        }
        if (this.shelter) {
            this.logDebug(player, "    Safe shelter");
        }
        if (this.respawnHere) {
            this.logDebug(player, "    Respawn local");
        }
        if (this.celestialAngle != null) {
            this.logDebug(player, "    Celestial angle: " + this.celestialAngle);
        }
        if (this.timeSpeed != null) {
            this.logDebug(player, "    Time speed: " + this.timeSpeed);
        }
        if (this.probeCounter > 0) {
            this.logDebug(player, "    Probes: " + this.probeCounter);
        }
        if (this.patreon1 != 0L) {
            this.logDebug(player, "    Patreon: " + this.patreon1);
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writeEnum((ByteBuf)buf, (Enum)this.terrainType, (Enum)TerrainType.TERRAIN_VOID);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.featureTypes);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.structureTypes);
        NetworkTools.writeEnumCollection((ByteBuf)buf, this.effectTypes);
        buf.writeInt(this.biomes.size());
        for (BiomeGenBase entry : this.biomes) {
            if (entry != null) {
                buf.writeInt(entry.field_76756_M);
                continue;
            }
            buf.writeInt(BiomeGenBase.field_76772_c.field_76756_M);
        }
        NetworkTools.writeEnum((ByteBuf)buf, (Enum)this.controllerType, (Enum)ControllerType.CONTROLLER_DEFAULT);
        NetworkTools.writeString((ByteBuf)buf, (String)this.digitString);
        buf.writeLong(this.forcedDimensionSeed);
        buf.writeLong(this.baseSeed);
        buf.writeInt(this.worldVersion);
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.baseBlockForTerrain.getBlock()));
        buf.writeInt((int)this.baseBlockForTerrain.getMeta());
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.tendrilBlock.getBlock()));
        buf.writeInt((int)this.tendrilBlock.getMeta());
        DimensionInformation.writeBlockArrayToBuf(buf, this.pyramidBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.sphereBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.hugeSphereBlocks);
        DimensionInformation.writeBlockArrayToBuf(buf, this.liquidSphereBlocks);
        DimensionInformation.writeFluidArrayToBuf(buf, this.liquidSphereFluids);
        DimensionInformation.writeBlockArrayToBuf(buf, this.hugeLiquidSphereBlocks);
        DimensionInformation.writeFluidArrayToBuf(buf, this.hugeLiquidSphereFluids);
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.canyonBlock.getBlock()));
        buf.writeInt((int)this.canyonBlock.getMeta());
        buf.writeInt(Block.field_149771_c.func_148757_b((Object)this.fluidForTerrain));
        DimensionInformation.writeBlockArrayToBuf(buf, this.extraOregen);
        DimensionInformation.writeFluidArrayToBuf(buf, this.fluidsForLakes);
        buf.writeBoolean(this.peaceful);
        buf.writeBoolean(this.noanimals);
        buf.writeBoolean(this.shelter);
        buf.writeBoolean(this.respawnHere);
        NetworkTools.writeFloat((ByteBuf)buf, (Float)this.celestialAngle);
        NetworkTools.writeFloat((ByteBuf)buf, (Float)this.timeSpeed);
        buf.writeInt(this.probeCounter);
        buf.writeInt(this.actualRfCost);
        this.skyDescriptor.toBytes(buf);
        this.weatherDescriptor.toBytes(buf);
        buf.writeLong(this.patreon1);
        buf.writeInt(this.extraMobs.size());
        for (MobDescriptor mob : this.extraMobs) {
            if (mob == null || mob.getEntityClass() == null) continue;
            NetworkTools.writeString((ByteBuf)buf, (String)mob.getEntityClass().getName());
            buf.writeInt(mob.getSpawnChance());
            buf.writeInt(mob.getMinGroup());
            buf.writeInt(mob.getMaxGroup());
            buf.writeInt(mob.getMaxLoaded());
        }
        buf.writeInt(this.dimensionTypes.length);
        for (Iterator<Object> iterator : this.dimensionTypes) {
            NetworkTools.writeString((ByteBuf)buf, iterator);
        }
    }

    private static void writeFluidArrayToBuf(ByteBuf buf, Block[] fluids) {
        buf.writeInt(fluids.length);
        for (Block block : fluids) {
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block));
        }
    }

    private static void writeBlockArrayToBuf(ByteBuf buf, BlockMeta[] array) {
        buf.writeInt(array.length);
        for (BlockMeta block : array) {
            buf.writeInt(Block.field_149771_c.func_148757_b((Object)block.getBlock()));
            buf.writeInt((int)block.getMeta());
        }
    }

    public DimensionInformation(String name, DimensionDescriptor descriptor, ByteBuf buf) {
        int i;
        this.name = name;
        this.descriptor = descriptor;
        this.terrainType = (TerrainType)NetworkTools.readEnum((ByteBuf)buf, (Enum[])TerrainType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.featureTypes, (Enum[])FeatureType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.structureTypes, (Enum[])StructureType.values());
        NetworkTools.readEnumCollection((ByteBuf)buf, this.effectTypes, (Enum[])EffectType.values());
        this.biomes.clear();
        int size = buf.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)buf.readInt());
            if (biome != null) {
                this.biomes.add(biome);
                continue;
            }
            this.biomes.add(BiomeGenBase.field_76772_c);
        }
        this.controllerType = (ControllerType)NetworkTools.readEnum((ByteBuf)buf, (Enum[])ControllerType.values());
        this.digitString = NetworkTools.readString((ByteBuf)buf);
        this.forcedDimensionSeed = buf.readLong();
        this.baseSeed = buf.readLong();
        this.worldVersion = buf.readInt();
        Block block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        int meta = buf.readInt();
        this.baseBlockForTerrain = new BlockMeta(block, meta);
        block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        meta = buf.readInt();
        this.tendrilBlock = new BlockMeta(block, meta);
        this.pyramidBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.sphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.hugeSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.liquidSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.liquidSphereFluids = DimensionInformation.readFluidArrayFromBuf(buf);
        this.hugeLiquidSphereBlocks = DimensionInformation.readBlockArrayFromBuf(buf);
        this.hugeLiquidSphereFluids = DimensionInformation.readFluidArrayFromBuf(buf);
        block = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        meta = buf.readInt();
        this.canyonBlock = new BlockMeta(block, meta);
        this.fluidForTerrain = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
        this.extraOregen = DimensionInformation.readBlockArrayFromBuf(buf);
        this.fluidsForLakes = DimensionInformation.readFluidArrayFromBuf(buf);
        this.peaceful = buf.readBoolean();
        this.noanimals = buf.readBoolean();
        this.shelter = buf.readBoolean();
        this.respawnHere = buf.readBoolean();
        this.celestialAngle = NetworkTools.readFloat((ByteBuf)buf);
        this.timeSpeed = NetworkTools.readFloat((ByteBuf)buf);
        this.probeCounter = buf.readInt();
        this.actualRfCost = buf.readInt();
        this.skyDescriptor = new SkyDescriptor.Builder().fromBytes(buf).build();
        this.calculateCelestialBodyDescriptors();
        this.weatherDescriptor = new WeatherDescriptor.Builder().fromBytes(buf).build();
        this.patreon1 = buf.readLong();
        this.extraMobs.clear();
        size = buf.readInt();
        for (i = 0; i < size; ++i) {
            String className = NetworkTools.readString((ByteBuf)buf);
            try {
                Class<?> c = Class.forName(className);
                int chance = buf.readInt();
                int minGroup = buf.readInt();
                int maxGroup = buf.readInt();
                int maxLoaded = buf.readInt();
                MobDescriptor mob = new MobDescriptor(null, c, chance, minGroup, maxGroup, maxLoaded);
                this.extraMobs.add(mob);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        size = buf.readInt();
        this.dimensionTypes = new String[size];
        for (i = 0; i < size; ++i) {
            this.dimensionTypes[i] = NetworkTools.readString((ByteBuf)buf);
        }
        this.setupBiomeMapping();
    }

    private static Block[] readFluidArrayFromBuf(ByteBuf buf) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            blocks.add((Block)Block.field_149771_c.func_148754_a(buf.readInt()));
        }
        return blocks.toArray(new Block[blocks.size()]);
    }

    private static BlockMeta[] readBlockArrayFromBuf(ByteBuf buf) {
        int size = buf.readInt();
        ArrayList<BlockMeta> blocksMeta = new ArrayList<BlockMeta>();
        for (int i = 0; i < size; ++i) {
            Block b = (Block)Block.field_149771_c.func_148754_a(buf.readInt());
            int m = buf.readInt();
            blocksMeta.add(new BlockMeta(b, m));
        }
        return blocksMeta.toArray(new BlockMeta[blocksMeta.size()]);
    }

    public Coordinate getSpawnPoint() {
        return this.spawnPoint;
    }

    public void setSpawnPoint(Coordinate spawnPoint) {
        this.spawnPoint = spawnPoint;
    }

    public void setSkyDescriptor(SkyDescriptor sd) {
        this.skyDescriptor = sd;
        this.calculateCelestialBodyDescriptors();
    }

    private void calculateCelestialBodyDescriptors() {
        List<CelestialBodyType> celestialBodies = this.skyDescriptor.getCelestialBodies();
        int sunidx = -1;
        int bestsun = 0;
        int moonidx = -1;
        int bestmoon = 0;
        for (int i = 0; i < celestialBodies.size(); ++i) {
            CelestialBodyType type = celestialBodies.get(i);
            if (type.getGoodSunFactor() > bestsun) {
                bestsun = type.getGoodSunFactor();
                sunidx = i;
            }
            if (type.getGoodMoonFactor() <= bestmoon) continue;
            bestmoon = type.getGoodMoonFactor();
            moonidx = i;
        }
        Random random = new Random(123L);
        random.nextFloat();
        this.celestialBodyDescriptors = new ArrayList<CelestialBodyDescriptor>();
        for (int i = 0; i < celestialBodies.size(); ++i) {
            CelestialBodyType type = celestialBodies.get(i);
            this.celestialBodyDescriptors.add(new CelestialBodyDescriptor(type, i == sunidx || i == moonidx));
        }
    }

    public static List<Pair<DimletKey, List<DimletKey>>> extractType(DimletType type, List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        ArrayList<Pair<DimletKey, List<DimletKey>>> result = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        for (Pair<DimletKey, List<DimletKey>> dimlet : dimlets) {
            if (((DimletKey)dimlet.getLeft()).getType() != type) continue;
            result.add(dimlet);
        }
        return result;
    }

    public void updateCostFactor(DimletKey key) {
        this.actualRfCost += this.calculateCostFactor(key);
    }

    private int calculateCostFactor(DimletKey key) {
        DimletEntry dimletEntry = KnownDimletConfiguration.getEntry(key);
        if (dimletEntry == null) {
            Logging.logError((String)("Something went wrong for key: " + key));
            return 0;
        }
        return (int)((float)dimletEntry.getRfMaintainCost() * DimletConfiguration.afterCreationCostFactor);
    }

    private void addToCost(DimletKey key) {
        DimletEntry dimletEntry = KnownDimletConfiguration.getEntry(key);
        int rfMaintainCost = dimletEntry.getRfMaintainCost();
        if (rfMaintainCost < 0) {
            int nominalCost = this.descriptor.calculateNominalCost();
            int rfMinimum = Math.max(10, nominalCost * DimletConfiguration.minimumCostPercentage / 100);
            this.actualRfCost -= this.actualRfCost * -rfMaintainCost / 100;
            if (this.actualRfCost < rfMinimum) {
                this.actualRfCost = rfMinimum;
            }
        } else {
            this.actualRfCost += rfMaintainCost;
        }
    }

    public static void getMaterialAndFluidModifiers(List<DimletKey> modifiers, List<BlockMeta> blocks, List<Block> fluids) {
        if (modifiers != null) {
            for (DimletKey modifier : modifiers) {
                if (modifier.getType() == DimletType.DIMLET_MATERIAL) {
                    BlockMeta block = DimletObjectMapping.idToBlock.get(modifier);
                    blocks.add(block);
                    continue;
                }
                if (modifier.getType() != DimletType.DIMLET_LIQUID) continue;
                Block fluid = DimletObjectMapping.idToFluid.get(modifier);
                fluids.add(fluid);
            }
        }
    }

    public BlockMeta getFeatureBlock(Random random, Map<FeatureType, List<DimletKey>> modifiersForFeature, FeatureType featureType) {
        BlockMeta block;
        if (this.featureTypes.contains((Object)featureType)) {
            ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
            ArrayList<Block> fluids = new ArrayList<Block>();
            DimensionInformation.getMaterialAndFluidModifiers(modifiersForFeature.get((Object)featureType), blocks, fluids);
            if (!blocks.isEmpty()) {
                block = (BlockMeta)blocks.get(random.nextInt(blocks.size()));
                if (block == null) {
                    block = BlockMeta.STONE;
                }
            } else if (random.nextFloat() < DimletConfiguration.randomFeatureMaterialChance) {
                DimletKey key = DimletRandomizer.getRandomMaterialBlock(random, true);
                this.actualRfCost += this.calculateCostFactor(key);
                block = DimletObjectMapping.idToBlock.get(key);
            } else {
                block = BlockMeta.STONE;
            }
        } else {
            block = BlockMeta.STONE;
        }
        return block;
    }

    public Block getFeatureLiquid(Random random, Map<FeatureType, List<DimletKey>> modifiersForFeature, FeatureType featureType) {
        Block block;
        if (this.featureTypes.contains((Object)featureType)) {
            ArrayList<BlockMeta> blocks = new ArrayList<BlockMeta>();
            ArrayList<Block> fluids = new ArrayList<Block>();
            DimensionInformation.getMaterialAndFluidModifiers(modifiersForFeature.get((Object)featureType), blocks, fluids);
            if (!fluids.isEmpty()) {
                block = (Block)fluids.get(random.nextInt(fluids.size()));
                if (block == null) {
                    block = Blocks.field_150355_j;
                }
            } else if (random.nextFloat() < DimletConfiguration.randomOrbFluidChance) {
                DimletKey key = DimletRandomizer.getRandomFluidBlock(random, true);
                this.actualRfCost += this.calculateCostFactor(key);
                block = DimletObjectMapping.idToFluid.get(key);
            } else {
                block = Blocks.field_150355_j;
            }
        } else {
            block = Blocks.field_150355_j;
        }
        return block;
    }

    private void setupBiomeMapping() {
        biomeMapping.clear();
        if (this.controllerType == ControllerType.CONTROLLER_FILTERED) {
            BiomeGenBase[] biomeGenArray = BiomeGenBase.func_150565_n();
            final HashSet<Integer> ids = new HashSet<Integer>();
            for (BiomeGenBase biome : this.biomes) {
                if (biome != null) {
                    ids.add(biome.field_76756_M);
                    continue;
                }
                ids.add(BiomeGenBase.field_76772_c.field_76756_M);
            }
            ControllerType.BiomeFilter biomeFilter = new ControllerType.BiomeFilter(){

                @Override
                public boolean match(BiomeGenBase biome) {
                    return ids.contains(biome.field_76756_M);
                }

                @Override
                public double calculateBiomeDistance(BiomeGenBase a, BiomeGenBase b) {
                    return this.calculateBiomeDistance(a, b, false, false, false);
                }
            };
            BiomeControllerMapping.makeFilteredBiomeMap(biomeGenArray, biomeMapping, biomeFilter);
        }
    }

    public DimensionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TerrainType getTerrainType() {
        return this.terrainType;
    }

    public void setTerrainType(TerrainType type) {
        this.terrainType = type;
    }

    public boolean hasFeatureType(FeatureType type) {
        return this.featureTypes.contains((Object)type);
    }

    public Set<FeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public boolean hasStructureType(StructureType type) {
        return this.structureTypes.contains((Object)type);
    }

    public Set<StructureType> getStructureTypes() {
        return this.structureTypes;
    }

    public boolean hasEffectType(EffectType type) {
        return this.effectTypes.contains((Object)type);
    }

    public Set<EffectType> getEffectTypes() {
        return this.effectTypes;
    }

    public List<BiomeGenBase> getBiomes() {
        return this.biomes;
    }

    public Map<Integer, Integer> getBiomeMapping() {
        if (biomeMapping.isEmpty()) {
            this.setupBiomeMapping();
        }
        return biomeMapping;
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public void setControllerType(ControllerType controllerType) {
        this.controllerType = controllerType;
    }

    public String getDigitString() {
        return this.digitString;
    }

    public void setDigitString(String digitString) {
        this.digitString = digitString;
    }

    public BlockMeta getBaseBlockForTerrain() {
        return this.baseBlockForTerrain;
    }

    public void setBaseBlockForTerrain(BlockMeta blockMeta) {
        this.baseBlockForTerrain = blockMeta;
    }

    public BlockMeta getTendrilBlock() {
        return this.tendrilBlock;
    }

    public void setTendrilBlock(BlockMeta block) {
        this.tendrilBlock = block;
    }

    public BlockMeta getCanyonBlock() {
        return this.canyonBlock;
    }

    public void setCanyonBlock(BlockMeta canyonBlock) {
        this.canyonBlock = canyonBlock;
    }

    public BlockMeta[] getPyramidBlocks() {
        return this.pyramidBlocks;
    }

    public void setPyramidBlocks(BlockMeta[] pyramidBlocks) {
        this.pyramidBlocks = pyramidBlocks;
    }

    public BlockMeta[] getSphereBlocks() {
        return this.sphereBlocks;
    }

    public void setSphereBlocks(BlockMeta[] sphereBlocks) {
        this.sphereBlocks = sphereBlocks;
    }

    public BlockMeta[] getHugeSphereBlocks() {
        return this.hugeSphereBlocks;
    }

    public void setHugeSphereBlocks(BlockMeta[] hugeSphereBlocks) {
        this.hugeSphereBlocks = hugeSphereBlocks;
    }

    public BlockMeta[] getLiquidSphereBlocks() {
        return this.liquidSphereBlocks;
    }

    public void setLiquidSphereBlocks(BlockMeta[] liquidSphereBlocks) {
        this.liquidSphereBlocks = liquidSphereBlocks;
    }

    public Block[] getLiquidSphereFluids() {
        return this.liquidSphereFluids;
    }

    public void setLiquidSphereFluids(Block[] liquidSphereFluids) {
        this.liquidSphereFluids = liquidSphereFluids;
    }

    public BlockMeta[] getHugeLiquidSphereBlocks() {
        return this.hugeLiquidSphereBlocks;
    }

    public void setHugeLiquidSphereBlocks(BlockMeta[] hugeLiquidSphereBlocks) {
        this.hugeLiquidSphereBlocks = hugeLiquidSphereBlocks;
    }

    public Block[] getHugeLiquidSphereFluids() {
        return this.hugeLiquidSphereFluids;
    }

    public void setHugeLiquidSphereFluids(Block[] hugeLiquidSphereFluids) {
        this.hugeLiquidSphereFluids = hugeLiquidSphereFluids;
    }

    public BlockMeta[] getExtraOregen() {
        return this.extraOregen;
    }

    public void setExtraOregen(BlockMeta[] blocks) {
        this.extraOregen = blocks;
    }

    public Block getFluidForTerrain() {
        return this.fluidForTerrain;
    }

    public void setFluidForTerrain(Block block) {
        this.fluidForTerrain = block;
    }

    public Block[] getFluidsForLakes() {
        return this.fluidsForLakes;
    }

    public void setFluidsForLakes(Block[] blocks) {
        this.fluidsForLakes = blocks;
    }

    public SkyDescriptor getSkyDescriptor() {
        return this.skyDescriptor;
    }

    public WeatherDescriptor getWeatherDescriptor() {
        return this.weatherDescriptor;
    }

    public void setWeatherDescriptor(WeatherDescriptor weatherDescriptor) {
        this.weatherDescriptor = weatherDescriptor;
    }

    public List<CelestialBodyDescriptor> getCelestialBodyDescriptors() {
        return this.celestialBodyDescriptors;
    }

    public String[] getDimensionTypes() {
        return this.dimensionTypes;
    }

    public void setDimensionTypes(String[] dimensionTypes) {
        this.dimensionTypes = dimensionTypes;
    }

    public List<MobDescriptor> getExtraMobs() {
        return this.extraMobs;
    }

    public boolean isPeaceful() {
        return this.peaceful;
    }

    public void setPeaceful(boolean peaceful) {
        this.peaceful = peaceful;
    }

    public boolean isNoanimals() {
        return this.noanimals;
    }

    public void setNoanimals(boolean noanimals) {
        this.noanimals = noanimals;
    }

    public long getPatreon1() {
        return this.patreon1;
    }

    public boolean isPatreonBitSet(Patreons patreon) {
        return (this.patreon1 & 1L << patreon.getBit()) != 0L;
    }

    public void setPatreon1(long patreon1) {
        this.patreon1 = patreon1;
    }

    public void setPatreonBit(Patreons patreon) {
        this.patreon1 |= 1L << patreon.getBit();
    }

    public boolean isShelter() {
        return this.shelter;
    }

    public void setShelter(boolean shelter) {
        this.shelter = shelter;
    }

    public boolean isRespawnHere() {
        return this.respawnHere;
    }

    public void setRespawnHere(boolean respawnHere) {
        this.respawnHere = respawnHere;
    }

    public Float getCelestialAngle() {
        return this.celestialAngle;
    }

    public Float getTimeSpeed() {
        return this.timeSpeed;
    }

    public void setCelestialAngle(Float celestialAngle) {
        this.celestialAngle = celestialAngle;
    }

    public void setTimeSpeed(Float timeSpeed) {
        this.timeSpeed = timeSpeed;
    }

    public void addProbe() {
        ++this.probeCounter;
    }

    public void removeProbe() {
        --this.probeCounter;
        if (this.probeCounter < 0) {
            this.probeCounter = 0;
        }
    }

    public int getProbeCounter() {
        return this.probeCounter;
    }

    public void setProbeCounter(int probeCounter) {
        this.probeCounter = probeCounter;
    }

    public int getActualRfCost() {
        return this.actualRfCost;
    }

    public long getForcedDimensionSeed() {
        return this.forcedDimensionSeed;
    }

    public long getBaseSeed() {
        return this.baseSeed;
    }

    public int getWorldVersion() {
        return this.worldVersion;
    }
}

