/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.blocks.RFToolsTools;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.varia.BlockMeta;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdDimletCfg
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "";
    }

    @Override
    public String getCommand() {
        return "dimletcfg";
    }

    @Override
    public int getPermissionLevel() {
        return 1;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 1) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        World world = sender.func_130014_f_();
        ItemStack heldItem = null;
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            heldItem = player.func_70694_bm();
        }
        if (heldItem == null || heldItem.func_77973_b() != DimletSetup.knownDimlet) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "You need to hold a known dimlet in your hand!"));
            return;
        }
        DimletKey key = KnownDimletConfiguration.getDimletKey(heldItem, world);
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry != null) {
            Block block;
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "In dimlets.cfg:"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("dimletsettings {"));
            DimletType type = key.getType();
            sender.func_145747_a((IChatComponent)new ChatComponentText("    I:\"rarity." + type.dimletType.getName() + "." + key.getName() + "\"=" + entry.getRarity()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("    I:\"rfcreate." + type.dimletType.getName() + "." + key.getName() + "\"=" + entry.getRfCreateCost()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("    I:\"rfmaintain." + type.dimletType.getName() + "." + key.getName() + "\"=" + entry.getRfMaintainCost()));
            sender.func_145747_a((IChatComponent)new ChatComponentText("    I:\"ticks." + type.dimletType.getName() + "." + key.getName() + "\"=" + entry.getTickCost()));
            if (entry.isRandomNotAllowed()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"expensive." + type.dimletType.getName() + "." + key.getName() + "\"=true"));
            }
            if (entry.isLootNotAllowed()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"noloot." + type.dimletType.getName() + "." + key.getName() + "\"=true"));
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("}"));
            if (!entry.isRandomNotAllowed()) {
                if (type == DimletType.DIMLET_MATERIAL || type == DimletType.DIMLET_LIQUID) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "If you only want this for features (no terrain):"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"expensive." + type.dimletType.getName() + "." + key.getName() + "\"=true"));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "If you don't want this dimlet to be generated random:"));
                    sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"expensive." + type.dimletType.getName() + "." + key.getName() + "\"=true"));
                }
            }
            if (!entry.isLootNotAllowed()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "If you don't want this dimlet to be generated as loot:"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"noloot." + type.dimletType.getName() + "." + key.getName() + "\"=true"));
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "In dimlets.cfg, if you want to blacklist this dimlet:"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("knowndimlets {"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("    I:\"dimlet." + type.dimletType.getName() + "." + key.getName() + "\"=-1"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("}"));
            String modid = null;
            if (type == DimletType.DIMLET_MATERIAL) {
                BlockMeta blockMeta = DimletObjectMapping.idToBlock.get(key);
                if (blockMeta != null) {
                    modid = RFToolsTools.getModidForBlock(blockMeta.getBlock());
                }
            } else if (type == DimletType.DIMLET_LIQUID && (block = DimletObjectMapping.idToFluid.get(key)) != null) {
                modid = RFToolsTools.getModidForBlock(block);
            }
            if (modid != null && !"?".equals(modid)) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + "In dimlets.cfg, if you want to blacklist the entire mod:"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("knowndimlets {"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("    B:\"modban." + type.dimletType.getName() + "." + modid + "\"=true"));
                sender.func_145747_a((IChatComponent)new ChatComponentText("}"));
            }
        }
    }
}

