/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.container.InventoryHelper;
import mcjty.rftools.blocks.dimlets.DimensionEnscriberTileEntity;
import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdCreateTab
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<dimension>";
    }

    @Override
    public String getCommand() {
        return "createtab";
    }

    @Override
    public int getPermissionLevel() {
        return 2;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension parameter is missing!"));
            return;
        }
        if (args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionDescriptor dimensionDescriptor = dimensionManager.getDimensionDescriptor(dim);
        if (dimensionDescriptor == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        if (sender instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)sender;
            ItemStack tab = DimensionEnscriberTileEntity.createRealizedTab(dimensionDescriptor, sender.func_130014_f_());
            InventoryHelper.mergeItemStack((IInventory)player.field_71071_by, (ItemStack)tab, (int)0, (int)35, null);
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This command only works as a player!"));
        }
    }
}

