/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import mcjty.api.MachineInformation;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerContainer;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletObjectMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.varia.BlockTools;
import mcjty.varia.Coordinate;
import mcjty.varia.Logging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SpawnerTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory,
MachineInformation {
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, SpawnerContainer.factory, 1);
    private static final String[] TAGS = new String[]{"matter1", "matter2", "matter3", "mob"};
    private static final String[] TAG_DESCRIPTIONS = new String[]{"The amount of matter in the first slot", "The amount of matter in the second slot", "The amount of matter in the third slot", "The name of the mob being spawned"};
    private float[] matter = new float[]{0.0f, 0.0f, 0.0f};
    private boolean checkSyringe = true;
    private String mobName = "";
    private AxisAlignedBB entityCheckBox = null;

    public SpawnerTileEntity() {
        super(SpawnerConfiguration.SPAWNER_MAXENERGY, SpawnerConfiguration.SPAWNER_RECEIVEPERTICK);
    }

    public int getTagCount() {
        return 4;
    }

    public String getTagName(int index) {
        return TAGS[index];
    }

    public String getTagDescription(int index) {
        return TAG_DESCRIPTIONS[index];
    }

    public String getData(int index, long millis) {
        switch (index) {
            case 0: {
                return Float.toString(this.matter[0]);
            }
            case 1: {
                return Float.toString(this.matter[1]);
            }
            case 2: {
                return Float.toString(this.matter[2]);
            }
            case 3: {
                return this.mobName;
            }
        }
        return null;
    }

    private void testSyringe() {
        if (!this.checkSyringe) {
            return;
        }
        this.checkSyringe = false;
        this.mobName = "";
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack == null || itemStack.field_77994_a == 0) {
            this.clearMatter();
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            this.clearMatter();
            return;
        }
        String mob = tagCompound.func_74779_i("mobName");
        if (mob == null) {
            this.clearMatter();
            return;
        }
        int level = tagCompound.func_74762_e("level");
        if (level < DimletConstructionConfiguration.maxMobInjections) {
            this.clearMatter();
            return;
        }
        this.mobName = mob;
    }

    private void clearMatter() {
        if (this.matter[0] != 0.0f || this.matter[1] != 0.0f || this.matter[2] != 0.0f) {
            this.matter[2] = 0.0f;
            this.matter[1] = 0.0f;
            this.matter[0] = 0.0f;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void addMatter(ItemStack stack, int m) {
        SpawnerConfiguration.MobSpawnAmount spawnAmount;
        this.testSyringe();
        if (this.mobName.isEmpty()) {
            return;
        }
        int materialType = 0;
        Float factor = null;
        List<SpawnerConfiguration.MobSpawnAmount> spawnAmounts = SpawnerConfiguration.mobSpawnAmounts.get(this.mobName);
        Iterator<SpawnerConfiguration.MobSpawnAmount> iterator = spawnAmounts.iterator();
        while (iterator.hasNext() && (factor = (spawnAmount = iterator.next()).match(stack)) == null) {
            ++materialType;
        }
        if (factor == null) {
            return;
        }
        float mm = this.matter[materialType];
        if ((mm += (float)m * factor.floatValue()) > (float)SpawnerConfiguration.maxMatterStorage) {
            mm = SpawnerConfiguration.maxMatterStorage;
        }
        this.matter[materialType] = mm;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float[] getMatter() {
        return this.matter;
    }

    protected void checkStateServer() {
        EntityLiving entityLiving;
        this.testSyringe();
        if (this.mobName.isEmpty()) {
            return;
        }
        List<SpawnerConfiguration.MobSpawnAmount> spawnAmounts = SpawnerConfiguration.mobSpawnAmounts.get(this.mobName);
        for (int i = 0; i < 3; ++i) {
            if (!(this.matter[i] < spawnAmounts.get(i).getAmount())) continue;
            return;
        }
        int rf = SpawnerConfiguration.mobSpawnRf.get(this.mobName);
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.matter[n] = this.matter[n] - spawnAmounts.get(i).getAmount();
        }
        this.func_70296_d();
        DimletKey key = new DimletKey(DimletType.DIMLET_MOBS, this.mobName);
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        ForgeDirection k = BlockTools.getOrientation((int)meta);
        int sx = this.field_145851_c;
        int sy = this.field_145848_d;
        int sz = this.field_145849_e;
        sx += k.offsetX;
        sy += k.offsetY;
        sz += k.offsetZ;
        MobDescriptor descriptor = DimletObjectMapping.idtoMob.get(key);
        try {
            entityLiving = descriptor.getEntityClass().getConstructor(World.class).newInstance(this.field_145850_b);
        }
        catch (InstantiationException e) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobName));
            return;
        }
        catch (IllegalAccessException e) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobName));
            return;
        }
        catch (InvocationTargetException e) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobName));
            return;
        }
        catch (NoSuchMethodException e) {
            Logging.logError((String)("Fail to spawn mob: " + this.mobName));
            return;
        }
        if (k == ForgeDirection.DOWN) {
            sy = (int)((float)sy - (entityLiving.field_70131_O - 1.0f));
        }
        entityLiving.func_70012_b((double)sx + 0.5, (double)sy, (double)sz + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)entityLiving);
    }

    public void useWrench(EntityPlayer player) {
        Coordinate coord = RFTools.instance.clientInfo.getSelectedTE();
        if (coord == null) {
            return;
        }
        Coordinate thisCoord = new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        TileEntity tileEntity = this.field_145850_b.func_147438_o(coord.getX(), coord.getY(), coord.getZ());
        double d = Vec3.func_72443_a((double)coord.getX(), (double)coord.getY(), (double)coord.getZ()).func_72438_d(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e));
        if (d > (double)SpawnerConfiguration.maxBeamDistance) {
            Logging.message((EntityPlayer)player, (String)"Destination distance is too far!");
        } else if (tileEntity instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)tileEntity;
            matterBeamerTileEntity.setDestination(thisCoord);
            Logging.message((EntityPlayer)player, (String)"Destination set!");
        }
        RFTools.instance.clientInfo.setSelectedTE(null);
        RFTools.instance.clientInfo.setDestinationTE(null);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.matter[0] = tagCompound.func_74760_g("matter0");
        this.matter[1] = tagCompound.func_74760_g("matter1");
        this.matter[2] = tagCompound.func_74760_g("matter2");
        this.checkSyringe = tagCompound.func_74767_n("checkSyringe");
        this.mobName = tagCompound.func_74779_i("mobName");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74776_a("matter0", this.matter[0]);
        tagCompound.func_74776_a("matter1", this.matter[1]);
        tagCompound.func_74776_a("matter2", this.matter[2]);
        tagCompound.func_74757_a("checkSyringe", this.checkSyringe);
        tagCompound.func_74778_a("mobName", this.mobName);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public int[] func_94128_d(int side) {
        return SpawnerContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return SpawnerContainer.factory.isInputSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return SpawnerContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        this.checkSyringe = true;
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.checkSyringe = true;
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Spawner Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }
}

