/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.ColorChoiceEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.events.SelectionEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.AbstractContainerWidget;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ColorChoiceLabel;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.shield.DamageTypeMode;
import mcjty.rftools.blocks.shield.PacketGetFilters;
import mcjty.rftools.blocks.shield.ShieldContainer;
import mcjty.rftools.blocks.shield.ShieldRenderingMode;
import mcjty.rftools.blocks.shield.ShieldTEBase;
import mcjty.rftools.blocks.shield.filters.PlayerFilter;
import mcjty.rftools.blocks.shield.filters.ShieldFilter;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiShield
extends GenericGuiContainer<ShieldTEBase> {
    public static final int SHIELD_WIDTH = 256;
    public static final int SHIELD_HEIGHT = 224;
    public static final String ACTION_PASS = "Pass";
    public static final String ACTION_SOLID = "Solid";
    public static final String ACTION_DAMAGE = "Damage";
    public static final String ACTION_SOLIDDAMAGE = "SolDmg";
    public static final String DAMAGETYPE_GENERIC = DamageTypeMode.DAMAGETYPE_GENERIC.getDescription();
    public static final String DAMAGETYPE_PLAYER = DamageTypeMode.DAMAGETYPE_PLAYER.getDescription();
    private EnergyBar energyBar;
    private ChoiceLabel visibilityOptions;
    private ChoiceLabel actionOptions;
    private ChoiceLabel typeOptions;
    private ChoiceLabel damageType;
    private ImageChoiceLabel redstoneMode;
    private WidgetList filterList;
    private TextField player;
    private Button addFilter;
    private Button delFilter;
    private Button upFilter;
    private Button downFilter;
    private List<ShieldFilter> filters = null;
    private int listDirty = 0;
    private static List<ShieldFilter> fromServer_filters = new ArrayList<ShieldFilter>();
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/shieldprojector.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public static void storeFiltersForClient(List<ShieldFilter> filters) {
        fromServer_filters = new ArrayList<ShieldFilter>(filters);
    }

    public GuiShield(ShieldTEBase shieldTileEntity, ShieldContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)shieldTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "shield");
        ShieldTEBase.setCurrentRF((int)shieldTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((ShieldTEBase)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 141, 8, 76))).setShowText(false);
        ShieldTEBase cfr_ignored_0 = (ShieldTEBase)this.tileEntity;
        this.energyBar.setValue(ShieldTEBase.getCurrentRF());
        this.initVisibilityMode();
        this.initActionOptions();
        this.initTypeOptions();
        this.initRedstoneMode();
        this.initDamageType();
        this.filterList = ((WidgetList)this.createStyledList().setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 12, 142, 115))).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiShield.this.selectFilter();
            }
        });
        Slider filterSlider = (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollable((Scrollable)this.filterList).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(156, 12, 10, 115));
        Button applyCamo = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Set")).setTooltips(new String[]{"Set the camouflage block"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(51, 142, 28, 16))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiShield.this.applyCamoToShield();
            }
        });
        ColorChoiceLabel colorSelector = ((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(this.field_146297_k, (Gui)this).addColors(new Integer[]{9895880, 4626687, 16736304, 0x55A0A0, 0xA055A0, 0xFFFFFF}).setTooltips(new String[]{"Color for the shield"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(51, 186, 28, 16))).addChoiceEvent(new ColorChoiceEvent(){

            public void choiceChanged(Widget parent, Integer newColor) {
                GuiShield.this.sendServerCommand(RFToolsMessages.INSTANCE, "setColor", new Argument[]{new Argument("color", newColor.intValue())});
            }
        });
        colorSelector.setCurrentColor(Integer.valueOf(((ShieldTEBase)this.tileEntity).getShieldColor()));
        this.player = (TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Optional player name"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 44, 80, 14));
        this.addFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Add")).setTooltips(new String[]{"Add selected filter"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 64, 36, 12))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiShield.this.addNewFilter();
            }
        });
        this.delFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Del")).setTooltips(new String[]{"Delete selected filter"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(214, 64, 36, 12))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiShield.this.removeSelectedFilter();
            }
        });
        this.upFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Up")).setTooltips(new String[]{"Move filter up"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 78, 36, 12))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiShield.this.moveFilterUp();
            }
        });
        this.downFilter = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Down")).setTooltips(new String[]{"Move filter down"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(214, 78, 36, 12))).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiShield.this.moveFilterDown();
            }
        });
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.visibilityOptions)).addChild((Widget)applyCamo)).addChild((Widget)this.redstoneMode)).addChild((Widget)this.filterList)).addChild((Widget)filterSlider)).addChild((Widget)this.actionOptions)).addChild((Widget)this.typeOptions)).addChild((Widget)this.player)).addChild((Widget)this.addFilter)).addChild((Widget)this.delFilter)).addChild((Widget)this.upFilter)).addChild((Widget)this.downFilter)).addChild((Widget)this.damageType)).addChild((Widget)colorSelector);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.listDirty = 0;
        this.requestFilters();
        ((ShieldTEBase)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }

    private void selectFilter() {
        int selected = this.filterList.getSelected();
        if (selected != -1) {
            boolean damage;
            ShieldFilter shieldFilter = this.filters.get(selected);
            boolean solid = (shieldFilter.getAction() & 1) != 0;
            boolean bl = damage = (shieldFilter.getAction() & 2) != 0;
            if (solid && damage) {
                this.actionOptions.setChoice(ACTION_SOLIDDAMAGE);
            } else if (solid) {
                this.actionOptions.setChoice(ACTION_SOLID);
            } else if (damage) {
                this.actionOptions.setChoice(ACTION_DAMAGE);
            } else {
                this.actionOptions.setChoice(ACTION_PASS);
            }
            String type = shieldFilter.getFilterName();
            if ("default".equals(type)) {
                this.typeOptions.setChoice("All");
            } else if ("animal".equals(type)) {
                this.typeOptions.setChoice("Passive");
            } else if ("hostile".equals(type)) {
                this.typeOptions.setChoice("Hostile");
            } else if ("player".equals(type)) {
                this.typeOptions.setChoice("Player");
            } else if ("item".equals(type)) {
                this.typeOptions.setChoice("Item");
            }
            if (shieldFilter instanceof PlayerFilter) {
                this.player.setText(((PlayerFilter)shieldFilter).getName());
            } else {
                this.player.setText("");
            }
        }
    }

    private void requestFilters() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetFilters(((ShieldTEBase)this.tileEntity).field_145851_c, ((ShieldTEBase)this.tileEntity).field_145848_d, ((ShieldTEBase)this.tileEntity).field_145849_e));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestFilters();
            this.listDirty = 20;
        }
    }

    private void populateFilters() {
        ArrayList<ShieldFilter> newFilters = new ArrayList<ShieldFilter>(fromServer_filters);
        if (newFilters.equals(this.filters)) {
            return;
        }
        this.filters = new ArrayList<ShieldFilter>(newFilters);
        this.filterList.removeChildren();
        for (ShieldFilter filter : this.filters) {
            boolean damage;
            PlayerFilter playerFilter;
            String n = "player".equals(filter.getFilterName()) ? ((playerFilter = (PlayerFilter)filter).getName() == null || playerFilter.getName().isEmpty() ? "players" : "player " + playerFilter.getName()) : filter.getFilterName();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout());
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(n).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDesiredWidth(85));
            boolean solid = (filter.getAction() & 1) != 0;
            boolean bl = damage = (filter.getAction() & 2) != 0;
            String actionName = solid && damage ? ACTION_SOLIDDAMAGE : (solid ? ACTION_SOLID : (damage ? ACTION_DAMAGE : ACTION_PASS));
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(actionName).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT));
            this.filterList.addChild((Widget)panel);
        }
    }

    private void moveFilterUp() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "upFilter", new Argument[]{new Argument("selected", this.filterList.getSelected())});
        this.listDirty = 0;
    }

    private void moveFilterDown() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "downFilter", new Argument[]{new Argument("selected", this.filterList.getSelected())});
        this.listDirty = 0;
    }

    private void addNewFilter() {
        String actionName = this.actionOptions.getCurrentChoice();
        int action = ACTION_PASS.equals(actionName) ? 0 : (ACTION_SOLID.equals(actionName) ? 1 : (ACTION_SOLIDDAMAGE.equals(actionName) ? 3 : 2));
        String filterName = this.typeOptions.getCurrentChoice();
        String type = "All".equals(filterName) ? "default" : ("Passive".equals(filterName) ? "animal" : ("Hostile".equals(filterName) ? "hostile" : ("Item".equals(filterName) ? "item" : "player")));
        String playerName = this.player.getText();
        int selected = this.filterList.getSelected();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "addFilter", new Argument[]{new Argument("action", action), new Argument("type", type), new Argument("player", playerName), new Argument("selected", selected)});
        this.listDirty = 0;
    }

    private void removeSelectedFilter() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "delFilter", new Argument[]{new Argument("selected", this.filterList.getSelected())});
        this.listDirty = 0;
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(31, 186, 16, 16));
        this.redstoneMode.setCurrentChoice(((ShieldTEBase)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((ShieldTEBase)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "rsMode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription())});
    }

    private void initVisibilityMode() {
        this.visibilityOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(31, 161, 48, 14));
        for (ShieldRenderingMode m : ShieldRenderingMode.values()) {
            this.visibilityOptions.addChoices(new String[]{m.getDescription()});
        }
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_INVISIBLE.getDescription(), new String[]{"Shield is completely invisible"});
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SHIELD.getDescription(), new String[]{"Default shield texture"});
        this.visibilityOptions.setChoiceTooltip(ShieldRenderingMode.MODE_SOLID.getDescription(), new String[]{"Use the texture from the supplied block"});
        this.visibilityOptions.setChoice(((ShieldTEBase)this.tileEntity).getShieldRenderingMode().getDescription());
        this.visibilityOptions.addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeVisibilityMode();
            }
        });
    }

    private void initActionOptions() {
        this.actionOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 12, 80, 14));
        this.actionOptions.addChoices(new String[]{ACTION_PASS, ACTION_SOLID, ACTION_DAMAGE, ACTION_SOLIDDAMAGE});
        this.actionOptions.setChoiceTooltip(ACTION_PASS, new String[]{"Entity that matches this filter", "can pass through"});
        this.actionOptions.setChoiceTooltip(ACTION_SOLID, new String[]{"Entity that matches this filter", "cannot pass"});
        this.actionOptions.setChoiceTooltip(ACTION_DAMAGE, new String[]{"Entity that matches this filter", "can pass but gets damage"});
        this.actionOptions.setChoiceTooltip(ACTION_SOLIDDAMAGE, new String[]{"Entity that matches this filter", "cannot pass and gets damage"});
    }

    private void initTypeOptions() {
        this.typeOptions = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 28, 80, 14));
        this.typeOptions.addChoices(new String[]{"All", "Passive", "Hostile", "Item", "Player"});
        this.typeOptions.setChoiceTooltip("All", new String[]{"Matches everything"});
        this.typeOptions.setChoiceTooltip("Passive", new String[]{"Matches passive mobs"});
        this.typeOptions.setChoiceTooltip("Hostile", new String[]{"Matches hostile mobs"});
        this.typeOptions.setChoiceTooltip("Item", new String[]{"Matches items"});
        this.typeOptions.setChoiceTooltip("Player", new String[]{"Matches players", "(optionally named)"});
    }

    private void initDamageType() {
        this.damageType = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(170, 100, 80, 14));
        this.damageType.addChoices(new String[]{DAMAGETYPE_GENERIC, DAMAGETYPE_PLAYER});
        this.damageType.setChoiceTooltip(DAMAGETYPE_GENERIC, new String[]{"Generic damage type"});
        this.damageType.setChoiceTooltip(DAMAGETYPE_PLAYER, new String[]{"Damage as done by a player"});
        this.damageType.addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiShield.this.changeDamageType();
            }
        });
        this.damageType.setChoice(((ShieldTEBase)this.tileEntity).getDamageMode().getDescription());
    }

    private void changeDamageType() {
        ((ShieldTEBase)this.tileEntity).setDamageMode(DamageTypeMode.getMode(this.damageType.getCurrentChoice()));
        this.sendServerCommand(RFToolsMessages.INSTANCE, "damageMode", new Argument[]{new Argument("mode", DamageTypeMode.getMode(this.damageType.getCurrentChoice()).getDescription())});
    }

    private void changeVisibilityMode() {
        ShieldRenderingMode newMode = ShieldRenderingMode.getMode(this.visibilityOptions.getCurrentChoice());
        ((ShieldTEBase)this.tileEntity).setShieldRenderingMode(newMode);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "shieldVisMode", new Argument[]{new Argument("mode", newMode.getDescription())});
    }

    private void applyCamoToShield() {
        Block block;
        ItemStack stack = ((ShieldTEBase)this.tileEntity).func_70301_a(0);
        int pass = 0;
        if (stack != null && (block = Block.func_149634_a((Item)stack.func_77973_b())) != null) {
            pass = block.func_149701_w();
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "applyCamo", new Argument[]{new Argument("pass", pass)});
    }

    private void enableButtons() {
        int sel = this.filterList.getSelected();
        int cnt = this.filterList.getMaximum();
        this.delFilter.setEnabled(sel != -1 && cnt > 0);
        this.upFilter.setEnabled(sel > 0 && cnt > 0);
        this.downFilter.setEnabled(sel < cnt - 1 && sel != -1 && cnt > 0);
        if (sel == -1) {
            this.addFilter.setText("Add");
        } else {
            this.addFilter.setText("Insert");
        }
        this.player.setEnabled("Player".equals(this.typeOptions.getCurrentChoice()));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateFilters();
        this.enableButtons();
        this.drawWindow();
        ShieldTEBase cfr_ignored_0 = (ShieldTEBase)this.tileEntity;
        int currentRF = ShieldTEBase.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((ShieldTEBase)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }
}

