/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modules;

import mcjty.rftools.RFTools;
import mcjty.rftools.apideps.MFRCompatibility;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ScreenModule;
import mcjty.varia.Coordinate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ItemStackScreenModule
implements ScreenModule {
    private int slot1 = -1;
    private int slot2 = -1;
    private int slot3 = -1;
    private int slot4 = -1;
    protected int dim = 0;
    protected Coordinate coordinate = Coordinate.INVALID;

    @Override
    public Object[] getData(World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!world.func_72863_F().func_73149_a(this.coordinate.getX() >> 4, this.coordinate.getZ() >> 4)) {
            return null;
        }
        TileEntity te = world.func_147438_o(this.coordinate.getX(), this.coordinate.getY(), this.coordinate.getZ());
        if (!(te instanceof IInventory)) {
            return null;
        }
        IInventory inventory = (IInventory)te;
        ItemStack stack1 = this.getItemStack(inventory, this.slot1);
        ItemStack stack2 = this.getItemStack(inventory, this.slot2);
        ItemStack stack3 = this.getItemStack(inventory, this.slot3);
        ItemStack stack4 = this.getItemStack(inventory, this.slot4);
        return new Object[]{stack1, stack2, stack3, stack4};
    }

    private ItemStack getItemStack(IInventory inventory, int slot) {
        if (slot == -1) {
            return null;
        }
        if (slot < inventory.func_70302_i_()) {
            if (RFTools.instance.mfr && MFRCompatibility.isExtendedStorage(inventory)) {
                return MFRCompatibility.getContents(inventory);
            }
            if (RFTools.instance.jabba && MFRCompatibility.isExtendedStorage(inventory)) {
                return MFRCompatibility.getContents(inventory);
            }
            return inventory.func_70301_a(slot);
        }
        return null;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, x, y, z);
            if (tagCompound.func_74764_b("slot1")) {
                this.slot1 = tagCompound.func_74762_e("slot1");
            }
            if (tagCompound.func_74764_b("slot2")) {
                this.slot2 = tagCompound.func_74762_e("slot2");
            }
            if (tagCompound.func_74764_b("slot3")) {
                this.slot3 = tagCompound.func_74762_e("slot3");
            }
            if (tagCompound.func_74764_b("slot4")) {
                this.slot4 = tagCompound.func_74762_e("slot4");
            }
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        this.coordinate = Coordinate.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                Coordinate c = new Coordinate(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.getX() - x);
                int dy = Math.abs(c.getY() - y);
                int dz = Math.abs(c.getZ() - z);
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public int getRfPerTick() {
        return ScreenConfiguration.ITEMSTACK_RFPERTICK;
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }
}

