/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ModuleGuiChanged;
import mcjty.rftools.blocks.screens.ModuleProvider;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModule;
import mcjty.rftools.blocks.screens.network.PacketModuleUpdate;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiScreen
extends GenericGuiContainer<ScreenTileEntity> {
    public static final int SCREEN_WIDTH = 256;
    public static final int SCREEN_HEIGHT = 224;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/screen.png");
    private Panel toplevel;
    private ToggleButton[] buttons = new ToggleButton[11];
    private Panel[] modulePanels = new Panel[11];
    private ClientScreenModule[] clientScreenModules = new ClientScreenModule[11];
    private int selected = -1;

    public GuiScreen(ScreenTileEntity screenTileEntity, ScreenContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)screenTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "screens");
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        for (int i = 0; i < 11; ++i) {
            this.buttons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 7 + i * 18 + 1, 40, 16))).setEnabled(false)).setTooltips(new String[]{"Open the gui for this", "module"});
            final int finalI = i;
            this.buttons[i].addButtonEvent(new ButtonEvent(){

                public void buttonClicked(Widget parent) {
                    GuiScreen.this.selectPanel(finalI);
                }
            });
            this.toplevel.addChild((Widget)this.buttons[i]);
            this.modulePanels[i] = null;
            this.clientScreenModules[i] = null;
        }
        this.toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((net.minecraft.client.gui.GuiScreen)this, (Widget)this.toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        this.selected = -1;
    }

    private void selectPanel(int i) {
        this.selected = this.buttons[i].isPressed() ? i : -1;
    }

    private void refreshButtons() {
        for (int i = 0; i < 11; ++i) {
            ItemStack slot = ((ScreenTileEntity)this.tileEntity).func_70301_a(i);
            if (slot != null && slot.func_77973_b() != null && slot.func_77973_b() instanceof ModuleProvider) {
                ModuleProvider moduleProvider = (ModuleProvider)slot.func_77973_b();
                Class<? extends ClientScreenModule> clientScreenModuleClass = moduleProvider.getClientScreenModule();
                if (!clientScreenModuleClass.isInstance(this.clientScreenModules[i])) {
                    this.installModuleGui(i, slot, moduleProvider, clientScreenModuleClass);
                }
            } else {
                this.uninstallModuleGui(i);
            }
            if (this.modulePanels[i] == null) continue;
            this.modulePanels[i].setVisible(this.selected == i);
            this.buttons[i].setPressed(this.selected == i);
        }
    }

    private void uninstallModuleGui(int i) {
        this.buttons[i].setEnabled(false);
        this.buttons[i].setPressed(false);
        this.buttons[i].setText("");
        this.clientScreenModules[i] = null;
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        this.modulePanels[i] = null;
        if (this.selected == i) {
            this.selected = -1;
        }
    }

    private void installModuleGui(int i, final ItemStack slot, ModuleProvider moduleProvider, Class<? extends ClientScreenModule> clientScreenModuleClass) {
        this.buttons[i].setEnabled(true);
        this.toplevel.removeChild((Widget)this.modulePanels[i]);
        try {
            ClientScreenModule clientScreenModule;
            this.clientScreenModules[i] = clientScreenModule = clientScreenModuleClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        NBTTagCompound tagCompound = slot.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        final NBTTagCompound finalTagCompound = tagCompound;
        final int finalI = i;
        this.modulePanels[i] = this.clientScreenModules[i].createGui(this.field_146297_k, (Gui)this, tagCompound, new ModuleGuiChanged(){

            @Override
            public void updateData() {
                slot.func_77982_d(finalTagCompound);
                ((ScreenTileEntity)GuiScreen.this.tileEntity).func_70299_a(finalI, slot);
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketModuleUpdate(((ScreenTileEntity)((GuiScreen)GuiScreen.this).tileEntity).field_145851_c, ((ScreenTileEntity)((GuiScreen)GuiScreen.this).tileEntity).field_145848_d, ((ScreenTileEntity)((GuiScreen)GuiScreen.this).tileEntity).field_145849_e, finalI, finalTagCompound));
            }
        });
        this.modulePanels[i].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(70, 7, 184, 130));
        this.toplevel.addChild((Widget)this.modulePanels[i]);
        this.buttons[i].setText(moduleProvider.getName());
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.refreshButtons();
        this.drawWindow();
    }
}

