/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.awt.Rectangle;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.itemfilter.DimletFilterContainer;
import mcjty.rftools.blocks.itemfilter.DimletFilterTileEntity;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiDimletFilter
extends GenericGuiContainer<DimletFilterTileEntity> {
    public static final int DIMLETFILTER_WIDTH = 211;
    public static final int DIMLETFILTER_HEIGHT = 212;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/dimletfilter.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ImageChoiceLabel[] bits = new ImageChoiceLabel[6];
    private TextField[] minText = new TextField[6];
    private TextField[] maxText = new TextField[6];
    private ChoiceLabel[] types = new ChoiceLabel[6];
    private ChoiceLabel[] craftable = new ChoiceLabel[6];

    public GuiDimletFilter(DimletFilterTileEntity dimletFilterTileEntity, DimletFilterContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)dimletFilterTileEntity, (Container)container, RFTools.GUI_MANUAL_DIMENSION, "filter");
        this.field_146999_f = 211;
        this.field_147000_g = 212;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int[] inputMode = ((DimletFilterTileEntity)this.tileEntity).getInputMode();
        int[] minRarity = ((DimletFilterTileEntity)this.tileEntity).getMinRarity();
        int[] maxRarity = ((DimletFilterTileEntity)this.tileEntity).getMaxRarity();
        int[] craftableI = ((DimletFilterTileEntity)this.tileEntity).getCraftable();
        DimletType[] dimletTypes = ((DimletFilterTileEntity)this.tileEntity).getTypes();
        for (ForgeDirection direction : ForgeDirection.values()) {
            ImageChoiceLabel choiceLabel;
            if (ForgeDirection.UNKNOWN.equals((Object)direction)) continue;
            final int side = direction.ordinal();
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(18, 21 + side * 13, 190, 12));
            this.bits[side] = choiceLabel = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setDesiredWidth(12)).setDesiredHeight(12)).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Input", iconGuiElements, 96, 16).addChoice("2", "Output", iconGuiElements, 80, 16);
            choiceLabel.setCurrentChoice(inputMode[side]);
            choiceLabel.addChoiceEvent(new ChoiceEvent(){

                public void choiceChanged(Widget parent, String newChoice) {
                    GuiDimletFilter.this.changeMode(side);
                }
            });
            Label minLabel = new Label(this.field_146297_k, (Gui)this).setText("R:");
            this.minText[side] = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(12)).setDesiredWidth(24)).addTextEvent(new TextEvent(){

                public void textChanged(Widget parent, String newText) {
                    GuiDimletFilter.this.setMinimumRarity(side);
                }
            });
            this.minText[side].setText(Integer.toString(minRarity[side]));
            this.maxText[side] = ((TextField)((TextField)new TextField(this.field_146297_k, (Gui)this).setDesiredHeight(12)).setDesiredWidth(24)).addTextEvent(new TextEvent(){

                public void textChanged(Widget parent, String newText) {
                    GuiDimletFilter.this.setMaximumRarity(side);
                }
            });
            this.maxText[side].setText(Integer.toString(maxRarity[side]));
            this.types[side] = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredHeight(12)).setDesiredWidth(68)).setTooltips(new String[]{"Filter based on type", "of the dimlet"});
            this.types[side].addChoices(new String[]{"*"});
            for (DimletType type : DimletType.values()) {
                this.types[side].addChoices(new String[]{type.dimletType.getName()});
            }
            if (dimletTypes[side] == null) {
                this.types[side].setChoice("*");
            } else {
                this.types[side].setChoice(dimletTypes[side].dimletType.getName());
            }
            this.types[side].addChoiceEvent(new ChoiceEvent(){

                public void choiceChanged(Widget parent, String newChoice) {
                    GuiDimletFilter.this.setType(side);
                }
            });
            this.craftable[side] = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredHeight(12)).setDesiredWidth(16)).setTooltips(new String[]{"Filter based on craftability", "of the dimlet"});
            this.craftable[side].addChoices(new String[]{"*", "Y", "N"});
            if (craftableI[side] == 0) {
                this.craftable[side].setChoice("*");
            } else if (craftableI[side] == 1) {
                this.craftable[side].setChoice("Y");
            } else {
                this.craftable[side].setChoice("N");
            }
            this.craftable[side].addChoiceEvent(new ChoiceEvent(){

                public void choiceChanged(Widget parent, String newChoice) {
                    GuiDimletFilter.this.setCraftable(side);
                }
            });
            ((Panel)((Panel)((Panel)((Panel)((Panel)panel.addChild((Widget)choiceLabel)).addChild((Widget)minLabel)).addChild((Widget)this.minText[side])).addChild((Widget)this.maxText[side])).addChild((Widget)this.types[side])).addChild((Widget)this.craftable[side]);
            toplevel.addChild((Widget)panel);
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setMinimumRarity(int side) {
        int value = 0;
        try {
            value = Integer.parseInt(this.minText[side].getText());
            if (value < 0) {
                value = 0;
            } else if (value > 6) {
                value = 6;
            }
        }
        catch (NumberFormatException e) {
            value = 0;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMinRarity", new Argument[]{new Argument("side", side), new Argument("value", value)});
    }

    private void setMaximumRarity(int side) {
        int value = 0;
        try {
            value = Integer.parseInt(this.maxText[side].getText());
            if (value < 0) {
                value = 0;
            } else if (value > 6) {
                value = 6;
            }
        }
        catch (NumberFormatException e) {
            value = 0;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMaxRarity", new Argument[]{new Argument("side", side), new Argument("value", value)});
    }

    private void setCraftable(int side) {
        String choice = this.craftable[side].getCurrentChoice();
        int cr = "*".equals(choice) ? 0 : ("Y".equals(choice) ? 1 : 2);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCraftable", new Argument[]{new Argument("side", side), new Argument("craftable", cr)});
    }

    private void setType(int side) {
        String choice = this.types[side].getCurrentChoice();
        int type = "*".equals(choice) ? -1 : DimletType.getTypeByName(choice).ordinal();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setType", new Argument[]{new Argument("side", side), new Argument("type", type)});
    }

    private void changeMode(int side) {
        ImageChoiceLabel choiceLabel = this.bits[side];
        int input = choiceLabel.getCurrentChoiceIndex();
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("side", side), new Argument("input", input)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

