/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerContainer;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.GuiEnvironmentalController;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class EnvironmentalControllerBlock
extends GenericRFToolsBlock
implements Infusable {
    public EnvironmentalControllerBlock() {
        super(Material.field_151573_f, EnvironmentalControllerTileEntity.class, true);
        this.func_149663_c("environmentalControllerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            EnvironmentalControllerTileEntity tileEntity = (EnvironmentalControllerTileEntity)accessor.getTileEntity();
            int rfPerTick = tileEntity.getTotalRfPerTick();
            currenttip.add(EnumChatFormatting.GREEN + "Consuming " + rfPerTick + " RF/tick");
            int radius = tileEntity.getRadius();
            int miny = tileEntity.getMiny();
            int maxy = tileEntity.getMaxy();
            currenttip.add(EnumChatFormatting.GREEN + "Area: radius " + radius + " (between " + miny + " and " + maxy + ")");
            int volume = tileEntity.getVolume();
            currenttip.add(EnumChatFormatting.GREEN + "Volume " + volume + " blocks");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int radius = tagCompound.func_74762_e("radius");
            int miny = tagCompound.func_74762_e("miny");
            int maxy = tagCompound.func_74762_e("maxy");
            list.add(EnumChatFormatting.GREEN + "Area: radius " + radius + " (between " + miny + " and " + maxy + ")");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Control the environment around you with various");
            list.add(EnumChatFormatting.WHITE + "modules. There are modules for things like regeneration,");
            list.add(EnumChatFormatting.WHITE + "speed...");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        EnvironmentalControllerTileEntity environmentalControllerTileEntity = (EnvironmentalControllerTileEntity)tileEntity;
        EnvironmentalControllerContainer environmentalControllerContainer = new EnvironmentalControllerContainer(entityPlayer, environmentalControllerTileEntity);
        return new GuiEnvironmentalController(environmentalControllerTileEntity, environmentalControllerContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new EnvironmentalControllerContainer(entityPlayer, (EnvironmentalControllerTileEntity)tileEntity);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstoneWithTE(world, x, y, z);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 13;
    }

    public String getIdentifyingIconName() {
        return "machineEnvironmentalController";
    }

    public int getGuiID() {
        return RFTools.GUI_ENVIRONMENTAL_CONTROLLER;
    }
}

