/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedObject;
import mcjty.entity.SyncedValue;
import mcjty.network.Argument;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.varia.BlockTools;
import mcjty.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EnderMonitorTileEntity
extends GenericTileEntity {
    public static final String CMD_MODE = "mode";
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;
    private SyncedValue<Boolean> redstoneOut = new SyncedValue((Object)false);

    public EnderMonitorTileEntity() {
        this.registerSyncedObject((SyncedObject)this.redstoneOut);
    }

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.func_70296_d();
    }

    protected void checkStateServer() {
        super.checkStateServer();
        boolean newout = false;
        if (this.needpulse) {
            this.func_70296_d();
            newout = true;
            this.needpulse = false;
        }
        if (newout != (Boolean)this.redstoneOut.getValue()) {
            this.redstoneOut.setValue((Object)newout);
            Logging.log((World)this.field_145850_b, (TileEntity)this, (String)("Ender Monitor output to " + newout));
            this.notifyBlockUpdate();
        }
    }

    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        return BlockTools.setRedstoneSignalOut((int)meta, (boolean)(value == null ? false : value));
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut.setValue((Object)tagCompound.func_74767_n("rs"));
        this.needpulse = tagCompound.func_74767_n("needPulse");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        int m = tagCompound.func_74762_e(CMD_MODE);
        this.mode = EnderMonitorMode.values()[m];
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Boolean value = (Boolean)this.redstoneOut.getValue();
        tagCompound.func_74757_a("rs", value == null ? false : value);
        tagCompound.func_74757_a("needPulse", this.needpulse);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a(CMD_MODE, this.mode.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get(CMD_MODE).getString();
            this.setMode(EnderMonitorMode.getMode(m));
            return true;
        }
        return false;
    }
}

