/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import java.util.Random;
import mcjty.entity.GenericTileEntity;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeAbsorberTileEntity
extends GenericTileEntity {
    private int absorbing = 0;
    private int biomeID = -1;

    protected void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.field_145850_b.field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.field_145850_b.func_72869_a("portal", (double)((float)this.field_145851_c + 0.5f) + x * r, (double)((float)this.field_145848_d + 0.5f) + y * r, (double)((float)this.field_145849_e + 0.5f) + z * r, -x, -y, -z);
        }
    }

    protected void checkStateServer() {
        if (this.absorbing > 0) {
            BiomeGenBase biomeGenBase = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            if (biomeGenBase == null || biomeGenBase.field_76756_M != this.biomeID) {
                return;
            }
            --this.absorbing;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void placeDown() {
        if (this.biomeID == -1) {
            BiomeGenBase biomeGenBase = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e);
            if (biomeGenBase == null) {
                this.biomeID = -1;
                this.absorbing = 0;
            } else if (biomeGenBase.field_76756_M != this.biomeID) {
                this.biomeID = biomeGenBase.field_76756_M;
                this.absorbing = DimletConstructionConfiguration.maxBiomeAbsorbtion;
            }
            this.func_70296_d();
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        tagCompound.func_74768_a("biome", this.biomeID);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        this.biomeID = tagCompound.func_74762_e("biome");
    }
}

