/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.io.File;
import mcjty.network.PacketHandler;
import mcjty.rftools.ClientDisconnectEvent;
import mcjty.rftools.FMLEventHandlers;
import mcjty.rftools.ForgeEventHandlers;
import mcjty.rftools.ForgeOregenHandlers;
import mcjty.rftools.ForgeTerrainGenHandlers;
import mcjty.rftools.GeneralConfiguration;
import mcjty.rftools.RFTools;
import mcjty.rftools.WorldLoadEvent;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.crafter.CrafterConfiguration;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.endergen.EndergenicConfiguration;
import mcjty.rftools.blocks.environmental.EnvironmentalConfiguration;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.shield.ShieldConfiguration;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.crafting.ModCrafting;
import mcjty.rftools.dimension.DimensionTickEvent;
import mcjty.rftools.dimension.ModDimensions;
import mcjty.rftools.gui.GuiProxy;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.netmonitor.NetworkMonitorConfiguration;
import mcjty.rftools.mobs.ModEntities;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.village.VillageSetup;
import mcjty.varia.WrenchChecker;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    public static File modConfigDir;
    private Configuration mainConfig;

    public void preInit(FMLPreInitializationEvent e) {
        modConfigDir = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(modConfigDir.getPath() + File.separator + "rftools", "main.cfg"));
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"rftools");
        RFToolsMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        ModCrafting.init();
        ModDimensions.init();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("general", "General settings");
            cfg.addCustomCategoryComment("crafter", "Settings for the automatic crafter machine");
            cfg.addCustomCategoryComment("screen", "Settings for the screen system");
            cfg.addCustomCategoryComment("spaceProjector", "Settings for the space projector system");
            cfg.addCustomCategoryComment("storagemonitor", "Settings for the storage scanner machine");
            cfg.addCustomCategoryComment("networkmonitor", "Settings for the network monitor item");
            cfg.addCustomCategoryComment("teleporter", "Settings for the teleporter system");
            cfg.addCustomCategoryComment("endergenic", "Settings for the endergenic generator");
            cfg.addCustomCategoryComment("shield", "Settings for the shield system");
            cfg.addCustomCategoryComment("dimlets", "Settings for the dimlet/dimension system");
            cfg.addCustomCategoryComment("dimletconstruction", "Settings for the dimlet construction system");
            cfg.addCustomCategoryComment("environmental", "Settings for the environmental controller system");
            cfg.addCustomCategoryComment("blockprotector", "Settings for the block protector machine");
            cfg.addCustomCategoryComment("storage", "Settings for the modular storage system");
            cfg.addCustomCategoryComment("storageconfig", "Generic item module categories for various items");
            cfg.addCustomCategoryComment("spawner", "Settings for the spawner system");
            cfg.addCustomCategoryComment("mobspawnamounts", "Amount of materials needed to spawn mobs");
            cfg.addCustomCategoryComment("mobspawnrf", "Amount of RF needed to spawn mobs");
            cfg.addCustomCategoryComment("livingmatter", "Blocks and items that are seen as living for the spawner");
            cfg.addCustomCategoryComment("rarity", "General rarity distribution for dimlet selection");
            cfg.addCustomCategoryComment("general", "General dimension configuration");
            cfg.addCustomCategoryComment("mobspawns", "Settings for the mob dimlets");
            cfg.addCustomCategoryComment("recurrentcomplex", "Settings Recurrent Complex structure dimlets");
            GeneralConfiguration.init(cfg);
            NetworkMonitorConfiguration.init(cfg);
            CrafterConfiguration.init(cfg);
            StorageScannerConfiguration.init(cfg);
            TeleportConfiguration.init(cfg);
            EndergenicConfiguration.init(cfg);
            ShieldConfiguration.init(cfg);
            DimletConfiguration.init(cfg);
            DimletConstructionConfiguration.init(cfg);
            EnvironmentalConfiguration.init(cfg);
            SpawnerConfiguration.init(cfg);
            ScreenConfiguration.init(cfg);
            SpaceProjectorConfiguration.init(cfg);
            KnownDimletConfiguration.initGeneralConfig(cfg);
            BlockProtectorConfiguration.init(cfg);
            ModularStorageConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        ModEntities.init();
        VillageSetup.villagerSetup();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)RFTools.instance, (IGuiHandler)new GuiProxy());
        FMLCommonHandler.instance().bus().register((Object)new ClientDisconnectEvent());
        MinecraftForge.EVENT_BUS.register((Object)new WorldLoadEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        MinecraftForge.ORE_GEN_BUS.register((Object)new ForgeOregenHandlers());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ForgeTerrainGenHandlers());
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandlers());
        FMLCommonHandler.instance().bus().register((Object)new DimensionTickEvent());
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.mainConfig = null;
        WrenchChecker.init();
    }
}

