/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.tile;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import java.util.UUID;
import net.lomeli.lomlib.util.ItemUtil;
import net.lomeli.simplecondenser.core.ModConfig;
import net.lomeli.simplecondenser.lib.ItemLib;
import net.lomeli.simplecondenser.lib.enums.AlchemicalType;
import net.lomeli.simplecondenser.lib.enums.RedstoneState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileCondenserBase
extends TileEntity
implements ISidedInventory {
    public static final int TOME_SLOT = 0;
    public static final int TARGET_SLOT = 1;
    public static final int CONDENSER_SIZE = 38;
    private ItemStack[] inventory = new ItemStack[38];
    private ItemStack target;
    private EnergyValue storedEnergyValue = new EnergyValue(0.0f);
    private EnergyValue targetEnergyValue;
    private String customName;
    private AlchemicalType type;
    private RedstoneState redstoneState;

    public TileCondenserBase() {
        this(AlchemicalType.VERDANT);
    }

    public TileCondenserBase(AlchemicalType type) {
        this.type = type;
        this.redstoneState = RedstoneState.HIGH;
    }

    public void func_145845_h() {
        block6: {
            block7: {
                block8: {
                    super.func_145845_h();
                    if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % this.type.getSpeed() != 0L) break block6;
                    if (!this.hasTome()) break block7;
                    if (!this.hasTarget()) {
                        this.targetEnergyValue = null;
                        this.target = null;
                    }
                    if (!this.hasTarget()) break block8;
                    if (this.targetEnergyValue == null || !OreDictionary.itemMatches((ItemStack)this.target, (ItemStack)this.func_70301_a(1), (boolean)false)) {
                        this.targetEnergyValue = this.getTargetEnergyValue();
                        this.target = this.func_70301_a(1);
                    }
                    for (int i = 2; i < this.func_70302_i_(); ++i) {
                        if (this.matchesTarget(i)) continue;
                        this.consumeItem(i);
                    }
                    if (this.storedEnergyValue.compareTo(this.targetEnergyValue) < 0) break block6;
                    this.createNewItem();
                    break block6;
                }
                if (!this.redstoneState.meetsCondition(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) break block6;
                for (int i = 2; i < this.func_70302_i_(); ++i) {
                    this.consumeItem(i);
                }
                break block6;
            }
            if (this.redstoneState.meetsCondition(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                for (int i = 2; i < this.func_70302_i_(); ++i) {
                    this.consumeItem(i);
                }
            }
        }
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        int[] all = new int[this.func_70302_i_() - 2];
        for (int i = 2; i < all.length; ++i) {
            all[i] = i;
        }
        if (side == 1) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 1;
        } else {
            nArray = all;
        }
        return nArray;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (side == 1) {
            if (slot == 0 && this.func_70301_a(0) == null) {
                return ItemLib.isTome(stack);
            }
            if (slot == 1 && this.func_70301_a(1) == null) {
                return this.isStackKnown(stack);
            }
        } else if (side > 1) {
            return !this.matchesTarget(stack) && EnergyValueRegistryProxy.hasEnergyValue((Object)stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (ModConfig.canPullFromSides ? side >= 0 && slot > 1 : side == 0 && slot > 1) {
            return this.hasTarget() ? this.matchesTarget(stack) : true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.func_70302_i_() ? this.inventory[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.func_70302_i_()) {
            this.inventory[slot] = stack;
            if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "tile.simplecondenser." + this.type.getName() + "Condenser.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return ItemLib.isTome(stack);
        }
        if (slot == 1) {
            return this.isStackKnown(stack);
        }
        return slot > 1 && slot < this.inventory.length;
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void setRedstoneState(RedstoneState state) {
        this.redstoneState = state;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slotIndex = tagCompound.func_74771_c("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
        NBTTagCompound energyValueTagCompound = tag.func_74775_l("storedEnergyValue");
        this.storedEnergyValue = !energyValueTagCompound.func_82582_d() ? EnergyValue.loadEnergyValueFromNBT((NBTTagCompound)energyValueTagCompound) : new EnergyValue(0.0f);
        this.type = AlchemicalType.getType(tag.func_74762_e("CondenserType"));
        this.redstoneState = RedstoneState.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
        NBTTagCompound energyValueTagCompound = new NBTTagCompound();
        if (this.storedEnergyValue != null) {
            this.storedEnergyValue.writeToNBT(energyValueTagCompound);
        }
        tag.func_74782_a("storedEnergyValue", (NBTBase)energyValueTagCompound);
        tag.func_74768_a("CondenserType", this.type.getIndex());
        this.redstoneState.writeToNBT(tag);
    }

    public Packet func_145844_m() {
        S35PacketUpdateTileEntity packet = (S35PacketUpdateTileEntity)super.func_145844_m();
        NBTTagCompound dataTag = packet != null ? packet.func_148857_g() : new NBTTagCompound();
        this.func_145841_b(dataTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, dataTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound tag = pkt != null ? pkt.func_148857_g() : new NBTTagCompound();
        this.func_145839_a(tag);
    }

    public AlchemicalType getType() {
        return this.type;
    }

    public void setType(AlchemicalType type) {
        this.type = type;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public EnergyValue getStoredEnergyValue() {
        return this.storedEnergyValue;
    }

    public EnergyValue consumeItem(int slot) {
        if (this.func_70301_a(slot) != null) {
            EnergyValue value;
            ItemStack stack = this.func_70301_a(slot).func_77946_l();
            if (stack.field_77994_a > 1) {
                stack.field_77994_a = 1;
            }
            if ((value = EnergyValueRegistryProxy.getEnergyValue((Object)stack)) != null && value.getValue() > 0.0f) {
                this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() + value.getValue());
                this.func_70298_a(slot, 1);
            }
        }
        return this.storedEnergyValue;
    }

    public EnergyValue setStoredEnergy(float value) {
        this.storedEnergyValue = new EnergyValue(value);
        return this.storedEnergyValue;
    }

    private boolean isStackKnown(ItemStack stack) {
        ItemStack tome = this.func_70301_a(0);
        if (tome != null && tome.func_77973_b() != null) {
            UUID playerUUID = ItemLib.getOwnerUUID(tome);
            return ItemLib.playerKnowsItem(playerUUID, stack);
        }
        return false;
    }

    private boolean matchesTarget(ItemStack stack) {
        ItemStack target = this.func_70301_a(1);
        if (target != null && stack != null) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)stack, (boolean)false);
        }
        return false;
    }

    private boolean matchesTarget(int slot) {
        if (slot > 1 && slot < this.func_70302_i_()) {
            ItemStack stack = this.func_70301_a(slot);
            return this.matchesTarget(stack);
        }
        return false;
    }

    private boolean hasTome() {
        ItemStack stack = this.func_70301_a(0);
        return stack != null && ItemLib.isTome(stack) && ItemLib.getOwnerUUID(stack) != null;
    }

    private boolean hasTarget() {
        ItemStack stack = this.func_70301_a(1);
        return stack != null && this.isStackKnown(stack);
    }

    private EnergyValue getTargetEnergyValue() {
        ItemStack stack = this.func_70301_a(1).func_77946_l();
        if (stack.field_77994_a > 1) {
            stack.field_77994_a = 1;
        }
        return EnergyValueRegistryProxy.getEnergyValue((Object)stack);
    }

    private void depleteStoredEnergy(EnergyValue value) {
        float f = this.storedEnergyValue.getValue() - value.getValue();
        this.storedEnergyValue = new EnergyValue(f >= 0.0f ? f : 0.0f);
    }

    private void createNewItem() {
        ItemStack newStack = this.func_70301_a(1).func_77946_l();
        newStack.field_77994_a = 1;
        for (int i = 2; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null) {
                this.func_70299_a(i, newStack);
                this.depleteStoredEnergy(this.targetEnergyValue);
                return;
            }
            if (!ItemUtil.canStacksMerge((ItemStack)newStack, (ItemStack)stack) || stack.field_77994_a + newStack.field_77994_a > stack.func_77976_d() || stack.field_77994_a + newStack.field_77994_a > this.func_70297_j_()) continue;
            stack.field_77994_a += newStack.field_77994_a;
            this.func_70299_a(i, stack);
            this.depleteStoredEnergy(this.targetEnergyValue);
            return;
        }
    }
}

