/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.lib.enums;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public enum RedstoneState {
    HIGH(0, "high"),
    LOW(1, "low"),
    OFF(2, "off");

    public static final RedstoneState[] VALID_TYPES;
    private final int type;
    private final String unlocal;

    private RedstoneState(int type, String name) {
        this.type = type;
        this.unlocal = "text.simplecondenser.redstonecontrol." + name;
    }

    public int getType() {
        return this.type;
    }

    public String getUnlocal() {
        return this.unlocal;
    }

    public boolean meetsCondition(World world, int x, int y, int z) {
        switch (this.getType()) {
            case 1: {
                return !world.func_72864_z(x, y, z);
            }
            case 2: {
                return true;
            }
        }
        return world.func_72864_z(x, y, z);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("redstoneState", this.getType());
        return tagCompound;
    }

    public static RedstoneState readFromNBT(NBTTagCompound tagCompound) {
        return RedstoneState.getStateFromType(tagCompound.func_74762_e("redstoneState"));
    }

    public static RedstoneState getStateFromType(int type) {
        return type >= 0 && type < VALID_TYPES.length ? VALID_TYPES[type] : VALID_TYPES[0];
    }

    static {
        VALID_TYPES = new RedstoneState[]{HIGH, LOW, OFF};
    }
}

