/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.item;

import com.pahimar.ee3.api.exchange.EnergyValue;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import net.lomeli.lomlib.util.ItemUtil;
import net.lomeli.lomlib.util.MathHelper;
import net.lomeli.lomlib.util.NBTUtil;
import net.lomeli.lomlib.util.ObfUtil;
import net.lomeli.simplecondenser.SimpleCondenser;
import net.lomeli.simplecondenser.item.ItemPortableTablet;
import net.lomeli.simplecondenser.item.ItemSC;
import net.lomeli.simplecondenser.item.ModItems;
import net.lomeli.simplecondenser.lib.ItemLib;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemGreatStar
extends ItemSC {
    public static final String EMC_TAG = "stack_emc";
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemGreatStar() {
        this.func_77625_d(1);
        this.func_77655_b("greatStar");
        this.func_111206_d("greatStar");
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            Block block = world.func_147439_a(x, y, z);
            if (block == ItemLib.ashBlock) {
                if (ItemGreatStar.structureFormed(world, x, y, z, side) && ItemGreatStar.playerHasDust(player, 3, 8) && ItemGreatStar.getStackEMC(stack).getValue() <= 0.0f) {
                    SimpleCondenser.proxy.playSoundAtPlayer(player, "transmute", 1.0f, 1.0f);
                    ItemUtil.dropItemStackIntoWorld((ItemStack)new ItemStack(ModItems.chargedStar), (World)world, (double)x, (double)(y - 2), (double)z, (boolean)true);
                    ItemGreatStar.consumeDust(player, 3, 8);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    ItemGreatStar.consumeStructure(world, x, y, z, side);
                    return true;
                }
            } else if (tile != null && ItemGreatStar.isTransmutationTablet(tile)) {
                if (player.func_70093_af()) {
                    if (ItemGreatStar.getStackEMC(stack).getValue() == 0.0f) {
                        EnergyValue tabletValue = ItemGreatStar.getTabletEnergyValue(tile);
                        for (int i = -1; i <= 1; ++i) {
                            for (int k = -1; k <= 1; ++k) {
                                world.func_147468_f(x + i, y, z + k);
                                world.func_72869_a("explode", (double)(x + i), (double)y, (double)(z + k), world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble());
                            }
                        }
                        SimpleCondenser.proxy.playSoundAtPlayer(player, "transmute", 1.0f, 1.0f);
                        ItemStack tablet = ItemPortableTablet.setTabletEnergy(new ItemStack(ModItems.portableTablet), tabletValue);
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tablet);
                        } else {
                            player.field_71071_by.func_70441_a(tablet);
                        }
                    }
                } else {
                    EnergyValue value = ItemGreatStar.getStackEMC(stack);
                    EnergyValue tabletValue = ItemGreatStar.getTabletEnergyValue(tile);
                    if (value.getValue() > 0.0f) {
                        value = new EnergyValue(value.getValue() + tabletValue.getValue());
                        ItemGreatStar.setTabletEnergyValue(value, tile);
                        ItemGreatStar.setStackEMC(stack, new EnergyValue(0.0f));
                    } else {
                        value = tabletValue;
                        ItemGreatStar.setTabletEnergyValue(new EnergyValue(0.0f), tile);
                        ItemGreatStar.setStackEMC(stack, value);
                    }
                    world.func_147471_g(x, y, z);
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[6];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("simplecondenser:alchemicStorage" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return meta < this.icons.length ? this.icons[meta] : this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        super.func_77624_a(stack, player, list, flag);
        EnergyValue value = ItemGreatStar.getStackEMC(stack);
        if (value.getValue() > 0.0f) {
            list.add(String.format(StatCollector.func_74838_a((String)"text.simplecondenser.storedemc"), energyValueDecimalFormat.format(value.getValue())));
        }
    }

    public static void setStackEMC(ItemStack stack, EnergyValue value) {
        if (stack == null) {
            return;
        }
        NBTTagCompound emcTag = new NBTTagCompound();
        value.writeToNBT(emcTag);
        NBTUtil.setTagCompound((ItemStack)stack, (String)EMC_TAG, (NBTTagCompound)emcTag);
        int meta = value.getValue() > 1200000.0f ? 5 : MathHelper.floor((double)(value.getValue() / 200000.0f));
        stack.func_77964_b(meta);
    }

    public static EnergyValue getStackEMC(ItemStack stack) {
        EnergyValue value = new EnergyValue(0.0f);
        if (stack != null && stack.func_77942_o()) {
            NBTTagCompound emcTag = NBTUtil.getTagCompound((ItemStack)stack, (String)EMC_TAG);
            value.readFromNBT(emcTag);
        }
        return value;
    }

    private static void consumeDust(EntityPlayer player, int dustMeta, int stackSize) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        int size = 0;
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
        ItemStack dustStack = new ItemStack(ItemLib.alchemicalDust, 1, dustMeta);
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && size < stackSize; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !OreDictionary.itemMatches((ItemStack)dustStack, (ItemStack)stack, (boolean)false)) continue;
            int min = Math.min(stackSize - size, stack.field_77994_a);
            player.field_71071_by.func_70298_a(i, min);
            size += min;
        }
    }

    private static boolean playerHasDust(EntityPlayer player, int dustMeta, int stackSize) {
        int size = 0;
        ItemStack dustStack = new ItemStack(ItemLib.alchemicalDust, 1, dustMeta);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !OreDictionary.itemMatches((ItemStack)dustStack, (ItemStack)stack, (boolean)false)) continue;
            size += stack.field_77994_a;
        }
        return size >= stackSize || player.field_71075_bZ.field_75098_d;
    }

    private static boolean structureFormed(World world, int xCoord, int yCoord, int zCoord, int side) {
        int i = 0;
        yCoord += ItemGreatStar.yChange(side);
        zCoord += ItemGreatStar.zChange(side);
        for (int x = (xCoord += ItemGreatStar.xChange(side)) - 1; x < xCoord + 2; ++x) {
            for (int y = yCoord; y < yCoord + 3; ++y) {
                for (int z = zCoord - 1; z < zCoord + 2; ++z) {
                    Block block;
                    if (world.func_147437_c(x, y, z) || (block = world.func_147439_a(x, y, z)) != ItemLib.ashBlock) continue;
                    ++i;
                }
            }
        }
        return i > 25 && world.func_147439_a(xCoord, yCoord + 1, zCoord) == ItemLib.alchemicalChest && world.func_72805_g(xCoord, yCoord + 1, zCoord) == 2;
    }

    private static void consumeStructure(World world, int xCoord, int yCoord, int zCoord, int side) {
        yCoord += ItemGreatStar.yChange(side);
        zCoord += ItemGreatStar.zChange(side);
        for (int x = (xCoord += ItemGreatStar.xChange(side)) - 1; x < xCoord + 2; ++x) {
            for (int y = yCoord; y < yCoord + 3; ++y) {
                for (int z = zCoord - 1; z < zCoord + 2; ++z) {
                    if (world.func_147437_c(x, y, z)) continue;
                    world.func_72869_a("explode", (double)x, (double)y, (double)z, world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble(), world.field_73012_v.nextDouble());
                    world.func_147468_f(x, y, z);
                }
            }
        }
    }

    public static boolean isTransmutationTablet(TileEntity tile) {
        try {
            Class<?> clazz = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            return clazz.isInstance(tile);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static EnergyValue getTabletEnergyValue(Object obj) {
        try {
            Class<?> clazz = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            EnergyValue value = (EnergyValue)ObfUtil.getFieldValue(clazz, (Object)obj, (String[])new String[]{"storedEnergyValue"});
            return value != null ? value : new EnergyValue(0.0f);
        }
        catch (Exception exception) {
            return new EnergyValue(0.0f);
        }
    }

    public static void setTabletEnergyValue(EnergyValue value, Object obj) {
        try {
            Class<?> clazz = Class.forName("com.pahimar.ee3.tileentity.TileEntityTransmutationTablet");
            ObfUtil.setFieldValue(clazz, (Object)obj, (Object)value, (String[])new String[]{"storedEnergyValue"});
            ObfUtil.invokeMethod(clazz, (Object)obj, (String[])new String[]{"updateEnergyValueFromInventory"}, (Object[])new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int xChange(int side) {
        switch (side) {
            case 4: {
                return 1;
            }
            case 5: {
                return -1;
            }
        }
        return 0;
    }

    private static int yChange(int side) {
        switch (side) {
            case 0: {
                return 0;
            }
            case 1: {
                return -2;
            }
        }
        return -1;
    }

    private static int zChange(int side) {
        switch (side) {
            case 2: {
                return 1;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }
}

