/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.client.gui;

import com.pahimar.ee3.client.gui.element.ElementSearchField;
import com.pahimar.ee3.client.gui.element.ElementStatefulButton;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageGuiElementClicked;
import com.pahimar.ee3.network.message.MessageSliderElementUpdated;
import com.pahimar.repackage.cofh.lib.gui.GuiBase;
import com.pahimar.repackage.cofh.lib.gui.GuiColor;
import com.pahimar.repackage.cofh.lib.gui.element.ElementBase;
import com.pahimar.repackage.cofh.lib.gui.element.ElementSlider;
import com.pahimar.repackage.cofh.lib.gui.element.ElementTextField;
import com.pahimar.repackage.cofh.lib.render.RenderHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import net.lomeli.lomlib.util.ResourceUtil;
import net.lomeli.simplecondenser.inventory.ContainerPortableTablet;
import net.lomeli.simplecondenser.inventory.InventoryPortableTablet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

@SideOnly(value=Side.CLIENT)
public class GuiPortableTablet
extends GuiBase {
    public static final ResourceLocation TRANSMUTATION_TABLET = ResourceUtil.getGuiResource((String)"ee3", (String)"transmutationTablet.png");
    public static final String ENERGY_VALUE = "misc.ee3:energy-value";
    private static final int LEFT_MOUSE_BUTTON = 0;
    private static final int RIGHT_MOUSE_BUTTON = 1;
    private static final int SORT_BY_DISPLAY_NAME = 0;
    private static final int SORT_BY_ENERGY_VALUE = 1;
    private static final int SORT_BY_ID = 2;
    private static final int SORT_ASCENDING = 0;
    private static final int SORT_DESCENDING = 1;
    private static final String TOOLTIP_PREFIX = "tooltip.ee3:";
    public static final String TOOLTIP_SORT_BY_DISPLAY_NAME = "tooltip.ee3:sortByDisplayName";
    public static final String TOOLTIP_SORT_BY_ENERGY_VALUE = "tooltip.ee3:sortByEnergyValue";
    public static final String TOOLTIP_SORT_BY_ID = "tooltip.ee3:sortByID";
    public static final String TOOLTIP_SORT_ASCENDING = "tooltip.ee3:sortAscending";
    public static final String TOOLTIP_SORT_DESCENDING = "tooltip.ee3:sortDescending";
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");
    protected int tickCount;
    private InventoryPortableTablet tabletInventory;
    private ElementTextField searchTextField;
    private ElementStatefulButton sortOptionButton;
    private ElementStatefulButton sortOrderButton;
    private ElementSlider slider;

    public GuiPortableTablet(EntityPlayer player, InventoryPortableTablet tabletInventory) {
        super((Container)new ContainerPortableTablet(player, tabletInventory), TRANSMUTATION_TABLET);
        this.tabletInventory = tabletInventory;
        this.field_146999_f = 256;
        this.field_147000_g = 256;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.drawTitle = false;
        this.drawInventory = false;
        this.searchTextField = new ElementSearchField((GuiBase)this, 173, 18, "searchField", 78, 10);
        this.searchTextField.backgroundColor = new GuiColor(0, 0, 0, 0).getColor();
        this.searchTextField.borderColor = new GuiColor(0, 0, 0, 0).getColor();
        this.sortOptionButton = new ElementStatefulButton(this, 151, 36, "sortOption", 0, 0, 18, 0, 36, 0, 18, 18, 54, 18, ResourceUtil.getGuiResource((String)"ee3", (String)"elements/buttonSortOption.png")){

            public void drawBackground(int mouseX, int mouseY, float gameTicks) {
                RenderHelper.bindTexture((ResourceLocation)this.texture);
                if (this.isEnabled()) {
                    if (this.getState() == 0) {
                        this.drawTexturedModalRect(this.posX, this.posY, 36, 0, this.sizeX, this.sizeY);
                    } else if (this.getState() == 1) {
                        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
                    } else if (this.getState() == 2) {
                        this.drawTexturedModalRect(this.posX, this.posY, 18, 0, this.sizeX, this.sizeY);
                    }
                }
            }
        };
        this.sortOrderButton = new ElementStatefulButton(this, 151, 58, "sortOrder", 0, 0, 0, 0, 18, 0, 18, 18, 36, 18, ResourceUtil.getGuiResource((String)"ee3", (String)"elements/buttonSortOrder.png")){

            public void drawBackground(int mouseX, int mouseY, float gameTicks) {
                RenderHelper.bindTexture((ResourceLocation)this.texture);
                if (this.isEnabled()) {
                    if (this.getState() == 0) {
                        this.drawTexturedModalRect(this.posX, this.posY, 0, 0, this.sizeX, this.sizeY);
                    } else if (this.getState() == 1) {
                        this.drawTexturedModalRect(this.posX, this.posY, 18, 0, this.sizeX, this.sizeY);
                    }
                }
            }
        };
        this.setTooltipByState();
        this.slider = new ElementSlider(this, "scrollBar", 239, 36, 12, 201, 187, 0){

            protected void dragSlider(int x, int y) {
                if (y > this._value) {
                    this.setValue(this._value + 1);
                } else {
                    this.setValue(this._value - 1);
                }
            }

            public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageSliderElementUpdated((ElementSlider)this));
                return super.onMouseWheel(mouseX, mouseY, movement);
            }

            public void onStopDragging() {
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageSliderElementUpdated((ElementSlider)this));
            }

            public int getSliderY() {
                return this._value;
            }
        };
        this.slider.backgroundColor = new GuiColor(0, 0, 0, 0).getColor();
        this.slider.borderColor = new GuiColor(0, 0, 0, 0).getColor();
        this.slider.setSliderSize(12, 15);
        this.addElement((ElementBase)this.sortOptionButton);
        this.addElement((ElementBase)this.sortOrderButton);
        this.addElement((ElementBase)this.searchTextField);
        this.addElement((ElementBase)this.slider);
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b(String.format("%s:", StatCollector.func_74838_a((String)ENERGY_VALUE)), 10, 142, 0xFFFFFF);
        this.field_146289_q.func_78276_b(String.format("%s", energyValueDecimalFormat.format(this.tabletInventory.getAvailableEnergyValue().getValue())), 10, 152, 0xFFFFFF);
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.tickCount;
    }

    protected boolean func_146983_a(int key) {
        return false;
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equals("sortOption")) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiElementClicked(buttonName, mouseButton));
            if (mouseButton == 0) {
                if (this.sortOptionButton.getState() == 0) {
                    this.sortOptionButton.setState(1);
                } else if (this.sortOptionButton.getState() == 1) {
                    this.sortOptionButton.setState(2);
                } else if (this.sortOptionButton.getState() == 2) {
                    this.sortOptionButton.setState(0);
                }
            } else if (mouseButton == 1) {
                if (this.sortOptionButton.getState() == 0) {
                    this.sortOptionButton.setState(2);
                } else if (this.sortOptionButton.getState() == 1) {
                    this.sortOptionButton.setState(0);
                } else if (this.sortOptionButton.getState() == 2) {
                    this.sortOptionButton.setState(1);
                }
            }
            this.setTooltipByState();
        } else if (buttonName.equals("sortOrder")) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiElementClicked(buttonName, mouseButton));
            if (this.sortOrderButton.getState() == 0) {
                this.sortOrderButton.setState(1);
            } else if (this.sortOrderButton.getState() == 1) {
                this.sortOrderButton.setState(0);
            }
            this.setTooltipByState();
        }
    }

    private void setTooltipByState() {
        this.sortOptionButton.clearToolTip();
        if (this.sortOptionButton.getState() == 0) {
            this.sortOptionButton.setToolTip(TOOLTIP_SORT_BY_DISPLAY_NAME);
        } else if (this.sortOptionButton.getState() == 1) {
            this.sortOptionButton.setToolTip(TOOLTIP_SORT_BY_ENERGY_VALUE);
        } else if (this.sortOptionButton.getState() == 2) {
            this.sortOptionButton.setToolTip(TOOLTIP_SORT_BY_ID);
        }
        this.sortOrderButton.clearToolTip();
        if (this.sortOrderButton.getState() == 0) {
            this.sortOrderButton.setToolTip(TOOLTIP_SORT_ASCENDING);
        } else if (this.sortOrderButton.getState() == 1) {
            this.sortOrderButton.setToolTip(TOOLTIP_SORT_DESCENDING);
        }
    }
}

