/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.oxygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ThreadFindSeal {
    public AtomicBoolean sealedFinal = new AtomicBoolean();
    public static AtomicBoolean anylooping = new AtomicBoolean();
    public AtomicBoolean looping = new AtomicBoolean();
    private World world;
    private BlockVec3 head;
    private boolean sealed;
    private List<TileEntityOxygenSealer> sealers;
    public HashSet<BlockVec3> checked;
    private int checkCount;
    private HashMap<BlockVec3, TileEntityOxygenSealer> sealersAround;
    private List<BlockVec3> currentLayer;
    private List<BlockVec3> airToReplace;
    private List<BlockVec3> breatheableToReplace;
    private List<BlockVec3> airToReplaceBright;
    private List<BlockVec3> breatheableToReplaceBright;
    private List<TileEntityOxygenSealer> otherSealers;
    private List<BlockVec3> torchesToUpdate;

    public ThreadFindSeal(TileEntityOxygenSealer sealer) {
        this(sealer.func_145831_w(), new BlockVec3(sealer).translate(0, 1, 0), sealer.getFindSealChecks(), new ArrayList<TileEntityOxygenSealer>(Arrays.asList(sealer)));
    }

    public ThreadFindSeal(World world, BlockVec3 head, int checkCount, List<TileEntityOxygenSealer> sealers) {
        this.world = world;
        this.head = head;
        this.checkCount = checkCount;
        this.sealers = sealers;
        this.checked = new HashSet();
        this.torchesToUpdate = new LinkedList<BlockVec3>();
        this.sealersAround = new HashMap();
        for (TileEntityOxygenSealer tile : new ArrayList<TileEntityOxygenSealer>(TileEntityOxygenSealer.loadedTiles)) {
            if (tile.func_145831_w() != world || !(tile.func_145835_a(head.x, head.y, head.z) < 1048576.0)) continue;
            this.sealersAround.put(new BlockVec3(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e), tile);
        }
        if (!sealers.isEmpty()) {
            Block headBlock;
            if (checkCount > 0 && (headBlock = head.getBlockID(this.world)) != null && !headBlock.isAir((IBlockAccess)world, head.x, head.y, head.z)) {
                this.canBlockPassAirCheck(headBlock, this.head, 1);
                this.checkCount = checkCount;
            }
            this.looping.set(true);
            this.check();
        } else {
            this.check();
        }
    }

    public void check() {
        long time1 = System.nanoTime();
        this.sealed = true;
        this.checked.add(this.head.clone());
        this.currentLayer = new LinkedList<BlockVec3>();
        this.airToReplace = new LinkedList<BlockVec3>();
        this.airToReplaceBright = new LinkedList<BlockVec3>();
        if (this.checkCount > 0) {
            this.currentLayer.add(this.head);
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                Block b = this.head.getBlockID_noChunkLoad(this.world);
                if (Blocks.field_150350_a == b) {
                    this.airToReplace.add(this.head.clone());
                } else if (b == GCBlocks.brightAir) {
                    this.airToReplaceBright.add(this.head.clone());
                }
                this.doLayerNearMapEdge();
            } else {
                Block headblock = this.head.getBlockIDsafe_noChunkLoad(this.world);
                if (Blocks.field_150350_a == headblock) {
                    this.airToReplace.add(this.head.clone());
                } else if (headblock == GCBlocks.brightAir) {
                    this.airToReplaceBright.add(this.head.clone());
                }
                this.doLayer();
            }
        } else {
            this.sealed = false;
        }
        long time2 = System.nanoTime();
        if (this.sealers.isEmpty()) {
            this.sealed = false;
        }
        if (this.sealed) {
            this.makeSealGood();
        } else {
            HashSet<BlockVec3> checkedSave = this.checked;
            this.checked = new HashSet();
            this.breatheableToReplace = new LinkedList<BlockVec3>();
            this.breatheableToReplaceBright = new LinkedList<BlockVec3>();
            this.otherSealers = new LinkedList<TileEntityOxygenSealer>();
            this.currentLayer.clear();
            this.currentLayer.add(this.head);
            this.torchesToUpdate.clear();
            if (this.head.x < -29990000 || this.head.z < -29990000 || this.head.x >= 29990000 || this.head.z >= 29990000) {
                this.unsealNearMapEdge();
            } else {
                this.unseal();
            }
            if (!this.otherSealers.isEmpty()) {
                List<TileEntityOxygenSealer> sealersSave = this.sealers;
                List<BlockVec3> torchesSave = this.torchesToUpdate;
                ArrayList<TileEntityOxygenSealer> sealersDone = new ArrayList<TileEntityOxygenSealer>();
                sealersDone.addAll(this.sealers);
                for (TileEntityOxygenSealer otherSealer : this.otherSealers) {
                    if (sealersDone.contains(otherSealer) || otherSealer.getFindSealChecks() <= 0) continue;
                    BlockVec3 newhead = new BlockVec3(otherSealer).translate(0, 1, 0);
                    this.sealed = true;
                    this.checkCount = otherSealer.getFindSealChecks();
                    this.sealers = new LinkedList<TileEntityOxygenSealer>();
                    this.sealers.add(otherSealer);
                    this.checked = new HashSet();
                    this.checked.add(newhead);
                    this.currentLayer.clear();
                    this.airToReplace.clear();
                    this.airToReplaceBright.clear();
                    this.torchesToUpdate = new LinkedList<BlockVec3>();
                    this.currentLayer.add(newhead.clone());
                    if (newhead.x < -29990000 || newhead.z < -29990000 || newhead.x >= 29990000 || newhead.z >= 29990000) {
                        this.doLayerNearMapEdge();
                    } else {
                        this.doLayer();
                    }
                    if (this.sealed) {
                        TileEntityOxygenSealer oldHead;
                        if (ConfigManagerCore.enableDebug) {
                            GCLog.info("Oxygen Sealer replacing head at x" + this.head.x + " y" + (this.head.y - 1) + " z" + this.head.z);
                        }
                        if (!sealersSave.isEmpty() && !this.sealers.contains(oldHead = (TileEntityOxygenSealer)sealersSave.get(0))) {
                            this.sealers.add(oldHead);
                        }
                        this.head = newhead.clone();
                        otherSealer.threadSeal = this;
                        otherSealer.stopSealThreadCooldown = 75 + TileEntityOxygenSealer.countEntities;
                        checkedSave.addAll(this.checked);
                        break;
                    }
                    sealersDone.addAll(this.sealers);
                    checkedSave.addAll(this.checked);
                }
                if (!this.sealed) {
                    this.sealers = sealersSave;
                    this.torchesToUpdate = torchesSave;
                } else {
                    this.makeSealGood();
                }
            }
            this.checked = checkedSave;
            if (!this.sealed) {
                if (this.head.getBlockID(this.world) == GCBlocks.breatheableAir) {
                    this.breatheableToReplace.add(this.head);
                }
                if (this.head.getBlockID(this.world) == GCBlocks.brightBreatheableAir) {
                    this.breatheableToReplaceBright.add(this.head);
                }
                this.makeSealBad();
            }
        }
        TileEntityOxygenSealer headSealer = this.sealersAround.get(this.head.clone().translate(0, -1, 0));
        if (headSealer != null) {
            headSealer.stopSealThreadCooldown += 75;
        }
        for (TileEntityOxygenSealer sealer : this.sealers) {
            if (sealer == headSealer || headSealer == null) continue;
            sealer.threadSeal = this;
            sealer.stopSealThreadCooldown = headSealer.stopSealThreadCooldown + 51;
        }
        this.looping.set(false);
        if (ConfigManagerCore.enableDebug) {
            long time3 = System.nanoTime();
            GCLog.info("Oxygen Sealer Check Completed at x" + this.head.x + " y" + this.head.y + " z" + this.head.z);
            GCLog.info("   Sealed: " + this.sealed);
            GCLog.info("   Loop Time taken: " + (double)(time2 - time1) / 1000000.0 + "ms");
            GCLog.info("   Place Time taken: " + (double)(time3 - time2) / 1000000.0 + "ms");
            GCLog.info("   Total Time taken: " + (double)(time3 - time1) / 1000000.0 + "ms");
            GCLog.info("   Found: " + this.sealers.size() + " sealers");
            GCLog.info("   Looped through: " + this.checked.size() + " blocks");
        }
        this.sealedFinal.set(this.sealed);
    }

    private void makeSealGood() {
        if (!this.airToReplace.isEmpty() || !this.airToReplaceBright.isEmpty()) {
            LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
            Block breatheableAirID = GCBlocks.breatheableAir;
            for (BlockVec3 checkedVec : this.airToReplace) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), breatheableAirID, 0));
            }
            for (BlockVec3 checkedVec : this.airToReplaceBright) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), GCBlocks.brightBreatheableAir, 0));
            }
            TickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
        }
        if (!this.torchesToUpdate.isEmpty()) {
            TickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
        }
    }

    private void makeSealBad() {
        if (!this.breatheableToReplace.isEmpty() || !this.breatheableToReplaceBright.isEmpty()) {
            LinkedList<ScheduledBlockChange> changeList = new LinkedList<ScheduledBlockChange>();
            for (BlockVec3 checkedVec : this.breatheableToReplace) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), Blocks.field_150350_a, 0));
            }
            for (BlockVec3 checkedVec : this.breatheableToReplaceBright) {
                changeList.add(new ScheduledBlockChange(checkedVec.clone(), GCBlocks.brightAir, 0));
            }
            TickHandlerServer.scheduleNewBlockChange(this.world.field_73011_w.field_76574_g, changeList);
        }
        if (!this.torchesToUpdate.isEmpty()) {
            TickHandlerServer.scheduleNewTorchUpdate(this.world.field_73011_w.field_76574_g, this.torchesToUpdate);
        }
    }

    private void unseal() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        BlockFire fireBlock = Blocks.field_150480_ab;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                do {
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    Block id = sideVec.getBlockIDsafe_noChunkLoad(this.world);
                    if (id == breatheableAirID) {
                        this.breatheableToReplace.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == breatheableAirIDBright) {
                        this.breatheableToReplaceBright.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == fireBlock) {
                        nextLayer.add(sideVec);
                        this.breatheableToReplace.add(sideVec);
                        continue;
                    }
                    if (id == oxygenSealerID) {
                        TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                        if (sealer != null && !this.sealers.contains(sealer)) {
                            if (side != 0) continue;
                            this.otherSealers.add(sealer);
                            checkedLocal.add(sideVec);
                            continue;
                        }
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    checkedLocal.add(sideVec);
                    if (id == null || Blocks.field_150350_a == id || id == GCBlocks.brightAir || !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    nextLayer.add(sideVec);
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void unsealNearMapEdge() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        BlockFire fireBlock = Blocks.field_150480_ab;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                for (int side = 0; side < 6; ++side) {
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    Block id = sideVec.getBlockID_noChunkLoad(this.world);
                    if (id == breatheableAirID) {
                        this.breatheableToReplace.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == breatheableAirIDBright) {
                        this.breatheableToReplaceBright.add(sideVec);
                        nextLayer.add(sideVec);
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    if (id == fireBlock) {
                        nextLayer.add(sideVec);
                        this.breatheableToReplace.add(sideVec);
                        continue;
                    }
                    if (id == oxygenSealerID) {
                        TileEntityOxygenSealer sealer = this.sealersAround.get(sideVec);
                        if (sealer != null && !this.sealers.contains(sealer)) {
                            if (side != 0) continue;
                            this.otherSealers.add(sealer);
                            checkedLocal.add(sideVec);
                            continue;
                        }
                        checkedLocal.add(sideVec);
                        continue;
                    }
                    checkedLocal.add(sideVec);
                    if (id == null || Blocks.field_150350_a == id || id == GCBlocks.brightAir || !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    nextLayer.add(sideVec);
                }
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayer() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block airID = Blocks.field_150350_a;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block airIDBright = GCBlocks.brightAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                do {
                    Block id;
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    if (this.checkCount > 0) {
                        TileEntityOxygenSealer sealer;
                        --this.checkCount;
                        checkedLocal.add(sideVec);
                        id = sideVec.getBlockIDsafe_noChunkLoad(this.world);
                        if (id == breatheableAirID) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id == airID) {
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == breatheableAirIDBright) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id == airIDBright) {
                            nextLayer.add(sideVec);
                            this.airToReplaceBright.add(sideVec);
                            continue;
                        }
                        if (id == null) {
                            this.checkCount = 0;
                            this.sealed = false;
                            return;
                        }
                        if (this.canBlockPassAirCheck(id, sideVec, side)) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        if (side == 0) {
                            this.sealers.add(sealer);
                            this.checkCount += sealer.getFindSealChecks();
                            continue;
                        }
                        checkedLocal.remove(sideVec);
                        continue;
                    }
                    id = sideVec.getBlockIDsafe_noChunkLoad(this.world);
                    if (id != null && id != airID && id != breatheableAirID && id != airIDBright && id != breatheableAirIDBright && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    return;
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private void doLayerNearMapEdge() {
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block airID = Blocks.field_150350_a;
        Block breatheableAirIDBright = GCBlocks.brightBreatheableAir;
        Block airIDBright = GCBlocks.brightAir;
        Block oxygenSealerID = GCBlocks.oxygenSealer;
        HashSet<BlockVec3> checkedLocal = this.checked;
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        while (this.sealed && this.currentLayer.size() > 0) {
            for (BlockVec3 vec : this.currentLayer) {
                int side = 0;
                do {
                    Block id;
                    BlockVec3 sideVec;
                    if (vec.sideDone[side] || checkedLocal.contains(sideVec = vec.newVecSide(side))) continue;
                    if (this.checkCount > 0) {
                        TileEntityOxygenSealer sealer;
                        --this.checkCount;
                        checkedLocal.add(sideVec);
                        id = sideVec.getBlockID_noChunkLoad(this.world);
                        if (id == breatheableAirID) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id == airID) {
                            nextLayer.add(sideVec);
                            this.airToReplace.add(sideVec);
                            continue;
                        }
                        if (id == breatheableAirIDBright) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id == airIDBright) {
                            nextLayer.add(sideVec);
                            this.airToReplaceBright.add(sideVec);
                            continue;
                        }
                        if (id == null) {
                            this.checkCount = 0;
                            this.sealed = false;
                            return;
                        }
                        if (this.canBlockPassAirCheck(id, sideVec, side)) {
                            nextLayer.add(sideVec);
                            continue;
                        }
                        if (id != oxygenSealerID || (sealer = this.sealersAround.get(sideVec)) == null || this.sealers.contains(sealer)) continue;
                        if (side == 0) {
                            this.sealers.add(sealer);
                            this.checkCount += sealer.getFindSealChecks();
                            continue;
                        }
                        checkedLocal.remove(sideVec);
                        continue;
                    }
                    id = sideVec.getBlockID_noChunkLoad(this.world);
                    if (id != null && id != airID && id != breatheableAirID && id != airIDBright && id != breatheableAirIDBright && !this.canBlockPassAirCheck(id, sideVec, side)) continue;
                    this.sealed = false;
                    return;
                } while (++side < 6);
            }
            this.currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
    }

    private boolean canBlockPassAirCheck(Block block, BlockVec3 vec, int side) {
        ArrayList<Integer> metaList;
        if (block instanceof BlockLeavesBase) {
            return true;
        }
        if (block.func_149662_c()) {
            return block instanceof BlockGravel || block.func_149688_o() == Material.field_151580_n || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return false;
        }
        if (OxygenPressureProtocol.nonPermeableBlocks.containsKey(block) && ((metaList = OxygenPressureProtocol.nonPermeableBlocks.get(block)).contains(-1) || metaList.contains(vec.getBlockMetadata((IBlockAccess)this.world)))) {
            return false;
        }
        if (block instanceof IPartialSealableBlock) {
            IPartialSealableBlock blockPartial = (IPartialSealableBlock)block;
            if (blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)side))) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            for (int i = 0; i < 6; ++i) {
                if (i == side || !blockPartial.isSealed(this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
                vec.setSideDone(i ^ 1);
            }
            return true;
        }
        if (block instanceof BlockUnlitTorch) {
            this.torchesToUpdate.add(vec);
            return true;
        }
        if (block instanceof BlockSlab) {
            boolean isTopSlab;
            boolean bl = isTopSlab = (vec.getBlockMetadata((IBlockAccess)this.world) & 8) == 8;
            if (side == 0 && isTopSlab || side == 1 && !isTopSlab) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            vec.setSideDone(isTopSlab ? 1 : 0);
            return true;
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            if (side == 1) {
                this.checked.remove(vec);
                --this.checkCount;
                return false;
            }
            vec.setSideDone(0);
            return true;
        }
        if (block instanceof BlockPistonBase) {
            BlockPistonBase piston = (BlockPistonBase)block;
            int meta = vec.getBlockMetadata((IBlockAccess)this.world);
            if (BlockPistonBase.func_150075_c((int)meta)) {
                int facing = BlockPistonBase.func_150076_b((int)meta);
                if (side == facing) {
                    this.checked.remove(vec);
                    --this.checkCount;
                    return false;
                }
                vec.setSideDone(facing ^ 1);
                return true;
            }
            return false;
        }
        if (block.isSideSolid((IBlockAccess)this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)(side ^ 1)))) {
            if (block.func_149688_o().func_76230_c() && block.func_149686_d()) {
                return false;
            }
            this.checked.remove(vec);
            --this.checkCount;
            return false;
        }
        if (block.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == (side ^ 1) || !block.isSideSolid((IBlockAccess)this.world, vec.x, vec.y, vec.z, ForgeDirection.getOrientation((int)i))) continue;
            vec.setSideDone(i);
        }
        return true;
    }

    public class ThreadedFindSeal
    extends Thread {
        public ThreadedFindSeal() {
            super("GC Sealer Roomfinder Thread");
            anylooping.set(true);
            if (this.isAlive()) {
                this.interrupt();
            }
            this.start();
        }

        @Override
        public void run() {
            ThreadFindSeal.this.check();
            anylooping.set(false);
        }
    }
}

