/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileBaseConductor
extends TileEntityAdvanced
implements IConductor {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TickHandlerServer.energyTransmitterUpdates.add(this);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public IElectricityNetwork getNetwork() {
        if (this.network == null) {
            EnergyNetwork network = new EnergyNetwork();
            network.getTransmitters().add(this);
            this.setNetwork(network);
        }
        return (IElectricityNetwork)this.network;
    }

    @Override
    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    @Override
    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            this.getNetwork().refresh();
            BlockVec3 thisVec = new BlockVec3(this);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side);
                if (tileEntity == null || tileEntity.getClass() != this.getClass() || !(tileEntity instanceof INetworkProvider) || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                ((INetworkProvider)tileEntity).getNetwork().merge(this.getNetwork());
            }
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[6];
            BlockVec3 thisVec = new BlockVec3(this);
            for (int i = 0; i < 6; ++i) {
                ForgeDirection side = ForgeDirection.getOrientation((int)i);
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side);
                if (!(tileEntity instanceof IConnector) || !((IConnector)tileEntity).canConnect(side.getOpposite(), NetworkType.POWER)) continue;
                this.adjacentConnections[i] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    @Override
    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return type == NetworkType.POWER;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.POWER;
    }
}

