/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.renderer;

import java.util.HashSet;
import java.util.Set;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.entity.GarageDoorTileEntity;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.world.IBlockAccess;

public class GarageDoorRenderer
extends MalisisRenderer {
    private GarageDoorTileEntity tileEntity;
    protected int direction;
    protected boolean opened;
    protected boolean reversed;
    protected boolean topBlock;
    protected Set<GarageDoorTileEntity> childDoors = new HashSet<GarageDoorTileEntity>();
    protected AnimationRenderer ar = new AnimationRenderer();

    protected void initialize() {
        this.shape = new Cube().setSize(0.1875f, 1.0f, 1.0f);
        this.shape.storeState();
        this.rp = new RenderParameters();
        this.rp.renderAllFaces.set((Object)true);
        this.rp.calculateAOColor.set((Object)false);
        this.rp.useBlockBounds.set((Object)false);
        this.rp.useBlockBrightness.set((Object)false);
        this.rp.calculateBrightness.set((Object)false);
        this.rp.interpolateUV.set((Object)false);
        this.rp.useWorldSensitiveIcon.set((Object)false);
    }

    public void render() {
        if (this.renderType == RenderType.ITEM_INVENTORY) {
            this.enableBlending();
            this.shape.resetState();
            this.shape.translate(0.40625f, 0.0f, 0.0f);
            this.rp.icon.set(null);
            this.blockMetadata = 8;
            this.drawShape(this.shape, this.rp);
            return;
        }
        this.tileEntity = (GarageDoorTileEntity)((Object)TileEntityUtils.getTileEntity(GarageDoorTileEntity.class, (IBlockAccess)this.world, (int)this.x, (int)this.y, (int)this.z));
        if (this.tileEntity == null || !this.tileEntity.isTopDoor()) {
            this.getBlockDamage = false;
            return;
        }
        this.getBlockDamage = true;
        this.direction = this.tileEntity.getDirection();
        this.opened = this.tileEntity.isOpened();
        this.reversed = this.tileEntity.isReversed();
        this.rp.icon.set(null);
        this.enableBlending();
        this.renderTileEntity();
    }

    protected void renderTileEntity() {
        int t = 10;
        this.ar.setStartTime(this.tileEntity.getTimer().getStart());
        this.childDoors.clear();
        this.tileEntity.addChildDoors(this.childDoors);
        for (GarageDoorTileEntity te : this.childDoors) {
            this.shape.resetState();
            this.shape.rotate((float)(-90 * this.tileEntity.getDirection()), 0.0f, 1.0f, 0.0f);
            this.shape.translate(0.40625f, 0.0f, 0.0f);
            this.y = te.field_145848_d;
            int delta = this.tileEntity.field_145848_d - te.field_145848_d;
            int delta2 = this.childDoors.size() - (delta + 1);
            this.blockMetadata = delta == 0 ? (this.blockMetadata |= 8) : (this.blockMetadata &= 0xFFFFFFF7);
            Transformation verticalAnim = new Translation(0.0f, (float)(-delta), 0.0f, 0.0f, 0.0f, 0.0f).forTicks(t * delta, 0);
            ParallelTransformation topRotate = new ParallelTransformation(new Transformation[]{new Translation(0.0f, 1.0f, 0.0f).forTicks(t, 0), new Rotation(0.0f, -90.0f).aroundAxis(0.0f, 0.0f, 1.0f).offset(-0.5f, -0.5f, 0.0f).forTicks(t, 0)});
            Transformation horizontalAnim = new Translation(0.0f, 0.0f, 0.0f, 0.0f, (float)delta2, 0.0f).forTicks(t * delta2, 0);
            ChainedTransformation chained = new ChainedTransformation(new Transformation[]{verticalAnim, topRotate, horizontalAnim});
            if (this.tileEntity.getState() == DoorState.CLOSING || this.tileEntity.getState() == DoorState.CLOSED) {
                chained.reversed(true);
            }
            this.rp.brightness.set((Object)this.block.func_149677_c(this.world, this.x, this.y, this.z));
            this.ar.animate(this.shape, (Transformation)chained);
            this.drawShape(this.shape, this.rp);
        }
        this.y = this.tileEntity.field_145848_d;
    }

    public void renderDestroyProgress() {
        this.rp.icon.set((Object)damagedIcons[this.destroyBlockProgress.func_73106_e()]);
        int y = this.y - this.destroyBlockProgress.func_73109_c();
        this.shape.resetState();
        this.shape.rotate((float)(-90 * this.tileEntity.getDirection()), 0.0f, 1.0f, 0.0f);
        this.shape.translate(0.41125f, (float)(-y), 0.0f);
        this.shape.scale(1.011f);
        this.drawShape(this.shape, this.rp);
    }

    protected boolean isCurrentBlockDestroyProgress(DestroyBlockProgress dbp) {
        if (dbp.func_73110_b() == this.x && dbp.func_73109_c() == this.y && dbp.func_73108_d() == this.z) {
            return true;
        }
        for (GarageDoorTileEntity te : this.childDoors) {
            if (dbp.func_73110_b() != te.field_145851_c || dbp.func_73109_c() != te.field_145848_d || dbp.func_73108_d() != te.field_145849_e) continue;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }
}

