/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class VanishingDoorMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        if (opened && type != BoundingBoxType.RAYTRACE) {
            return null;
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
        }
        if (dir == 3) {
            z = 0.8125f;
        }
        if (dir == 0) {
            X = 0.1875f;
        }
        if (dir == 2) {
            x = 0.8125f;
        }
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        AlphaTransform alpha = new AlphaTransform(255, 0);
        alpha.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        alpha.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return new Animation[]{new Animation((ITransformable)rp, (Transformation)alpha)};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

