/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;

public class Sliding4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        float left = -0.8125f;
        float right = 0.8125f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float X = 1.0f;
        float Y = 1.0f;
        float Z = 1.0f;
        if (dir == 1) {
            Z = 0.1875f;
            if (opened && topBlock == reversed) {
                x += reversed ? left : right;
                X += reversed ? left : right;
            }
        }
        if (dir == 3) {
            z = 0.8125f;
            if (opened && topBlock == reversed) {
                x += reversed ? right : left;
                X += reversed ? right : left;
            }
        }
        if (dir == 0) {
            X = 0.1875f;
            if (opened && topBlock == reversed) {
                z += reversed ? right : left;
                Z += reversed ? right : left;
            }
        }
        if (dir == 2) {
            x = 0.8125f;
            if (opened && topBlock == reversed) {
                z += reversed ? left : right;
                Z += reversed ? left : right;
            }
        }
        if (opened && topBlock == !reversed) {
            y += reversed ? left : right;
            Y = topBlock || type == BoundingBoxType.SELECTION ? (Y += reversed ? left : right) : 0.0f;
        }
        if (type == BoundingBoxType.SELECTION && !opened) {
            if (!topBlock) {
                Y += 1.0f;
            } else {
                y -= 1.0f;
            }
        }
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)X, (double)Y, (double)Z);
    }

    private Transformation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float dir = 0.8125f;
        float toX = 0.0f;
        float toY = 0.0f;
        if (tileEntity.isReversed()) {
            dir = -dir;
        }
        if (topBlock != tileEntity.isReversed()) {
            toY = dir;
        } else {
            toX = dir;
        }
        Translation translation = new Translation(toX, toY, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return translation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

