/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.ParallelTransformation;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class DoubleRotateMovement
implements IDoorMovement {
    boolean rightDirection = false;

    public DoubleRotateMovement(boolean right) {
        this.rightDirection = right;
    }

    @Override
    public AxisAlignedBB getBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        int dir = tileEntity.getDirection();
        boolean opened = tileEntity.isOpened();
        boolean reversed = tileEntity.isReversed();
        if (reversed != this.rightDirection && opened) {
            return null;
        }
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.1875);
        if (opened) {
            AABBUtils.rotate((AxisAlignedBB)aabb, (int)(this.rightDirection ? -1 : 1));
        }
        AABBUtils.rotate((AxisAlignedBB)aabb, (ForgeDirection)Door.intToDir(dir));
        if (type == BoundingBoxType.SELECTION) {
            if (!topBlock) {
                aabb.field_72337_e += 1.0;
            } else {
                aabb.field_72338_b -= 1.0;
            }
        }
        return aabb;
    }

    private Transformation getTransformation(DoorTileEntity tileEntity) {
        boolean reversed = tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED;
        int ot = tileEntity.getDescriptor().getOpeningTime();
        float angle = 90.0f;
        float hingeX = 0.40625f;
        float hingeZ = -0.40625f;
        if (tileEntity.isReversed()) {
            hingeX = -hingeX;
            angle = -angle;
        }
        Rotation rotation = new Rotation(angle);
        rotation.aroundAxis(0.0f, 1.0f, 0.0f).offset(hingeX, 0.0f, hingeZ);
        rotation.reversed(reversed);
        rotation.forTicks(ot);
        if (tileEntity.isReversed() != this.rightDirection) {
            float x = 1.8125f;
            if (this.rightDirection) {
                x *= -1.0f;
            }
            Translation translation = (Translation)((Translation)new Translation(0.0f, 0.0f, 0.0f, x, 0.0f, 0.0f).reversed(reversed)).forTicks(ot);
            return new ParallelTransformation(new Transformation[]{translation, rotation}).forTicks(ot);
        }
        return rotation;
    }

    @Override
    public Animation[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model, this.getTransformation(tileEntity))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

