/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door;

import cpw.mods.fml.common.registry.GameRegistry;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.item.DoorItem;
import net.malisis.doors.door.movement.IDoorMovement;
import net.malisis.doors.door.movement.RotatingDoorMovement;
import net.malisis.doors.door.sound.IDoorSound;
import net.malisis.doors.door.sound.VanillaDoorSound;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DoorDescriptor {
    private Block block;
    private Item item;
    private Material material = Material.field_151575_d;
    private float hardness = 3.0f;
    private Block.SoundType soundType = Block.field_149766_f;
    private String name;
    private String textureName;
    private int autoCloseTime = 0;
    private IDoorMovement movement;
    private IDoorSound sound;
    private int openingTime = 6;
    private boolean doubleDoor = true;
    private boolean requireRedstone = false;
    private CreativeTabs tab;
    private int maxStackSize = 1;
    private Object[] recipe;
    private int numCrafted = 1;

    public DoorDescriptor() {
        this.movement = DoorRegistry.getMovement(RotatingDoorMovement.class);
        this.sound = DoorRegistry.getSound(VanillaDoorSound.class);
    }

    public DoorDescriptor(NBTTagCompound nbt) {
        if (nbt != null) {
            this.readNBT(nbt);
        } else {
            this.movement = DoorRegistry.getMovement(RotatingDoorMovement.class);
            this.sound = DoorRegistry.getSound(VanillaDoorSound.class);
        }
    }

    public Block getBlock() {
        return this.block;
    }

    public Item getItem() {
        return this.item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public float getHardness() {
        return this.hardness;
    }

    public void setHardness(float hardness) {
        this.hardness = hardness;
    }

    public Block.SoundType getSoundType() {
        return this.soundType;
    }

    public void setSoundType(Block.SoundType soundType) {
        this.soundType = soundType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTextureName() {
        return this.textureName != null ? this.textureName : this.name;
    }

    public void setTextureName(String textureName) {
        this.textureName = textureName;
    }

    public IDoorMovement getMovement() {
        return this.movement;
    }

    public void setMovement(IDoorMovement movement) {
        this.movement = movement;
    }

    public IDoorSound getSound() {
        return this.sound;
    }

    public void setSound(IDoorSound sound) {
        this.sound = sound;
    }

    public int getOpeningTime() {
        return this.openingTime;
    }

    public void setOpeningTime(int openingTime) {
        this.openingTime = openingTime;
    }

    public boolean isDoubleDoor() {
        return this.doubleDoor;
    }

    public void setDoubleDoor(boolean doubleDoor) {
        this.doubleDoor = doubleDoor;
    }

    public boolean requireRedstone() {
        return this.requireRedstone;
    }

    public void setRequireRedstone(boolean requireRedstone) {
        this.requireRedstone = requireRedstone;
    }

    public int getAutoCloseTime() {
        return this.autoCloseTime;
    }

    public void setAutoCloseTime(int autoCloseTime) {
        this.autoCloseTime = autoCloseTime;
    }

    public CreativeTabs getTab() {
        return this.tab;
    }

    public void setTab(CreativeTabs tab) {
        this.tab = tab;
    }

    public Object[] getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Object ... recipe) {
        this.recipe = recipe;
    }

    public int getNumCrafted() {
        return this.numCrafted;
    }

    public void setNumCrafted(int numCrafted) {
        this.numCrafted = numCrafted;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("textureName")) {
            this.textureName = nbt.func_74779_i("textureName");
        }
        if (nbt.func_74764_b("hardness")) {
            this.hardness = nbt.func_74760_g("hardness");
        }
        if (nbt.func_74764_b("block")) {
            this.block = Block.func_149729_e((int)nbt.func_74762_e("block"));
        }
        if (nbt.func_74764_b("item")) {
            this.item = Item.func_150899_d((int)nbt.func_74762_e("item"));
        }
        if (nbt.func_74764_b("movement")) {
            this.setMovement(DoorRegistry.getMovement(nbt.func_74779_i("movement")));
        }
        if (nbt.func_74764_b("sound")) {
            this.setSound(DoorRegistry.getSound(nbt.func_74779_i("sound")));
        }
        if (nbt.func_74764_b("openingTime")) {
            this.setOpeningTime(nbt.func_74762_e("openingTime"));
        }
        if (nbt.func_74764_b("redstone")) {
            this.setRequireRedstone(nbt.func_74767_n("redstone"));
        }
        if (nbt.func_74764_b("doubleDoor")) {
            this.setDoubleDoor(nbt.func_74767_n("doubleDoor"));
        }
        if (nbt.func_74764_b("autoCloseTime")) {
            this.setAutoCloseTime(nbt.func_74762_e("autoCloseTime"));
        }
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("block", Block.func_149682_b((Block)this.block));
        nbt.func_74768_a("item", Item.func_150891_b((Item)this.item));
        if (this.getMovement() != null) {
            nbt.func_74778_a("movement", DoorRegistry.getId(this.getMovement()));
        }
        if (this.getSound() != null) {
            nbt.func_74778_a("sound", DoorRegistry.getId(this.getSound()));
        }
        nbt.func_74768_a("openingTime", this.getOpeningTime());
        nbt.func_74757_a("redstone", this.requireRedstone());
        nbt.func_74757_a("doubleDoor", this.isDoubleDoor());
        nbt.func_74768_a("autoCloseTime", this.getAutoCloseTime());
    }

    public void set(Block block, Item item) {
        this.block = block;
        this.item = item;
    }

    public void create() {
        this.block = new Door(this);
        this.item = new DoorItem(this);
    }

    public DoorDescriptor register() {
        if (this.block == null || this.item == null) {
            this.create();
        }
        GameRegistry.registerBlock((Block)this.block, (String)this.block.func_149739_a().substring(5));
        GameRegistry.registerItem((Item)this.item, (String)this.item.func_77658_a());
        if (this.recipe != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.item, this.numCrafted), (Object[])this.recipe);
        }
        return this;
    }
}

