/*
 * Decompiled with CFR 0.152.
 */
package igwmod.gui;

import cpw.mods.fml.common.eventhandler.Event;
import igwmod.InfoSupplier;
import igwmod.TickHandler;
import igwmod.WikiUtils;
import igwmod.api.BlockWikiEvent;
import igwmod.api.EntityWikiEvent;
import igwmod.api.ItemWikiEvent;
import igwmod.api.PageChangeEvent;
import igwmod.api.WikiRegistry;
import igwmod.gui.BrowseHistory;
import igwmod.gui.ContainerBlockWiki;
import igwmod.gui.IPageLink;
import igwmod.gui.IReservedSpace;
import igwmod.gui.IWidget;
import igwmod.gui.LocatedStack;
import igwmod.gui.LocatedString;
import igwmod.gui.LocatedTexture;
import igwmod.gui.ReservedSpace;
import igwmod.gui.tabs.IWikiTab;
import igwmod.lib.Textures;
import igwmod.lib.Util;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiWiki
extends GuiContainer {
    private static String currentFile = "";
    private static List<String> fileInfo = new ArrayList<String>();
    public static List<IWikiTab> wikiTabs = new ArrayList<IWikiTab>();
    private static IWikiTab currentTab;
    private static int currentTabPage;
    private static String currentModIdPage;
    private static List<IPageLink> visibleWikiPages;
    private static int matchingWikiPages;
    private static final List<LocatedStack> locatedStacks;
    private static final List<LocatedString> locatedStrings;
    private static final List<IWidget> locatedTextures;
    private static final ResourceLocation scrollbarTexture;
    private static float currentPageLinkScroll;
    private static float currentPageScroll;
    private static int currentPageTranslation;
    private boolean isScrollingPageLink;
    private boolean isScrollingPage;
    private boolean wasClicking;
    private int lastMouseX;
    private GuiButton previousButton;
    private GuiButton nextButton;
    private static GuiTextField searchField;
    private static final int PAGE_LINK_SCROLL_X = 80;
    private static final int PAGE_LINK_SCROLL_HEIGHT = 214;
    private static final int PAGE_LINK_SCROLL_Y = 14;
    private static final int PAGE_SCROLL_X = 240;
    private static final int PAGE_SCROLL_HEIGHT = 230;
    private static final int PAGE_SCROLL_Y = 4;
    public static final double TEXT_SCALE = 0.5;
    public static final int MAX_TEXT_Y = 453;
    public static final int MIN_TEXT_Y = 10;
    private static RenderItem renderItem;
    private static EntityItem entityItem;

    public GuiWiki() {
        super((Container)new ContainerBlockWiki());
        this.field_146291_p = true;
        this.field_147000_g = 238;
        this.field_146999_f = 256;
        if (currentTab == null) {
            currentTab = wikiTabs.get(0);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        String lastSearch = "";
        if (searchField != null) {
            lastSearch = searchField.func_146179_b();
        }
        searchField = new GuiTextField(this.field_146289_q, this.field_147003_i + 40, this.field_147009_r + currentTab.getSearchBarAndScrollStartY(), 53, this.field_146289_q.field_78288_b);
        searchField.func_146203_f(15);
        searchField.func_146185_a(true);
        searchField.func_146189_e(true);
        searchField.func_146195_b(false);
        searchField.func_146205_d(true);
        searchField.func_146180_a(lastSearch);
        this.updateSearch();
        this.previousButton = new GuiButton(0, this.field_147003_i + 40, this.field_147009_r + 4, 25, 10, "<--");
        this.nextButton = new GuiButton(1, this.field_147003_i + 68, this.field_147009_r + 4, 25, 10, "-->");
        this.previousButton.field_146124_l = BrowseHistory.canGoPrevious();
        this.nextButton.field_146124_l = BrowseHistory.canGoNext();
        this.field_146292_n.add(this.previousButton);
        this.field_146292_n.add(this.nextButton);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }

    public void func_146284_a(GuiButton button) {
        BrowseHistory history = button.field_146127_k == 0 ? BrowseHistory.previous() : BrowseHistory.next();
        currentFile = history.link;
        currentTab = history.tab;
        currentTabPage = this.getPageNumberForTab(currentTab);
        currentTab.onPageChange(this, currentFile, history.meta);
        this.updateWikiPage(history.meta);
        this.updateSearch();
        this.func_73866_w_();
        currentPageScroll = history.scroll;
        this.updatePageScrolling();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146984_a(Slot slot, int x, int y, int mouse) {
        if (slot != null && slot.func_75216_d()) {
            this.setCurrentFile(slot.func_75211_c());
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        searchField.func_146192_a(x, y, button);
        if (searchField.func_146206_l() && button == 1) {
            searchField.func_146180_a("");
            currentPageLinkScroll = 0.0f;
            this.updateSearch();
        }
        List<IWikiTab> visibleTabs = this.getVisibleTabs();
        for (int i = 0; i < visibleTabs.size(); ++i) {
            if (x > 33 + this.field_147003_i || x < 1 + this.field_147003_i || y < 8 + this.field_147009_r + i * 35 || y > 43 + this.field_147009_r + i * 35) continue;
            currentTab = visibleTabs.get(i);
            currentPageLinkScroll = 0.0f;
            this.updateSearch();
            this.func_73866_w_();
            break;
        }
        for (IPageLink iPageLink : visibleWikiPages) {
            if (!iPageLink.onMouseClick(this, -this.field_147003_i + x, -this.field_147009_r + y)) continue;
            return;
        }
        for (LocatedString locatedString : locatedStrings) {
            if (!locatedString.onMouseClick(this, -this.field_147003_i + x, -this.field_147009_r + y)) continue;
            return;
        }
        if (this.hasMultipleTabPages() && x < 33 + this.field_147003_i && x >= 1 + this.field_147003_i && y >= 214 + this.field_147009_r && y <= 236 + this.field_147009_r) {
            if (button == 0) {
                if (++currentTabPage >= this.getTotalTabPages()) {
                    currentTabPage = 0;
                }
            } else if (button == 1 && --currentTabPage < 0) {
                currentTabPage = this.getTotalTabPages() - 1;
            }
        }
    }

    public void setCurrentFile(World world, int x, int y, int z) {
        BlockWikiEvent wikiEvent = new BlockWikiEvent(world, x, y, z);
        if (wikiEvent.drawnStack.func_77973_b() == null) {
            return;
        }
        wikiEvent.pageOpened = WikiRegistry.getPageForItemStack(wikiEvent.drawnStack);
        if (wikiEvent.pageOpened == null) {
            wikiEvent.pageOpened = wikiEvent.drawnStack.func_77977_a().replace("tile.", "block/").replace("item.", "item/");
        }
        MinecraftForge.EVENT_BUS.post((Event)wikiEvent);
        this.setCurrentFile(wikiEvent.pageOpened, wikiEvent.drawnStack);
    }

    public void setCurrentFile(Entity entity) {
        EntityWikiEvent wikiEvent = new EntityWikiEvent(entity);
        wikiEvent.pageOpened = "entity/" + EntityList.func_75621_b((Entity)entity);
        MinecraftForge.EVENT_BUS.post((Event)wikiEvent);
        this.setCurrentFile(wikiEvent.pageOpened, entity);
    }

    public void setCurrentFile(ItemStack stack) {
        String defaultName = WikiRegistry.getPageForItemStack(stack);
        if (defaultName == null) {
            defaultName = stack.func_77977_a().replace("tile.", "block/").replace("item.", "item/");
        }
        ItemWikiEvent wikiEvent = new ItemWikiEvent(stack, defaultName);
        MinecraftForge.EVENT_BUS.post((Event)wikiEvent);
        if (stack != null) {
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
        }
        this.setCurrentFile(wikiEvent.pageOpened, stack);
    }

    public void setCurrentFile(String file, Object ... metadata) {
        IWikiTab tab;
        ItemStack displayedStack;
        BrowseHistory.updateHistory(currentPageScroll);
        if (metadata.length == 0 && (displayedStack = WikiUtils.getStackFromName(file)) != null) {
            metadata = new Object[]{displayedStack};
        }
        if ((tab = this.getTabForPage(currentFile = file)) != null) {
            currentTab = tab;
        }
        currentTabPage = this.getPageNumberForTab(currentTab);
        currentTab.onPageChange(this, file, metadata);
        this.updateWikiPage(metadata);
        this.updateSearch();
        BrowseHistory.addHistory(file, currentTab, metadata);
        this.func_73866_w_();
    }

    protected void func_73869_a(char par1, int par2) {
        if (searchField.func_146201_a(par1, par2)) {
            currentPageLinkScroll = 0.0f;
            this.updateSearch();
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    private void updateSearch() {
        List<IPageLink> pages = currentTab.getPages(null);
        if (pages != null) {
            ArrayList<Integer> matchingIndexes = new ArrayList<Integer>();
            for (int i = 0; i < pages.size(); ++i) {
                if (!pages.get(i).getName().toLowerCase().contains(searchField.func_146179_b().toLowerCase())) continue;
                matchingIndexes.add(i);
            }
            matchingWikiPages = matchingIndexes.size();
            int firstListedPageIndex = (int)((float)this.getScrollStates() * currentPageLinkScroll + 0.5f) * currentTab.pagesPerScroll();
            int[] indexes = new int[Math.min(Math.min(matchingIndexes.size() - firstListedPageIndex, matchingIndexes.size()), currentTab.pagesPerTab())];
            for (int i = 0; i < indexes.length; ++i) {
                indexes[i] = (Integer)matchingIndexes.get(firstListedPageIndex + i);
            }
            visibleWikiPages = currentTab.getPages(indexes);
        } else {
            visibleWikiPages = new ArrayList<IPageLink>();
            matchingWikiPages = 0;
        }
        ((ContainerBlockWiki)this.field_147002_h).updateStacks(locatedStacks, visibleWikiPages);
    }

    private void updatePageScrolling() {
        int translation = -((int)(currentPageScroll * (float)this.getMaxPageTranslation() / 2.0f + 0.5f)) * 2 - currentPageTranslation;
        currentPageTranslation += translation;
        for (LocatedStack stack : locatedStacks) {
            stack.setY(stack.getY() + translation / 2);
        }
        for (LocatedString string : locatedStrings) {
            string.setY(string.getY() + translation);
        }
        for (IWidget image : locatedTextures) {
            image.setY(image.getY() + translation);
        }
        ((ContainerBlockWiki)this.field_147002_h).updateStacks(locatedStacks, visibleWikiPages);
    }

    private int getMaxPageTranslation() {
        int maxTranslation = -100000;
        for (IWidget texture : locatedTextures) {
            maxTranslation = Math.max(maxTranslation, texture.getY() + texture.getHeight());
        }
        for (LocatedString string : locatedStrings) {
            maxTranslation = Math.max(maxTranslation, string.getY() + this.field_146289_q.field_78288_b);
        }
        return Math.max(maxTranslation - currentPageTranslation - 453, 0);
    }

    private boolean needsPageLinkScrollBars() {
        return matchingWikiPages > currentTab.pagesPerTab();
    }

    private boolean needsPageScrollBars() {
        return this.getMaxPageTranslation() > 0;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            if (this.lastMouseX < 80 + this.field_147003_i + 14) {
                if (this.needsPageLinkScrollBars()) {
                    int j = this.getScrollStates();
                    if ((currentPageLinkScroll = (float)((double)currentPageLinkScroll - (double)i / (double)j)) < 0.0f) {
                        currentPageLinkScroll = 0.0f;
                    }
                    if (currentPageLinkScroll > 1.0f) {
                        currentPageLinkScroll = 1.0f;
                    }
                    this.updateSearch();
                }
            } else if (this.needsPageScrollBars()) {
                int maxTranslation = this.getMaxPageTranslation();
                if ((currentPageScroll -= (float)i / (float)maxTranslation * 40.0f) > 1.0f) {
                    currentPageScroll = 1.0f;
                } else if (currentPageScroll < 0.0f) {
                    currentPageScroll = 0.0f;
                }
                this.updatePageScrolling();
            }
        }
    }

    private int getScrollStates() {
        return (1 + matchingWikiPages - currentTab.pagesPerTab()) / currentTab.pagesPerScroll();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.lastMouseX = mouseX;
        boolean leftClicking = Mouse.isButtonDown((int)0);
        int pageLinkScrollX1 = this.field_147003_i + 80;
        int pageLinkScrollY1 = this.field_147009_r + 14 + currentTab.getSearchBarAndScrollStartY();
        int pageLinkScrollX2 = pageLinkScrollX1 + 14;
        int pageLinkScrollY2 = pageLinkScrollY1 + 214 - currentTab.getSearchBarAndScrollStartY();
        int pageScrollX1 = this.field_147003_i + 240;
        int pageScrollY1 = this.field_147009_r + 4;
        int pageScrollX2 = pageScrollX1 + 14;
        int pageScrollY2 = pageScrollY1 + 230;
        if (!this.wasClicking && leftClicking) {
            if (mouseX >= pageLinkScrollX1 && mouseY >= pageLinkScrollY1 && mouseX < pageLinkScrollX2 && mouseY < pageLinkScrollY2) {
                this.isScrollingPageLink = this.needsPageLinkScrollBars();
            } else if (mouseX >= pageScrollX1 && mouseY >= pageScrollY1 && mouseX < pageScrollX2 && mouseY < pageScrollY2) {
                this.isScrollingPage = this.needsPageScrollBars();
            }
        }
        if (!leftClicking) {
            this.isScrollingPageLink = false;
            this.isScrollingPage = false;
        }
        this.wasClicking = leftClicking;
        if (this.isScrollingPageLink) {
            currentPageLinkScroll = ((float)(mouseY - pageLinkScrollY1) - 7.5f) / ((float)(pageLinkScrollY2 - pageLinkScrollY1) - 15.0f);
            if (currentPageLinkScroll < 0.0f) {
                currentPageLinkScroll = 0.0f;
            }
            if (currentPageLinkScroll > 1.0f) {
                currentPageLinkScroll = 1.0f;
            }
            this.updateSearch();
        } else if (this.isScrollingPage) {
            currentPageScroll = ((float)(mouseY - pageScrollY1) - 7.5f) / ((float)(pageScrollY2 - pageScrollY1) - 15.0f);
            if (currentPageScroll < 0.0f) {
                currentPageScroll = 0.0f;
            }
            if (currentPageScroll > 1.0f) {
                currentPageScroll = 1.0f;
            }
            this.updatePageScrolling();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float par1, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(Textures.GUI_WIKI);
        this.func_73729_b(this.field_147003_i + 33, this.field_147009_r, 33, 0, this.field_146999_f - 33, this.field_147000_g);
        List<IWikiTab> visibleTabs = this.getVisibleTabs();
        for (int i = 0; i < visibleTabs.size(); ++i) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 4 + i * 35, 0, currentTab == visibleTabs.get(i) ? 0 : 35, 33, 35);
        }
        if (this.hasMultipleTabPages()) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r + 214, 0, 70, 33, 22);
        }
        if (this.needsPageLinkScrollBars()) {
            this.func_73729_b(this.field_147003_i + 80 - 1, this.field_147009_r + 14 + currentTab.getSearchBarAndScrollStartY() - 1, 239, 3, 14, 214 - currentTab.getSearchBarAndScrollStartY() - 1);
            this.func_73729_b(this.field_147003_i + 80 - 1, this.field_147009_r + 14 + 214 - 2, 239, 232, 14, 1);
        } else {
            this.func_73728_b(this.field_147003_i + 80 + 13, this.field_147009_r + 14 + currentTab.getSearchBarAndScrollStartY(), 234, -7829368);
        }
        searchField.func_146194_f();
        this.drawWikiPage(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        this.field_146297_k.func_110434_K().func_110577_a(scrollbarTexture);
        if (this.needsPageLinkScrollBars()) {
            this.func_73729_b(80, 14 + currentTab.getSearchBarAndScrollStartY() + (int)((float)(214 - currentTab.getSearchBarAndScrollStartY() - 17) * currentPageLinkScroll), 232 + (this.needsPageLinkScrollBars() ? 0 : 12), 0, 12, 15);
        }
        this.func_73729_b(240, 4 + (int)(213.0f * currentPageScroll), 232 + (this.needsPageScrollBars() ? 0 : 12), 0, 12, 15);
        GL11.glEnable((int)2896);
        if (this.hasMultipleTabPages()) {
            this.field_146289_q.func_78276_b(currentTabPage + 1 + "/" + this.getTotalTabPages(), 10, 221, -16777216);
        }
        for (LocatedStack locatedStack : locatedStacks) {
            locatedStack.renderBackground(this, mouseX, mouseY);
        }
        currentTab.renderForeground(this, mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        for (LocatedString locatedString : locatedStrings) {
            if (locatedString.getY() <= 10 || locatedString.getReservedSpace().height + locatedString.getY() > 453) continue;
            locatedString.renderForeground(this, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
        for (IWidget texture : locatedTextures) {
            texture.renderForeground(this, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        List<IReservedSpace> reservedSpaces = currentTab.getReservedSpaces();
        if (reservedSpaces != null) {
            for (IReservedSpace space : reservedSpaces) {
                if (!(space instanceof LocatedTexture)) continue;
                ((LocatedTexture)space).renderForeground(this, mouseX, mouseY);
            }
        }
        for (IPageLink link : visibleWikiPages) {
            link.renderForeground(this, mouseX, mouseY);
        }
        this.drawTooltips(mouseX, mouseY);
    }

    private void drawTooltips(int x, int y) {
        List<IWikiTab> visibleTabs = this.getVisibleTabs();
        for (int i = 0; i < visibleTabs.size(); ++i) {
            if (x > 33 + this.field_147003_i || x < 1 + this.field_147003_i || y < 4 + this.field_147009_r + i * 35 || y > 39 + this.field_147009_r + i * 35) continue;
            this.func_146279_a(I18n.func_135052_a((String)visibleTabs.get(i).getName(), (Object[])new Object[0]), x - this.field_147003_i, y - this.field_147009_r);
        }
        if (this.hasMultipleTabPages() && x < 33 + this.field_147003_i && x >= 1 + this.field_147003_i && y >= 214 + this.field_147009_r && y <= 236 + this.field_147009_r) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"igwmod.tooltip.tabPageBrowse.next", (Object[])new Object[0]), I18n.func_135052_a((String)"igwmod.tooltip.tabPageBrowse.previous", (Object[])new Object[0])), x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    private void updateWikiPage(Object ... metadata) {
        List<IReservedSpace> reservedSpaces;
        Object o = metadata.length > 0 ? metadata[0] : null;
        ItemStack pageStack = o instanceof ItemStack ? (ItemStack)o : null;
        Entity pageEntity = o instanceof Entity ? (Entity)o : null;
        PageChangeEvent pageChangeEvent = new PageChangeEvent(currentFile, pageStack, pageEntity);
        MinecraftForge.EVENT_BUS.post((Event)pageChangeEvent);
        currentFile = pageChangeEvent.currentFile;
        fileInfo = pageChangeEvent.pageText;
        if (fileInfo == null) {
            String modid = currentModIdPage;
            if (!currentFile.startsWith("block/") && !currentFile.startsWith("item/") && currentFile.contains(":")) {
                String[] splitted = currentFile.split(":");
                modid = splitted[0];
                currentFile = splitted[1];
            }
            if (pageStack != null) {
                modid = WikiUtils.getOwningModId(pageStack);
            }
            if (pageEntity != null) {
                modid = Util.getModIdForEntity(pageEntity.getClass());
            }
            if (o instanceof String) {
                modid = (String)o;
            }
            currentModIdPage = modid;
            fileInfo = InfoSupplier.getInfo(modid, currentFile, false);
        }
        if ((reservedSpaces = currentTab.getReservedSpaces()) == null) {
            reservedSpaces = new ArrayList<IReservedSpace>();
        }
        reservedSpaces.add(new ReservedSpace(new Rectangle(0, 0, 200, Integer.MAX_VALUE)));
        InfoSupplier.analyseInfo(this.field_146289_q, fileInfo, reservedSpaces, locatedStrings, locatedStacks, locatedTextures);
        ((ContainerBlockWiki)this.field_147002_h).updateStacks(locatedStacks, visibleWikiPages);
        currentPageTranslation = 0;
        currentPageScroll = 0.0f;
    }

    private void drawWikiPage(int mouseX, int mouseY) {
        currentTab.renderBackground(this, mouseX, mouseY);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_147003_i, (double)this.field_147009_r, (double)0.0);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)1.0);
        for (IWidget texture : locatedTextures) {
            texture.renderBackground(this, mouseX, mouseY);
        }
        GL11.glPopMatrix();
        for (LocatedString locatedString : locatedStrings) {
            if (locatedString.getY() <= 10 || locatedString.getReservedSpace().height + locatedString.getY() > 453) continue;
            locatedString.renderBackground(this, mouseX, mouseY);
        }
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        List<IReservedSpace> reservedSpaces = currentTab.getReservedSpaces();
        if (reservedSpaces != null) {
            for (IReservedSpace space : reservedSpaces) {
                if (!(space instanceof LocatedTexture)) continue;
                ((LocatedTexture)space).renderBackground(this, mouseX, mouseY);
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)4.0, (double)0.0);
        List<IWikiTab> visibleTabs = this.getVisibleTabs();
        for (IWikiTab tab : visibleTabs) {
            ItemStack drawingStack = tab.renderTabIcon(this);
            if (drawingStack != null) {
                this.renderRotatingBlockIntoGUI(this, drawingStack, 11, 10, 1.5f);
            }
            GL11.glTranslated((double)0.0, (double)35.0, (double)0.0);
        }
        GL11.glPopMatrix();
        for (IPageLink link : visibleWikiPages) {
            link.renderBackground(this, mouseX, mouseY);
        }
        GL11.glPopMatrix();
    }

    private List<IWikiTab> getVisibleTabs() {
        ArrayList<IWikiTab> tabs = new ArrayList<IWikiTab>();
        for (int i = currentTabPage * 6; i < currentTabPage * 6 + 6 && i < wikiTabs.size(); ++i) {
            tabs.add(wikiTabs.get(i));
        }
        return tabs;
    }

    private IWikiTab getTabForPage(String page) {
        List<IPageLink> links;
        if (currentTab != null && (links = currentTab.getPages(null)) != null) {
            for (IPageLink link : links) {
                if (!page.equals(link.getLinkAddress())) continue;
                return currentTab;
            }
        }
        for (IWikiTab tab : wikiTabs) {
            List<IPageLink> links2 = tab.getPages(null);
            if (links2 == null) continue;
            for (IPageLink link : links2) {
                if (!page.equals(link.getLinkAddress())) continue;
                return tab;
            }
        }
        return null;
    }

    private int getPageNumberForTab(IWikiTab tab) {
        int index = wikiTabs.indexOf(tab);
        if (index == -1) {
            return 0;
        }
        return index / 6;
    }

    private boolean hasMultipleTabPages() {
        return wikiTabs.size() > 6;
    }

    private int getTotalTabPages() {
        return wikiTabs.size() / 6 + 1;
    }

    public void renderRotatingBlockIntoGUI(GuiWiki gui, ItemStack stack, int x, int y, float scale) {
        if (entityItem == null) {
            entityItem = new EntityItem((World)gui.field_146297_k.field_71441_e);
            renderItem.func_76976_a(RenderManager.field_78727_a);
        }
        entityItem.func_92058_a(stack);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 1), (double)(y + 13), (double)20.0);
        GL11.glScaled((double)(40.0f * scale), (double)(40.0f * scale), (double)(-40.0f * scale));
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)30.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.1, (double)0.1, (double)gui.field_73735_i);
        GL11.glRotated((double)(-TickHandler.ticksExisted), (double)0.0, (double)1.0, (double)0.0);
        renderItem.func_76986_a(entityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    static {
        currentTabPage = 0;
        currentModIdPage = "igwmod";
        visibleWikiPages = new ArrayList<IPageLink>();
        locatedStacks = new ArrayList<LocatedStack>();
        locatedStrings = new ArrayList<LocatedString>();
        locatedTextures = new ArrayList<IWidget>();
        scrollbarTexture = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
        renderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }
        };
    }
}

