/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.TileMachineBase;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRegulator
extends TileMachineBase
implements ISidedInventory,
IGuiButtonSensitive {
    private ItemStack[] inventory = new ItemStack[27];
    public IPneumaticTube.TubeColor color = IPneumaticTube.TubeColor.NONE;
    public int mode;
    public int fuzzySetting;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.isBufferEmpty()) {
            boolean shouldEmitRedstone;
            IInventory inv;
            boolean ratiosMatch = true;
            for (int i = 0; i < 9; ++i) {
                if (this.inventory[i] == null) continue;
                int inputFilterItems = this.getItemsInSection(this.inventory[i], EnumSection.INPUT_FILTER);
                int bufferItems = this.getItemsInSection(this.inventory[i], EnumSection.BUFFER);
                if (bufferItems >= inputFilterItems) continue;
                ratiosMatch = false;
                break;
            }
            if (ratiosMatch && !this.isEjecting()) {
                this.checkIndividualOutputFilterAndEject();
            }
            if (this.mode == 1 && !this.isEjecting() && (inv = IOHelper.getInventoryForTE(this.getTileCache(this.getOutputDirection()))) != null) {
                int i;
                int[] accessibleSlots;
                if (inv instanceof ISidedInventory) {
                    accessibleSlots = ((ISidedInventory)inv).func_94128_d(this.getFacingDirection().ordinal());
                } else {
                    accessibleSlots = new int[inv.func_70302_i_()];
                    for (i = 0; i < accessibleSlots.length; ++i) {
                        accessibleSlots[i] = i;
                    }
                }
                for (i = 18; i < 27; ++i) {
                    ItemStack remainder;
                    if (this.inventory[i] == null) continue;
                    int outputFilterItems = this.getItemsInSection(this.inventory[i], EnumSection.OUTPUT_FILTER);
                    int supplyingInvCount = 0;
                    for (int slot : accessibleSlots) {
                        ItemStack stackInSlot = inv.func_70301_a(slot);
                        if (stackInSlot == null || !ItemStackHelper.areStacksEqual(stackInSlot, this.inventory[i], this.fuzzySetting) || !IOHelper.canInsertItemToInventory(inv, this.inventory[i], slot, this.getFacingDirection().ordinal())) continue;
                        supplyingInvCount += stackInSlot.field_77994_a;
                    }
                    if (supplyingInvCount >= outputFilterItems) continue;
                    ItemStack requestedStack = this.inventory[i].func_77946_l();
                    requestedStack.field_77994_a = outputFilterItems - supplyingInvCount;
                    ItemStack bufferItems = IOHelper.extract(this, ForgeDirection.UNKNOWN, requestedStack, true, false, this.fuzzySetting);
                    if (bufferItems == null || (remainder = IOHelper.insert(inv, bufferItems, this.getFacingDirection().ordinal(), false)) == null) continue;
                    IOHelper.insert(this, remainder, ForgeDirection.UNKNOWN, false);
                }
            }
            boolean bl = shouldEmitRedstone = this.isSatisfied() || this.animationTicker >= 0;
            if (this.isEjecting() != shouldEmitRedstone) {
                this.setOutputtingRedstone(shouldEmitRedstone);
                this.sendUpdatePacket();
            }
        }
    }

    @Override
    public boolean isEjecting() {
        return super.isEjecting() || this.getOutputtingRedstone() > 0;
    }

    private boolean isSatisfied() {
        IInventory inv = IOHelper.getInventoryForTE(this.getTileCache(this.getOutputDirection()));
        if (inv != null) {
            int[] accessibleSlots;
            if (inv instanceof ISidedInventory) {
                accessibleSlots = ((ISidedInventory)inv).func_94128_d(this.getFacingDirection().ordinal());
            } else {
                accessibleSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < accessibleSlots.length; ++i) {
                    accessibleSlots[i] = i;
                }
            }
            boolean everythingNull = true;
            for (int i = 18; i < 27; ++i) {
                if (this.inventory[i] == null) continue;
                everythingNull = false;
                int outputFilterItems = this.getItemsInSection(this.inventory[i], EnumSection.OUTPUT_FILTER);
                int supplyingInvCount = 0;
                for (int slot : accessibleSlots) {
                    ItemStack stackInSlot = inv.func_70301_a(slot);
                    if (stackInSlot == null || !ItemStackHelper.areStacksEqual(stackInSlot, this.inventory[i], this.fuzzySetting) || !IOHelper.canInsertItemToInventory(inv, this.inventory[i], slot, this.getFacingDirection().ordinal())) continue;
                    supplyingInvCount += stackInSlot.field_77994_a;
                }
                if (supplyingInvCount >= outputFilterItems) continue;
                return false;
            }
            return !everythingNull;
        }
        return false;
    }

    private void checkIndividualOutputFilterAndEject() {
        for (int i = 0; i < 9; ++i) {
            if (this.inventory[i] == null) continue;
            int inputFilterItems = this.getItemsInSection(this.inventory[i], EnumSection.INPUT_FILTER);
            int bufferItems = this.getItemsInSection(this.inventory[i], EnumSection.BUFFER);
            if (bufferItems < inputFilterItems) continue;
            ItemStack stackFromBuffer = IOHelper.extract(this, ForgeDirection.UNKNOWN, this.inventory[i], true, false, this.fuzzySetting);
            this.addItemToOutputBuffer(stackFromBuffer, this.color);
        }
    }

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        if (from == this.getFacingDirection() && this.isBufferEmpty()) {
            stack = stack.copy();
            int bufferItems = this.getItemsInSection(stack.stack, EnumSection.BUFFER);
            int inputFilterItems = this.getItemsInSection(stack.stack, EnumSection.INPUT_FILTER);
            int allowedItems = inputFilterItems - bufferItems;
            if (allowedItems <= 0) {
                return stack;
            }
            ItemStack acceptedStack = stack.stack.func_77979_a(Math.min(allowedItems, stack.stack.field_77994_a));
            if (acceptedStack != null && acceptedStack.field_77994_a > 0) {
                ItemStack remainder;
                for (int i = EnumSection.INPUT_FILTER.ordinal() * 9; !(i >= EnumSection.INPUT_FILTER.ordinal() * 9 + 9 || this.inventory[i] != null && ItemStackHelper.areStacksEqual(acceptedStack, this.inventory[i], this.fuzzySetting) && (acceptedStack = IOHelper.insert((IInventory)this, acceptedStack, EnumSection.BUFFER.ordinal() * 9 + i, ForgeDirection.UNKNOWN.ordinal(), simulate)) == null); ++i) {
                }
                if (acceptedStack != null && acceptedStack.field_77994_a != 0 && (remainder = IOHelper.insert((IInventory)this, acceptedStack, ForgeDirection.UNKNOWN.ordinal(), simulate)) != null) {
                    stack.stack.field_77994_a += remainder.field_77994_a;
                }
                if (stack.stack.field_77994_a > 0) {
                    return stack;
                }
                return null;
            }
            return stack;
        }
        return super.acceptItemFromTube(stack, from, simulate);
    }

    private int getItemsInSection(ItemStack type, EnumSection section) {
        int count = 0;
        for (int i = section.ordinal() * 9; i < section.ordinal() * 9 + 9; ++i) {
            if (this.inventory[i] == null || !ItemStackHelper.areStacksEqual(type, this.inventory[i], this.fuzzySetting)) continue;
            count += this.inventory[i].field_77994_a;
        }
        return count;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 1) {
            this.mode = value;
        } else if (messageId == 0) {
            this.color = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 2) {
            this.fuzzySetting = value;
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (int i = 9; i < 18; ++i) {
            if (this.inventory[i] == null) continue;
            drops.add(this.inventory[i]);
        }
        return drops;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74774_a("filterColor", (byte)this.color.ordinal());
        tag.func_74774_a("mode", (byte)this.mode);
        tag.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("Items", (NBTBase)tagList);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.color = IPneumaticTube.TubeColor.values()[tag.func_74771_c("filterColor")];
        this.mode = tag.func_74771_c("mode");
        this.fuzzySetting = tag.func_74771_c("fuzzySetting");
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.inventory = new ItemStack[27];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return BPBlocks.regulator.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        if (side == this.getFacingDirection().ordinal() || side == this.getOutputDirection().ordinal()) {
            return new int[0];
        }
        int[] slots = new int[9];
        for (int i = 9; i < 18; ++i) {
            slots[i - 9] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return true;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    private static enum EnumSection {
        INPUT_FILTER,
        BUFFER,
        OUTPUT_FILTER;

    }
}

