/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IInsulatedRedstoneDevice;
import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.block.machine.BlockLampRGB;
import com.bluepowermod.client.render.RenderLamp;
import com.bluepowermod.redstone.BundledConnectionCache;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.tile.TileBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;

public class TileLamp
extends TileBase
implements IBundledDevice {
    private int power;
    private byte[] bundledPower = new byte[16];
    private BundledConnectionCache connections = RedstoneApi.getInstance().createBundledConnectionCache(this);

    public int getPower() {
        return this.power;
    }

    public void onUpdate() {
        if (this.field_145854_h instanceof BlockLampRGB) {
            this.connections.recalculateConnections();
            int connected = 0;
            for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
                connected += this.connections.getConnectionOnSide(s) != null ? 1 : 0;
            }
            if (connected == 0) {
                this.bundledPower = new byte[16];
            }
            int pow = 0;
            pow = ((BlockLamp)this.field_145854_h).isInverted() ? 255 - Math.min(Math.min(this.bundledPower[MinecraftColor.RED.ordinal()] & 0xFF, this.bundledPower[MinecraftColor.GREEN.ordinal()] & 0xFF), this.bundledPower[MinecraftColor.BLUE.ordinal()] & 0xFF) : Math.max(Math.max(this.bundledPower[MinecraftColor.RED.ordinal()] & 0xFF, this.bundledPower[MinecraftColor.GREEN.ordinal()] & 0xFF), this.bundledPower[MinecraftColor.BLUE.ordinal()] & 0xFF);
            this.power = (int)((double)pow / 256.0 * 15.0);
            this.sendUpdatePacket();
        } else {
            int pow = RedstoneHelper.getInput((World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            if (pow != this.power) {
                this.power = pow;
                this.sendUpdatePacket();
                this.func_145831_w().func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                try {
                    this.func_145831_w().func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.func_145831_w().func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
        }
    }

    @Override
    protected void writeToPacketNBT(NBTTagCompound tCompound) {
        tCompound.func_74768_a("power", this.power);
        if (this.field_145854_h instanceof BlockLampRGB) {
            tCompound.func_74774_a("red", this.bundledPower[MinecraftColor.RED.ordinal()]);
            tCompound.func_74774_a("green", this.bundledPower[MinecraftColor.GREEN.ordinal()]);
            tCompound.func_74774_a("blue", this.bundledPower[MinecraftColor.BLUE.ordinal()]);
        }
    }

    @Override
    protected void readFromPacketNBT(NBTTagCompound tCompound) {
        this.power = tCompound.func_74762_e("power");
        if (tCompound.func_74764_b("red")) {
            byte[] pow = this.bundledPower;
            pow[MinecraftColor.RED.ordinal()] = tCompound.func_74771_c("red");
            pow[MinecraftColor.GREEN.ordinal()] = tCompound.func_74771_c("green");
            pow[MinecraftColor.BLUE.ordinal()] = tCompound.func_74771_c("blue");
            this.bundledPower = pow;
        }
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145831_w().func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        RenderLamp.pass = pass;
        return true;
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public boolean canConnect(ForgeDirection side, IBundledDevice dev, ConnectionType type) {
        if (!(this.getWorld().func_147439_a(this.getX(), this.getY(), this.getZ()) instanceof BlockLampRGB)) {
            return false;
        }
        if (dev instanceof IInsulatedRedstoneDevice) {
            return false;
        }
        if (dev instanceof TileLamp) {
            return false;
        }
        return type == ConnectionType.STRAIGHT && side != ForgeDirection.UNKNOWN;
    }

    public BundledConnectionCache getBundledConnectionCache() {
        return this.connections;
    }

    @Override
    public byte[] getBundledOutput(ForgeDirection side) {
        return new byte[16];
    }

    @Override
    public void setBundledPower(ForgeDirection side, byte[] power) {
        this.bundledPower = power;
    }

    @Override
    public byte[] getBundledPower(ForgeDirection side) {
        return this.bundledPower;
    }

    @Override
    public void onBundledUpdate() {
        this.onUpdate();
    }

    @Override
    public MinecraftColor getBundledColor(ForgeDirection side) {
        return MinecraftColor.NONE;
    }

    public int getColor() {
        int r = MathHelper.map((int)(this.bundledPower[MinecraftColor.RED.ordinal()] & 0xFF), (int)0, (int)255, (int)20, (int)235);
        int g = MathHelper.map((int)(this.bundledPower[MinecraftColor.GREEN.ordinal()] & 0xFF), (int)0, (int)255, (int)20, (int)235);
        int b = MathHelper.map((int)(this.bundledPower[MinecraftColor.BLUE.ordinal()] & 0xFF), (int)0, (int)255, (int)20, (int)235);
        return (r << 16) + (g << 8) + b;
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return true;
    }
}

