/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.api.tube.IWeightedTubeInventory;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.TileEntityCache;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMachineBase
extends TileBase
implements ITubeConnection,
IWeightedTubeInventory,
IEjectAnimator {
    protected boolean spawnItemsInWorld = true;
    protected boolean acceptsTubeItems = true;
    private final List<TubeStack> internalItemStackBuffer = new ArrayList<TubeStack>();
    private TileEntityCache tileCache;
    public static final int BUFFER_EMPTY_INTERVAL = 10;
    protected byte animationTicker = (byte)-1;
    protected static final int ANIMATION_TIME = 7;
    private boolean isAnimating;
    protected boolean ejectionScheduled;
    private static final int WARNING_INTERVAL = 600;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ejectionScheduled || this.getTicker() % 10 == 0) {
                this.ejectItems();
                this.ejectionScheduled = false;
            }
            if (this.animationTicker >= 0 && this.isBufferEmpty() && (this.animationTicker = (byte)(this.animationTicker + 1)) > 7) {
                this.animationTicker = (byte)-1;
                this.sendUpdatePacket();
            }
            if (this.getBacklog().size() > 50 && this.getTicker() % 600 == 0) {
                BluePower.log.warn("Large backlog (" + this.getBacklog().size() + " stacks) detected in " + this.func_145838_q().func_149732_F() + " at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
            }
        }
    }

    private void ejectItems() {
        Iterator<TubeStack> iterator = this.internalItemStackBuffer.iterator();
        while (iterator.hasNext()) {
            TubeStack tubeStack = iterator.next();
            if (IOHelper.canInterfaceWith(this.getTileCache(this.getOutputDirection()), this.getFacingDirection())) {
                ItemStack returnedStack = IOHelper.insert(this.getTileCache(this.getOutputDirection()), tubeStack.stack, this.getFacingDirection(), tubeStack.color, false);
                if (returnedStack == null) {
                    iterator.remove();
                    this.func_70296_d();
                    if (this.ejectionScheduled) continue;
                    break;
                }
                if (returnedStack.field_77994_a == tubeStack.stack.field_77994_a) break;
                this.func_70296_d();
                if (this.ejectionScheduled) continue;
                break;
            }
            if (!this.spawnItemsInWorld) continue;
            ForgeDirection direction = this.getFacingDirection().getOpposite();
            if (!this.field_145850_b.func_147439_a(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ).func_149655_b((IBlockAccess)this.field_145850_b, this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) break;
            this.ejectItemInWorld(tubeStack.stack, direction);
            iterator.remove();
            this.func_70296_d();
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.tileCache = null;
    }

    @Override
    public void onBlockNeighbourChanged() {
        super.onBlockNeighbourChanged();
        this.tileCache = null;
    }

    protected void addItemToOutputBuffer(ItemStack stack, IPneumaticTube.TubeColor color) {
        if (!this.field_145850_b.field_72995_K) {
            this.internalItemStackBuffer.add(new TubeStack(stack, this.getOutputDirection().getOpposite(), color));
            if (this.internalItemStackBuffer.size() == 1) {
                this.ejectionScheduled = true;
            }
            this.animationTicker = 0;
            this.sendUpdatePacket();
        }
    }

    public List<TubeStack> getBacklog() {
        return this.internalItemStackBuffer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBacklog(List<TubeStack> backlog) {
        this.internalItemStackBuffer.clear();
        this.internalItemStackBuffer.addAll(backlog);
    }

    protected void addItemToOutputBuffer(ItemStack stack) {
        this.addItemToOutputBuffer(stack, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks) {
        this.addItemsToOutputBuffer(stacks, IPneumaticTube.TubeColor.NONE);
    }

    protected void addItemsToOutputBuffer(Iterable<ItemStack> stacks, IPneumaticTube.TubeColor color) {
        for (ItemStack stack : stacks) {
            this.addItemToOutputBuffer(stack, color);
        }
    }

    protected boolean isBufferEmpty() {
        return this.internalItemStackBuffer.isEmpty();
    }

    public TileEntity getTileCache(ForgeDirection d) {
        if (this.tileCache == null) {
            this.tileCache = new TileEntityCache(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return (TileEntity)this.tileCache.getValue(d);
    }

    public ForgeDirection getOutputDirection() {
        return this.getFacingDirection().getOpposite();
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("ItemBuffer", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.internalItemStackBuffer.add(TubeStack.loadFromNBT(nbttagcompound1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (TubeStack tubeStack : this.internalItemStackBuffer) {
            if (tubeStack == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            tubeStack.writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("ItemBuffer", (NBTBase)nbttaglist);
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound compound) {
        super.writeToPacketNBT(compound);
        compound.func_74757_a("animating", this.animationTicker >= 0);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound compound) {
        super.readFromPacketNBT(compound);
        boolean wasAnimating = this.isEjecting();
        this.isAnimating = compound.func_74767_n("animating");
        if (this.isAnimating) {
            this.animationTicker = 0;
        }
        if (this.field_145850_b != null && wasAnimating != this.isEjecting()) {
            this.markForRenderUpdate();
        }
    }

    public void ejectItemInWorld(ItemStack stack, ForgeDirection oppDirection) {
        float spawnX = (float)this.field_145851_c + 0.5f + (float)oppDirection.offsetX * 0.8f;
        float spawnY = (float)this.field_145848_d + 0.5f + (float)oppDirection.offsetY * 0.8f;
        float spawnZ = (float)this.field_145849_e + 0.5f + (float)oppDirection.offsetZ * 0.8f;
        EntityItem droppedItem = new EntityItem(this.field_145850_b, (double)spawnX, (double)spawnY, (double)spawnZ, stack);
        droppedItem.field_70159_w = (float)oppDirection.offsetX * 0.2f;
        droppedItem.field_70181_x = (float)oppDirection.offsetY * 0.2f;
        droppedItem.field_70179_y = (float)oppDirection.offsetZ * 0.2f;
        this.field_145850_b.func_72838_d((Entity)droppedItem);
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (TubeStack stack : this.internalItemStackBuffer) {
            drops.add(stack.stack);
        }
        return drops;
    }

    @Override
    public boolean isConnectedTo(ForgeDirection from) {
        ForgeDirection dir = this.getOutputDirection();
        return from == dir.getOpposite() || this.acceptsTubeItems && from == dir;
    }

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        if (from == this.getFacingDirection() && !this.isBufferEmpty() && !this.ejectionScheduled) {
            return stack;
        }
        if (!simulate) {
            this.addItemToOutputBuffer(stack.stack, stack.color);
        }
        return null;
    }

    @Override
    public int getWeight(ForgeDirection from) {
        return from == this.getOutputDirection().getOpposite() ? 1000000 : 0;
    }

    @Override
    public boolean isEjecting() {
        return this.isAnimating;
    }

    @SideOnly(value=Side.CLIENT)
    public void addWailaInfo(List<String> info) {
        if (this.isEjecting()) {
            info.add(MinecraftColor.RED.getChatColor() + "[" + I18n.func_135052_a((String)"waila.machine.stuffed", (Object[])new Object[0]) + "]");
        }
    }
}

