/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.wire.redstone.IPropagator;
import com.bluepowermod.api.wire.redstone.IRedConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.redstone.RedstoneApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.misc.Pair;

public abstract class RedstonePropagator
implements IPropagator<IRedstoneDevice> {
    private List<RedstonePropagator> scheduledPropagations = new ArrayList<RedstonePropagator>();
    private IRedstoneDevice device;
    private ForgeDirection side;

    public RedstonePropagator(IRedstoneDevice device, ForgeDirection side) {
        this.device = device;
        this.side = side;
    }

    @Override
    public void propagate() {
        if (this.shouldPreventStackOverflows()) {
            return;
        }
        this.doPropagate();
        for (RedstonePropagator p : this.scheduledPropagations) {
            p.propagate();
        }
    }

    public IRedstoneDevice getDevice() {
        return this.device;
    }

    public ForgeDirection getSide() {
        return this.side;
    }

    protected void schedule(RedstonePropagator propagation) {
        this.scheduledPropagations.add(propagation);
    }

    protected List<RedstonePropagator> getScheduledPropagations() {
        return this.scheduledPropagations;
    }

    protected abstract void doPropagate();

    protected Collection<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> getPropagation(IRedstoneDevice dev, ForgeDirection fromSide) {
        if (dev instanceof IRedstoneConductor) {
            if (dev instanceof IRedstoneConductor.IAdvancedRedstoneConductor) {
                return ((IRedstoneConductor.IAdvancedRedstoneConductor)dev).propagate(fromSide);
            }
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IConnection<? extends IRedstoneDevice> c = dev.getRedstoneConnectionCache().getConnectionOnSide(d);
                if (c == null) continue;
                l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)false));
            }
            return l;
        }
        IConnection<? extends IRedstoneDevice> c = dev.getRedstoneConnectionCache().getConnectionOnSide(fromSide);
        if (c != null) {
            return Arrays.asList(new Pair(c, (Object)false));
        }
        return Arrays.asList(new Map.Entry[0]);
    }

    protected List<IConnection<IRedstoneDevice>> performPropagation() {
        ArrayList<IConnection<IRedstoneDevice>> connections = new ArrayList<IConnection<IRedstoneDevice>>();
        IConnection<? extends IRedstoneDevice> firstCon = this.getDevice().getRedstoneConnectionCache().getConnectionOnSide(this.getSide());
        if (firstCon != null) {
            connections.add(firstCon);
        }
        ArrayList<IConnection> current = new ArrayList<IConnection>();
        for (Map.Entry<IConnection<IRedstoneDevice>, Boolean> p : this.getPropagation(this.getDevice(), this.getSide())) {
            if (p.getValue().booleanValue()) {
                this.schedule(new RedPropagator(p.getKey().getB(), p.getKey().getSideB()));
                continue;
            }
            if (p.getKey().getB() instanceof IRedstoneConductor && ((IRedstoneConductor)p.getKey().getB()).hasLoss(p.getKey().getSideB()) != this instanceof LossyPropagator) {
                this.schedule(new RedPropagator(p.getKey().getB(), p.getKey().getSideB()));
                continue;
            }
            current.add(p.getKey());
        }
        if (current.size() == 0 && connections.size() == 0) {
            return connections;
        }
        ArrayList newDevices = new ArrayList();
        while (current.size() > 0) {
            ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> tmp = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
            for (IConnection c : current) {
                tmp.addAll(this.getPropagation((IRedstoneDevice)c.getB(), c.getSideB()));
                for (Map.Entry entry : tmp) {
                    if (((Boolean)entry.getValue()).booleanValue()) {
                        this.schedule(new RedPropagator((IRedstoneDevice)((IConnection)entry.getKey()).getB(), ((IConnection)entry.getKey()).getSideB()));
                        continue;
                    }
                    if (connections.contains(entry.getKey()) || newDevices.contains(entry.getKey())) continue;
                    newDevices.add(entry.getKey());
                }
                tmp.clear();
            }
            connections.addAll(current);
            current.clear();
            for (IConnection c : newDevices) {
                if (connections.contains(c)) continue;
                current.add(c);
            }
            newDevices.clear();
        }
        return connections;
    }

    protected List<Pair<IRedstoneDevice, ForgeDirection>> simplifyDeviceList(List<IConnection<IRedstoneDevice>> connections) {
        ArrayList<Pair<IRedstoneDevice, ForgeDirection>> l = new ArrayList<Pair<IRedstoneDevice, ForgeDirection>>();
        for (IConnection<IRedstoneDevice> c : connections) {
            Pair p2;
            Pair p1 = new Pair((Object)c.getA(), (Object)c.getSideA());
            if (!l.contains(p1) && l != null && p1.getKey() != null && p1.getValue() != null) {
                l.add((Pair<IRedstoneDevice, ForgeDirection>)p1);
            }
            if (l.contains(p2 = new Pair((Object)c.getB(), (Object)c.getSideB())) || l == null || p2.getKey() == null || p2.getValue() == null) continue;
            l.add((Pair<IRedstoneDevice, ForgeDirection>)p2);
        }
        return l;
    }

    protected boolean shouldPreventStackOverflows() {
        return false;
    }

    public static class RedPropagator
    extends RedstonePropagator {
        public RedPropagator(IRedstoneDevice device, ForgeDirection side) {
            super(device, side);
        }

        @Override
        protected void doPropagate() {
            if (this.getDevice().getWorld() == null || this.getDevice().getWorld().field_72995_K) {
                return;
            }
            if (this.getDevice() instanceof IRedConductor) {
                if (((IRedConductor)((Object)this.getDevice())).hasLoss(this.getSide())) {
                    try {
                        new LossyPropagator(this.getDevice(), this.getSide()).propagate();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        new LosslessPropagator(this.getDevice(), this.getSide()).propagate();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return;
            }
            if (this.getDevice() instanceof GateBase) {
                GateConnectionBase c = ((GateBase)this.getDevice()).getConnection(this.getSide());
                IConnection<? extends IRedstoneDevice> con = this.getDevice().getRedstoneConnectionCache().getConnectionOnSide(this.getSide());
                if (c != null) {
                    if (con != null && con.getB() instanceof IRedConductor && ((IRedConductor)((Object)con.getB())).hasLoss(con.getSideB())) {
                        try {
                            new LossyPropagator(this.getDevice(), this.getSide()).propagate();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    } else {
                        try {
                            new LosslessPropagator(this.getDevice(), this.getSide()).propagate();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    return;
                }
            }
            try {
                new LosslessPropagator(this.getDevice(), this.getSide()).propagate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class LossyPropagator
    extends RedstonePropagator {
        public LossyPropagator(IRedstoneDevice device, ForgeDirection side) {
            super(device, side);
        }

        @Override
        protected void doPropagate() {
            List<IConnection<IRedstoneDevice>> connections = this.performPropagation();
            if (connections.size() == 0) {
                this.getDevice().setRedstonePower(this.getSide(), (byte)0);
                boolean did = RedstoneApi.getInstance().shouldWiresHandleUpdates();
                RedstoneApi.getInstance().setWiresHandleUpdates(false);
                this.getDevice().onRedstoneUpdate();
                RedstoneApi.getInstance().setWiresHandleUpdates(did);
                RedstoneApi.getInstance().setWiresOutputPower(true, true);
                return;
            }
            List<Pair<IRedstoneDevice, ForgeDirection>> l = this.simplifyDeviceList(connections);
            ArrayList<Object> devs = new ArrayList<Object>();
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                if (devs.contains(pair.getKey())) continue;
                devs.add(pair.getKey());
            }
            for (IConnection iConnection : connections) {
                ((IRedstoneDevice)iConnection.getA()).setRedstonePower(iConnection.getSideA(), (byte)0);
            }
            RedstoneApi.getInstance().setWiresOutputPower(false, true);
            boolean did = RedstoneApi.getInstance().shouldWiresHandleUpdates();
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            for (IRedstoneDevice iRedstoneDevice : devs) {
                iRedstoneDevice.onRedstoneUpdate();
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(did);
            RedstoneApi.getInstance().setWiresOutputPower(true, true);
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                RedstoneApi.getInstance().setWiresOutputPower(false, true);
                byte power = ((IRedstoneDevice)pair.getKey()).getRedstonePower((ForgeDirection)pair.getValue());
                RedstoneApi.getInstance().setWiresOutputPower(true, true);
                if ((power & 0xFF) <= 0) continue;
                this.propagate((IRedstoneDevice)pair.getKey(), (ForgeDirection)pair.getValue(), power);
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            for (IRedstoneDevice iRedstoneDevice : devs) {
                iRedstoneDevice.onRedstoneUpdate();
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(did);
            ArrayList<RedstonePropagator> arrayList = new ArrayList<RedstonePropagator>();
            arrayList.addAll(this.getScheduledPropagations());
            this.getScheduledPropagations().clear();
            for (RedstonePropagator p : arrayList) {
                IConnection<? extends IRedstoneDevice> c = p.getDevice().getRedstoneConnectionCache().getConnectionOnSide(p.getSide());
                if (c.getB().getRedstonePower(c.getSideB()) == c.getA().getRedstonePower(c.getSideA())) continue;
                this.schedule(p);
            }
        }

        private void propagate(IRedstoneDevice dev, ForgeDirection side, byte power) {
            if (this.shouldPreventStackOverflows()) {
                return;
            }
            if ((power & 0xFF) <= 0) {
                return;
            }
            if ((dev.getRedstonePower(side) & 0xFF) > (power & 0xFF)) {
                return;
            }
            for (Map.Entry<IConnection<IRedstoneDevice>, Boolean> e : this.getPropagation(dev, side)) {
                e.getKey().getA().setRedstonePower(e.getKey().getSideA(), power);
                boolean found = false;
                for (RedstonePropagator p : this.getScheduledPropagations()) {
                    if (p.getDevice() != e.getKey().getB() || p.getSide() != e.getKey().getSideB()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.propagate(e.getKey().getB(), e.getKey().getSideB(), (byte)((power & 0xFF) - (dev instanceof IRedstoneConductor ? 1 : 0)));
            }
        }
    }

    public static class LosslessPropagator
    extends RedstonePropagator {
        public LosslessPropagator(IRedstoneDevice device, ForgeDirection side) {
            super(device, side);
        }

        @Override
        protected void doPropagate() {
            List<IConnection<IRedstoneDevice>> connections = this.performPropagation();
            if (connections.size() == 0) {
                RedstoneApi.getInstance().setWiresOutputPower(false, false);
                this.getDevice().setRedstonePower(this.getSide(), (byte)0);
                boolean did = RedstoneApi.getInstance().shouldWiresHandleUpdates();
                RedstoneApi.getInstance().setWiresHandleUpdates(false);
                this.getDevice().onRedstoneUpdate();
                RedstoneApi.getInstance().setWiresHandleUpdates(did);
                RedstoneApi.getInstance().setWiresOutputPower(true, false);
                return;
            }
            List<Pair<IRedstoneDevice, ForgeDirection>> l = this.simplifyDeviceList(connections);
            boolean did = RedstoneApi.getInstance().shouldWiresHandleUpdates();
            RedstoneApi.getInstance().setWiresOutputPower(false, false);
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                ((IRedstoneDevice)pair.getKey()).setRedstonePower((ForgeDirection)pair.getValue(), (byte)0);
            }
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                ((IRedstoneDevice)pair.getKey()).onRedstoneUpdate();
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(did);
            RedstoneApi.getInstance().setWiresOutputPower(true, false);
            int pow = 0;
            RedstoneApi.getInstance().setWiresOutputPower(false, false);
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                pow = Math.max(pow, ((IRedstoneDevice)pair.getKey()).getRedstonePower((ForgeDirection)pair.getValue()) & 0xFF);
            }
            RedstoneApi.getInstance().setWiresOutputPower(true, false);
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                ((IRedstoneDevice)pair.getKey()).setRedstonePower((ForgeDirection)pair.getValue(), (byte)pow);
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(false);
            for (Pair<IRedstoneDevice, ForgeDirection> pair : l) {
                ((IRedstoneDevice)pair.getKey()).onRedstoneUpdate();
            }
            RedstoneApi.getInstance().setWiresHandleUpdates(did);
            l.clear();
            connections.clear();
            ArrayList<RedstonePropagator> arrayList = new ArrayList<RedstonePropagator>();
            arrayList.addAll(this.getScheduledPropagations());
            this.getScheduledPropagations().clear();
            for (RedstonePropagator p : arrayList) {
                IConnection<? extends IRedstoneDevice> c = p.getDevice().getRedstoneConnectionCache().getConnectionOnSide(p.getSide());
                if (c.getB().getRedstonePower(c.getSideB()) == c.getA().getRedstonePower(c.getSideA())) continue;
                this.schedule(p);
            }
        }
    }
}

