/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.tube;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.api.misc.IScrewdriver;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.api.tube.ITubeConnection;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.client.render.IconSupplier;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.PartCache;
import com.bluepowermod.helper.TileEntityCache;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.init.Config;
import com.bluepowermod.item.ItemDamageableColorableOverlay;
import com.bluepowermod.item.ItemPart;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.PartManager;
import com.bluepowermod.part.tube.Accelerator;
import com.bluepowermod.part.tube.MagTube;
import com.bluepowermod.part.tube.PneumaticTubeOpaque;
import com.bluepowermod.part.tube.RestrictionTube;
import com.bluepowermod.part.tube.TubeLogic;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.part.wire.PartWireFreestanding;
import com.bluepowermod.part.wire.redstone.PartRedwireFace;
import com.bluepowermod.part.wire.redstone.WireHelper;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import com.bluepowermod.util.Color;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.IPartThruHole;
import uk.co.qmunity.lib.part.IPartTicking;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class PneumaticTube
extends PartWireFreestanding
implements IPartTicking,
IPartThruHole,
IPartRedstone,
IRedstoneConductor,
IConnectionListener,
IRedwire {
    public final boolean[] connections = new boolean[6];
    public final boolean[] redstoneConnections = new boolean[6];
    public boolean isCrossOver;
    protected final Vec3dCube sideBB = new Vec3dCube(AxisAlignedBB.func_72330_a((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75));
    private TileEntityCache tileCache;
    private PartCache<PneumaticTube> partCache;
    protected final IPneumaticTube.TubeColor[] color = new IPneumaticTube.TubeColor[]{IPneumaticTube.TubeColor.NONE, IPneumaticTube.TubeColor.NONE, IPneumaticTube.TubeColor.NONE, IPneumaticTube.TubeColor.NONE, IPneumaticTube.TubeColor.NONE, IPneumaticTube.TubeColor.NONE};
    private final TubeLogic logic = new TubeLogic(this);
    public boolean initialized;
    private int tick;
    private RedwireType redwireType = null;
    private RedstoneConnectionCache redConnections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
    private byte power = 0;

    public String getType() {
        return "pneumaticTube";
    }

    @Override
    public String getUnlocalizedName() {
        return "pneumaticTube";
    }

    @Override
    public void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
        boxes.addAll(this.getSelectionBoxes());
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        return this.getTubeBoxes();
    }

    protected List<Vec3dCube> getTubeBoxes() {
        List<Vec3dCube> aabbs = this.getOcclusionBoxes();
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (!this.connections[i] && !this.redstoneConnections[i] && this.getDeviceOnSide(d) == null) continue;
            Vec3dCube c = this.sideBB.clone().rotate(d, Vec3d.center);
            aabbs.add(c);
        }
        return aabbs;
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        ArrayList<Vec3dCube> aabbs = new ArrayList<Vec3dCube>();
        aabbs.add(new Vec3dCube(0.25, 0.25, 0.25, 0.75, 0.75, 0.75));
        return aabbs;
    }

    public void update() {
        if (this.initialized) {
            this.logic.update();
        }
        if (this.tick++ == 3) {
            this.clearCache();
            this.updateConnections();
        } else if (this.tick == 40) {
            this.sendUpdatePacket();
        }
        if (this.getWorld().field_72995_K && this.tick % 40 == 0) {
            this.clearCache();
        }
    }

    @Override
    public void onUpdate() {
        if (this.getParent() != null && this.getWorld() != null) {
            if (RedstoneApi.getInstance().shouldWiresHandleUpdates()) {
                this.getRedstoneConnectionCache().recalculateConnections();
                ForgeDirection d = ForgeDirection.UNKNOWN;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (this.getDeviceOnSide(dir) == null) continue;
                    d = dir;
                }
                RedstoneApi.getInstance().getRedstonePropagator(this, d).propagate();
                this.sendUpdatePacket();
            }
            this.clearCache();
            this.updateConnections();
        }
    }

    public TileEntity getTileCache(ForgeDirection d) {
        if (this.tileCache == null) {
            this.tileCache = new TileEntityCache(this.getWorld(), this.getX(), this.getY(), this.getZ());
        }
        return (TileEntity)this.tileCache.getValue(d);
    }

    public PneumaticTube getPartCache(ForgeDirection d) {
        if (this.partCache == null) {
            this.partCache = new PartCache(this.getWorld(), this.getX(), this.getY(), this.getZ(), PneumaticTube.class);
        }
        return (PneumaticTube)this.partCache.getValue(d);
    }

    public void clearCache() {
        this.tileCache = null;
        this.partCache = null;
    }

    public TubeLogic getLogic() {
        return this.logic;
    }

    protected boolean canConnectToInventories() {
        return true;
    }

    private void updateConnections() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            int connectionCount = 0;
            boolean clearedCache = false;
            this.clearCache();
            for (int i = 0; i < 6; ++i) {
                boolean oldState = this.connections[i];
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                TileEntity neighbor = this.getTileCache(d);
                this.connections[i] = IOHelper.canInterfaceWith(neighbor, d.getOpposite(), this, this.canConnectToInventories());
                if (!this.connections[i]) {
                    boolean bl = this.connections[i] = neighbor instanceof ITubeConnection && ((ITubeConnection)neighbor).isConnectedTo(d.getOpposite());
                }
                if (this.connections[i]) {
                    this.connections[i] = this.isConnected(d, null);
                }
                if (this.connections[i]) {
                    ++connectionCount;
                }
                if (clearedCache || oldState == this.connections[i]) continue;
                if (Config.enableTubeCaching) {
                    this.getLogic().clearNodeCaches();
                }
                clearedCache = true;
            }
            this.isCrossOver = connectionCount != 2;
            this.sendUpdatePacket();
        }
        this.initialized = true;
    }

    public boolean isConnected(ForgeDirection dir, PneumaticTube otherTube) {
        if (otherTube != null) {
            if (!(this instanceof Accelerator) && this instanceof MagTube != otherTube instanceof MagTube && !(otherTube instanceof Accelerator)) {
                return false;
            }
            IPneumaticTube.TubeColor otherTubeColor = otherTube.getColor(dir.getOpposite());
            if (otherTubeColor != IPneumaticTube.TubeColor.NONE && this.getColor(dir) != IPneumaticTube.TubeColor.NONE && this.getColor(dir) != otherTubeColor) {
                return false;
            }
        }
        return this.getWorld() == null || OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (boolean)true, (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)8, (ForgeDirection[])new ForgeDirection[]{dir});
    }

    public void writeToNBT(NBTTagCompound tag) {
        int i;
        super.writeToNBT(tag);
        for (i = 0; i < 6; ++i) {
            tag.func_74757_a("connections" + i, this.connections[i]);
            tag.func_74757_a("redstoneConnections" + i, this.getDeviceOnSide(ForgeDirection.getOrientation((int)i)) != null);
        }
        for (i = 0; i < this.color.length; ++i) {
            tag.func_74774_a("tubeColor" + i, (byte)this.color[i].ordinal());
        }
        if (this.redwireType != null) {
            tag.func_74768_a("wireType", this.redwireType.ordinal());
        }
        tag.func_74774_a("power", this.getPower());
        NBTTagCompound logicTag = new NBTTagCompound();
        this.logic.writeToNBT(logicTag);
        tag.func_74782_a("logic", (NBTBase)logicTag);
    }

    public void readFromNBT(NBTTagCompound tag) {
        int i;
        super.readFromNBT(tag);
        int connectionCount = 0;
        for (i = 0; i < 6; ++i) {
            this.connections[i] = tag.func_74767_n("connections" + i);
            this.redstoneConnections[i] = tag.func_74767_n("redstoneConnections" + i);
            if (!this.connections[i]) continue;
            ++connectionCount;
        }
        this.isCrossOver = connectionCount != 2;
        for (i = 0; i < this.color.length; ++i) {
            this.color[i] = IPneumaticTube.TubeColor.values()[tag.func_74771_c("tubeColor" + i)];
        }
        this.redwireType = tag.func_74764_b("wireType") ? RedwireType.values()[tag.func_74762_e("wireType")] : null;
        this.setRedstonePower(null, tag.func_74771_c("power"));
        if (this.getParent() != null && this.getWorld() != null) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
        NBTTagCompound logicTag = tag.func_74775_l("logic");
        this.logic.readFromNBT(logicTag);
    }

    public void writeUpdateData(DataOutput buffer) throws IOException {
        int i;
        super.writeUpdateData(buffer);
        for (i = 0; i < 6; ++i) {
            buffer.writeBoolean(this.connections[i]);
        }
        for (i = 0; i < 6; ++i) {
            buffer.writeBoolean(this.getDeviceOnSide(ForgeDirection.getOrientation((int)i)) != null);
        }
        for (i = 0; i < this.color.length; ++i) {
            buffer.writeInt(this.color[i].ordinal());
        }
        if (this.redwireType != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.redwireType.ordinal());
            buffer.writeByte(this.getPower());
        } else {
            buffer.writeBoolean(false);
        }
        this.logic.writeData(buffer);
    }

    public void readUpdateData(DataInput buffer) throws IOException {
        int i;
        int i2;
        super.readUpdateData(buffer);
        for (i2 = 0; i2 < 6; ++i2) {
            this.connections[i2] = buffer.readBoolean();
        }
        for (i2 = 0; i2 < 6; ++i2) {
            this.redstoneConnections[i2] = buffer.readBoolean();
        }
        int connectionCount = 0;
        for (i = 0; i < 6; ++i) {
            if (!this.connections[i] && !this.redstoneConnections[i]) continue;
            ++connectionCount;
        }
        this.isCrossOver = connectionCount != 2;
        for (i = 0; i < this.color.length; ++i) {
            this.color[i] = IPneumaticTube.TubeColor.values()[buffer.readInt()];
        }
        if (buffer.readBoolean()) {
            this.redwireType = RedwireType.values()[buffer.readInt()];
            this.setRedstonePower(null, buffer.readByte());
        } else {
            this.redwireType = null;
        }
        this.logic.readData(buffer);
        if (this.getParent() != null && this.getWorld() != null) {
            this.getWorld().func_147458_c(this.getX(), this.getY(), this.getZ(), this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition mop, ItemStack item) {
        if (this.getWorld() == null) {
            return false;
        }
        if (item != null) {
            IPneumaticTube.TubeColor newColor = null;
            if (item.func_77973_b() == BPItems.paint_brush && ((ItemDamageableColorableOverlay)BPItems.paint_brush).tryUseItem(item)) {
                newColor = IPneumaticTube.TubeColor.values()[item.func_77960_j()];
            } else if (item.func_77973_b() == Items.field_151131_as || item.func_77973_b() == BPItems.paint_brush && item.func_77960_j() == 16) {
                newColor = IPneumaticTube.TubeColor.NONE;
            }
            if (newColor != null) {
                if (!this.getWorld().field_72995_K) {
                    List<Vec3dCube> boxes = this.getTubeBoxes();
                    Vec3dCube box = mop.getCube();
                    int face = -1;
                    face = box.equals((Object)boxes.get(0)) ? mop.field_72310_e : this.getSideFromAABBIndex(boxes.indexOf(box));
                    this.color[face] = newColor;
                    this.updateConnections();
                    this.getLogic().clearNodeCaches();
                    this.notifyUpdate();
                }
                return true;
            }
            if (item.func_77973_b() instanceof ItemPart) {
                BPPart part = PartManager.getExample(item);
                if (this.redwireType == null && part instanceof PartRedwireFace.PartRedwireFaceUninsulated) {
                    if (!this.getWorld().field_72995_K) {
                        this.redwireType = ((IRedwire)((Object)part)).getRedwireType(ForgeDirection.UNKNOWN);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --item.field_77994_a;
                        }
                        this.getRedstoneConnectionCache().recalculateConnections();
                        RedstoneApi.getInstance().getRedstonePropagator(this, ForgeDirection.DOWN).propagate();
                        this.updateConnections();
                        this.getLogic().clearNodeCaches();
                        this.notifyUpdate();
                        this.sendUpdatePacket();
                    }
                    return true;
                }
            }
            if (this.redwireType != null && item.func_77973_b() instanceof IScrewdriver && player.func_70093_af()) {
                if (!this.getWorld().field_72995_K) {
                    IOHelper.spawnItemInWorld(this.getWorld(), PartManager.getPartInfo("wire." + this.redwireType.getName()).getStack(), (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
                    this.redwireType = null;
                    this.getRedstoneConnectionCache().recalculateConnections();
                    RedstoneApi.getInstance().getRedstonePropagator(this, ForgeDirection.DOWN).propagate();
                    ((IScrewdriver)item.func_77973_b()).damage(item, 1, player, false);
                    this.updateConnections();
                    this.getLogic().clearNodeCaches();
                    this.notifyUpdate();
                    this.sendUpdatePacket();
                }
                return true;
            }
        }
        return false;
    }

    public List<ItemStack> getDrops() {
        List drops = super.getDrops();
        for (TubeStack stack : this.logic.tubeStacks) {
            drops.add(stack.stack);
        }
        return drops;
    }

    public int getWeight() {
        return 1;
    }

    public IPneumaticTube.TubeColor getColor(ForgeDirection dir) {
        return this.color[dir.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d translation, double delta, int pass) {
        if (pass == 0 && !(this instanceof PneumaticTubeOpaque)) {
            this.logic.renderDynamic(translation, (float)delta);
            if (!this.shouldRenderNode()) {
                this.renderSide();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)-0.125, (double)0.0);
        Tessellator t = Tessellator.field_78398_a;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        t.func_78382_b();
        this.connections[ForgeDirection.DOWN.ordinal()] = true;
        this.connections[ForgeDirection.UP.ordinal()] = true;
        RenderHelper renderer = RenderHelper.instance;
        renderer.fullReset();
        RenderBlocks rb = new RenderBlocks();
        this.renderStatic(new Vec3i(0, 0, 0), renderer, rb, 0);
        this.renderStatic(new Vec3i(0, 0, 0), renderer, rb, 1);
        t.func_78381_a();
        this.renderSide();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glPopMatrix();
    }

    protected boolean shouldRenderNode() {
        boolean shouldRenderNode = false;
        int connectionCount = 0;
        for (int i = 0; i < 6; i += 2) {
            if (this.connections[i] != this.connections[i + 1] || this.redstoneConnections[i] != this.redstoneConnections[i + 1]) {
                shouldRenderNode = true;
                break;
            }
            if (this.connections[i] || this.redstoneConnections[i]) {
                ++connectionCount;
            }
            if (!this.connections[i + 1] && !this.redstoneConnections[i + 1]) continue;
            ++connectionCount;
        }
        return shouldRenderNode || connectionCount == 0 || connectionCount > 2;
    }

    private double getAddedThickness() {
        return 0.0;
    }

    protected boolean shouldRenderFully() {
        boolean renderFully = false;
        int count = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.shouldRenderConnection(ForgeDirection.getOrientation((int)i))) {
                ++count;
            }
            if (i % 2 != 0 || this.connections[i] == this.connections[i + 1]) continue;
            renderFully = true;
        }
        renderFully |= count > 2 || count == 0;
        return renderFully |= this.getParent() == null || this.getWorld() == null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i loc, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        block24: {
            boolean we;
            boolean ud;
            IIcon glass2;
            boolean renderFully;
            boolean east;
            boolean west;
            boolean south;
            boolean north;
            boolean up;
            boolean down;
            block23: {
                down = this.shouldRenderConnection(ForgeDirection.DOWN);
                up = this.shouldRenderConnection(ForgeDirection.UP);
                north = this.shouldRenderConnection(ForgeDirection.NORTH);
                south = this.shouldRenderConnection(ForgeDirection.SOUTH);
                west = this.shouldRenderConnection(ForgeDirection.WEST);
                east = this.shouldRenderConnection(ForgeDirection.EAST);
                renderFully = this.shouldRenderFully();
                if (this instanceof RestrictionTube) {
                    IIcon icon = IconSupplier.restrictionTubeSide;
                    renderer.renderBox(new Vec3dCube(0.25, 0.25, 0.25, 0.75, 0.75, 0.75), icon);
                }
                double addedThickness = this.getAddedThickness();
                double wireSize = (double)this.getSize() / 16.0;
                double frameSeparation = 0.375 - addedThickness - addedThickness - 0.001;
                double frameThickness = 0.0625 + addedThickness;
                if (pass != 0) break block23;
                if (this instanceof RestrictionTube) {
                    IIcon icon = IconSupplier.restrictionTubeSide;
                    renderer.renderBox(new Vec3dCube(0.25, 0.25, 0.25, 0.75, 0.75, 0.75), icon);
                }
                if (renderFully) {
                    renderer.setColor(this.getColorMultiplier());
                    this.renderFrame(renderer, wireSize, frameSeparation, frameThickness, true, true, true, true, true, true, down, up, west, east, north, south, true, this.getFrameIcon(), this.getFrameColorMultiplier());
                    renderer.setColor(0xFFFFFF);
                } else {
                    boolean isInWorld = this.getParent() != null;
                    renderer.setColor(this.getFrameColorMultiplier());
                    this.renderFrame(renderer, wireSize, frameSeparation, frameThickness, down, up, west, east, north, south, isInWorld, this.getFrameIcon(), this.getFrameColorMultiplier());
                }
                Vec3dCube side = new Vec3dCube(0.2890625, 0.0, 0.25 - addedThickness, 0.3203125 + addedThickness, 0.25, 0.265625);
                ForgeDirection[] side2 = new Vec3dCube(0.25 - addedThickness, 0.0, 0.2890625, 0.265625, 0.25, 0.3203125 + addedThickness);
                Vec3dCube side3 = new Vec3dCube(0.25 - addedThickness, 0.25 - addedThickness, 0.2890625, 0.265625, 0.28125, 0.7109375);
                Vec3dCube side4 = new Vec3dCube(0.2890625, 0.25 - addedThickness, 0.2890625, 0.3203125 + addedThickness, 0.265625, 0.6875);
                Vec3dCube side5 = new Vec3dCube(0.2890625, 0.25 - addedThickness, 0.2421875, 0.3203125 + addedThickness, 0.265625, 0.7578125);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    IPneumaticTube.TubeColor c = this.color[d.ordinal()];
                    if (c == IPneumaticTube.TubeColor.NONE) continue;
                    try {
                        int i;
                        renderer.setColor(MinecraftColor.values()[15 - c.ordinal()].getHex());
                        if (this.connections[d.ordinal()]) {
                            for (i = 0; i < 4; ++i) {
                                renderer.renderBox(side.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                                renderer.renderBox(side2.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                                if (!renderFully) continue;
                                renderer.renderBox(side3.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                            }
                        } else if (renderFully) {
                            for (i = 0; i < 4; ++i) {
                                renderer.renderBox(side4.clone().rotate(0, i * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                            }
                        } else {
                            for (i = 1; i < 4; i += 2) {
                                renderer.renderBox(side5.clone().rotate(0, (i + (this.shouldRenderConnection(ForgeDirection.NORTH) || this.shouldRenderConnection(ForgeDirection.UP) && (d == ForgeDirection.NORTH || d == ForgeDirection.SOUTH) ? 1 : 0)) * 90, 0, Vec3d.center).rotate(d, Vec3d.center), IconSupplier.pneumaticTubeColoring);
                            }
                        }
                        renderer.setColor(0xFFFFFF);
                    }
                    catch (Exception ex) {
                        System.out.println("Err on side " + d + ". Color: " + (Object)((Object)c));
                    }
                }
                if (this.redwireType == null) break block24;
                this.renderFrame(renderer, wireSize, frameSeparation -= 0.03125, frameThickness /= 1.5, renderFully || this.shouldRenderConnection(ForgeDirection.DOWN), renderFully || this.shouldRenderConnection(ForgeDirection.UP), renderFully || this.shouldRenderConnection(ForgeDirection.WEST), renderFully || this.shouldRenderConnection(ForgeDirection.EAST), renderFully || this.shouldRenderConnection(ForgeDirection.NORTH), renderFully || this.shouldRenderConnection(ForgeDirection.SOUTH), this.redstoneConnections[ForgeDirection.DOWN.ordinal()], this.redstoneConnections[ForgeDirection.UP.ordinal()], this.redstoneConnections[ForgeDirection.WEST.ordinal()], this.redstoneConnections[ForgeDirection.EAST.ordinal()], this.redstoneConnections[ForgeDirection.NORTH.ordinal()], this.redstoneConnections[ForgeDirection.SOUTH.ordinal()], this.getParent() != null && this.getWorld() != null, IconSupplier.wire, WireHelper.getColorForPowerLevel(this.redwireType, this.getPower()));
                Vec3dCube c = new Vec3dCube(0.48214285714285715, 0.0, 0.2, 0.5178571428571429, 0.03125, 0.8);
                renderer.setColor(WireHelper.getColorForPowerLevel(this.redwireType, this.getPower()));
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    if (!this.redstoneConnections[d.ordinal()] || this.connections[d.ordinal()]) continue;
                    renderer.addTransformation((Transformation)new Rotation(d));
                    for (int i = 0; i < 2; ++i) {
                        renderer.addTransformation((Transformation)new Rotation(0.0, (double)(45 + 90 * i), 0.0));
                        renderer.renderBox(c.clone(), IconSupplier.wire);
                        renderer.removeTransformation();
                    }
                    renderer.removeTransformation();
                }
                renderer.setColor(0xFFFFFF);
                break block24;
            }
            IIcon glass = this instanceof MagTube ? IconSupplier.magTubeGlass : IconSupplier.pneumaticTubeGlass;
            IIcon iIcon = glass2 = this instanceof MagTube ? IconSupplier.magTubeGlass2 : IconSupplier.pneumaticTubeGlass2;
            if (!(this instanceof RestrictionTube)) {
                renderer.setRenderSides(!down, !up, !west, !east, !north, !south);
                if (renderFully) {
                    renderer.renderBox(new Vec3dCube(0.28125, 0.28125, 0.28125, 0.71875, 0.71875, 0.71875), glass);
                } else {
                    boolean ud2 = west || east;
                    boolean we2 = north || south;
                    boolean ns = west || east;
                    renderer.setTextureRotations(ud2 ? 1 : 0, ud2 ? 1 : 0, we2 ? 1 : 0, we2 ? 1 : 0, ns ? 1 : 0, ns ? 1 : 0);
                    renderer.renderBox(new Vec3dCube(0.28125, 0.28125, 0.28125, 0.71875, 0.71875, 0.71875), glass2);
                }
                renderer.resetRenderedSides();
                renderer.resetTextureRotations();
            }
            Vec3dCube c = new Vec3dCube(0.28125, 0.0, 0.28125, 0.71875, 0.28125, 0.71875);
            if (renderFully) {
                ud = west || east;
                we = north || south;
                boolean ns = west || east;
                renderer.setTextureRotations(ud ? 1 : 0, ud ? 1 : 0, we ? 1 : 0, we ? 1 : 0, ns ? 1 : 0, ns ? 1 : 0);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    if (!this.shouldRenderConnection(d)) continue;
                    renderer.setRenderSide(d, false);
                    renderer.setRenderSide(d.getOpposite(), false);
                    renderer.renderBox(c.clone().rotate(d, Vec3d.center), glass);
                    renderer.resetRenderedSides();
                }
            } else {
                ud = west || east;
                we = north || south;
                boolean ns = west || east;
                renderer.setTextureRotations(ud ? 1 : 0, ud ? 1 : 0, we ? 1 : 0, we ? 1 : 0, ns ? 1 : 0, ns ? 1 : 0);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    if (!this.shouldRenderConnection(d)) continue;
                    renderer.setRenderSide(d, false);
                    renderer.setRenderSide(d.getOpposite(), false);
                    renderer.renderBox(c.clone().rotate(d, Vec3d.center), glass2);
                    renderer.resetRenderedSides();
                }
            }
        }
        return true;
    }

    public boolean shouldRenderOnPass(int pass) {
        return true;
    }

    protected void renderSide() {
    }

    private int getSideFromAABBIndex(int index) {
        int curIndex = 0;
        for (int side = 0; side < 6; ++side) {
            if (!this.connections[side] || index != ++curIndex) continue;
            return side;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getSideIcon() {
        return IconSupplier.pneumaticTubeSide;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        boolean addTooltip = false;
        for (IPneumaticTube.TubeColor col : this.color) {
            if (col == IPneumaticTube.TubeColor.NONE) continue;
            addTooltip = true;
            break;
        }
        if (addTooltip) {
            info.add((Object)((Object)Color.YELLOW) + I18n.func_135052_a((String)"waila.bluepower:pneumaticTube.color", (Object[])new Object[0]));
            for (int i = 0; i < 6; ++i) {
                if (this.color[i] == IPneumaticTube.TubeColor.NONE || this.color[i] == IPneumaticTube.TubeColor.NONE) continue;
                info.add(EnumChatFormatting.DARK_AQUA + I18n.func_135052_a((String)("bluepower:face." + ForgeDirection.getOrientation((int)i).toString().toLowerCase()), (Object[])new Object[0]) + ": " + EnumChatFormatting.WHITE + I18n.func_135052_a((String)("bluepower:color." + ItemDye.field_150923_a[this.color[i].ordinal()]), (Object[])new Object[0]));
            }
        }
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return BPCreativeTabs.machines;
    }

    @Override
    public int getHollowSize(ForgeDirection side) {
        return 8;
    }

    @Override
    protected boolean shouldRenderConnection(ForgeDirection side) {
        return this.connections[side.ordinal()] || this.redstoneConnections[side.ordinal()];
    }

    @Override
    protected int getSize() {
        return 0;
    }

    @Override
    protected IIcon getWireIcon(ForgeDirection side) {
        return null;
    }

    @Override
    protected IIcon getFrameIcon() {
        return this.getSideIcon();
    }

    public RedwireType getRedwireType() {
        return this.redwireType;
    }

    @Override
    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        QMovingObjectPosition mop = super.rayTrace(start, end);
        if (mop == null) {
            return null;
        }
        EntityPlayer player = BluePower.proxy.getPlayer();
        if (this.redwireType != null && player != null && player.func_70093_af()) {
            double wireSize = (double)this.getSize() / 16.0;
            double frameSeparation = 0.25 - (wireSize - 0.125);
            double frameThickness = 0.0625;
            QMovingObjectPosition wire = RayTracer.instance().rayTraceCubes(this.getFrameBoxes(wireSize, frameSeparation -= 0.03125, frameThickness /= 1.5, this.shouldRenderConnection(ForgeDirection.DOWN), this.shouldRenderConnection(ForgeDirection.UP), this.shouldRenderConnection(ForgeDirection.WEST), this.shouldRenderConnection(ForgeDirection.EAST), this.shouldRenderConnection(ForgeDirection.NORTH), this.shouldRenderConnection(ForgeDirection.SOUTH), this.redstoneConnections[ForgeDirection.DOWN.ordinal()], this.redstoneConnections[ForgeDirection.UP.ordinal()], this.redstoneConnections[ForgeDirection.WEST.ordinal()], this.redstoneConnections[ForgeDirection.EAST.ordinal()], this.redstoneConnections[ForgeDirection.NORTH.ordinal()], this.redstoneConnections[ForgeDirection.SOUTH.ordinal()], this.getParent() != null && this.getWorld() != null), start, end, new Vec3i((IWorldLocation)this));
            QMovingObjectPosition frame = RayTracer.instance().rayTraceCubes(this.getFrameBoxes(), start, end, new Vec3i((IWorldLocation)this));
            if (wire != null) {
                if (frame != null) {
                    if (wire.field_72307_f.func_72438_d(start.toVec3()) < frame.field_72307_f.func_72438_d(start.toVec3())) {
                        mop.hitInfo = PartManager.getPartInfo("wire." + this.redwireType.getName()).getStack();
                    }
                } else {
                    mop.hitInfo = PartManager.getPartInfo("wire." + this.redwireType.getName()).getStack();
                }
            }
        }
        return mop;
    }

    @Override
    public ItemStack getPickedItem(QMovingObjectPosition mop) {
        Object o = mop.hitInfo;
        if (o != null && o instanceof ItemStack) {
            return (ItemStack)o;
        }
        return super.getPickedItem(mop);
    }

    public int getStrongPower(ForgeDirection side) {
        return 0;
    }

    public int getWeakPower(ForgeDirection side) {
        if (this.getRedwireType() == null) {
            return 0;
        }
        return MathHelper.map((int)(this.getPower() & 0xFF), (int)0, (int)255, (int)0, (int)15);
    }

    public boolean canConnectRedstone(ForgeDirection side) {
        return this.getRedwireType() != null;
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
        if (type == ConnectionType.STRAIGHT) {
            if (this.getRedwireType(side) == null) {
                return false;
            }
            if (device instanceof IRedwire) {
                RedwireType rwt = this.getRedwireType(side);
                if (type == null) {
                    return false;
                }
                RedwireType rwt_ = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : side.getOpposite());
                if (rwt_ == null) {
                    return false;
                }
                if (!rwt.canConnectTo(rwt_)) {
                    return false;
                }
            }
            if (device instanceof IFace) {
                return ((IFace)((Object)device)).getFace() == side.getOpposite();
            }
            if (!OcclusionHelper.microblockOcclusionTest((Vec3i)new Vec3i((IWorldLocation)this), (MicroblockShape)MicroblockShape.FACE_HOLLOW, (int)8, (ForgeDirection[])new ForgeDirection[]{side})) {
                return false;
            }
            return !(device instanceof PneumaticTube) || device instanceof MagTube == this instanceof MagTube;
        }
        return false;
    }

    @Override
    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.redConnections;
    }

    @Override
    public void onConnect(IConnection<?> connection) {
        this.sendUpdatePacket();
    }

    @Override
    public void onDisconnect(IConnection<?> connection) {
        this.sendUpdatePacket();
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        if (!RedstoneApi.getInstance().shouldWiresOutputPower(this.hasLoss(side))) {
            return 0;
        }
        if (!this.isAnalogue(side)) {
            return (byte)((this.power & 0xFF) > 0 ? 255 : 0);
        }
        return this.power;
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
        this.power = power;
    }

    @Override
    public void onRedstoneUpdate() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IConnection<IRedstoneDevice> c = this.redConnections.getConnectionOnSide(dir);
            IRedstoneDevice dev = null;
            if (c != null) {
                dev = c.getB();
            }
            if (dev != null && !(dev instanceof DummyRedstoneDevice)) continue;
            RedstoneHelper.notifyRedstoneUpdate((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)dir, (boolean)false);
        }
        this.sendUpdatePacket();
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        if (this.getRedwireType() == null) {
            return false;
        }
        return this.getRedwireType().hasLoss();
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        if (this.getRedwireType() == null) {
            return false;
        }
        return this.getRedwireType().isAnalogue();
    }

    @Override
    public boolean canPropagateFrom(ForgeDirection fromSide) {
        return true;
    }

    public byte getPower() {
        return this.power;
    }

    public IRedstoneDevice getDeviceOnSide(ForgeDirection d) {
        IConnection<? extends IRedstoneDevice> c = this.getRedstoneConnectionCache().getConnectionOnSide(d);
        if (c == null) {
            return null;
        }
        return c.getB();
    }

    @Override
    public RedwireType getRedwireType(ForgeDirection side) {
        return this.getRedwireType();
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return false;
    }
}

