/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.item.ItemPart;
import com.bluepowermod.part.BPPart;
import com.bluepowermod.part.PartFactory;
import com.bluepowermod.part.PartInfo;
import com.bluepowermod.part.gate.analogue.GateComparator;
import com.bluepowermod.part.gate.analogue.GateInverter;
import com.bluepowermod.part.gate.analogue.GateLightCell;
import com.bluepowermod.part.gate.analogue.GateRegulableTorch;
import com.bluepowermod.part.gate.digital.GateAnd;
import com.bluepowermod.part.gate.digital.GateBuffer;
import com.bluepowermod.part.gate.digital.GateCounter;
import com.bluepowermod.part.gate.digital.GateMultiplexer;
import com.bluepowermod.part.gate.digital.GateNand;
import com.bluepowermod.part.gate.digital.GateNor;
import com.bluepowermod.part.gate.digital.GateNot;
import com.bluepowermod.part.gate.digital.GateOr;
import com.bluepowermod.part.gate.digital.GatePulseFormer;
import com.bluepowermod.part.gate.digital.GateRSLatch;
import com.bluepowermod.part.gate.digital.GateRandomizer;
import com.bluepowermod.part.gate.digital.GateRepeater;
import com.bluepowermod.part.gate.digital.GateSequencer;
import com.bluepowermod.part.gate.digital.GateStateCell;
import com.bluepowermod.part.gate.digital.GateSynchronizer;
import com.bluepowermod.part.gate.digital.GateTimer;
import com.bluepowermod.part.gate.digital.GateToggleLatch;
import com.bluepowermod.part.gate.digital.GateTransparentLatch;
import com.bluepowermod.part.gate.digital.GateXnor;
import com.bluepowermod.part.gate.digital.GateXor;
import com.bluepowermod.part.gate.ic.GateIntegratedCircuit;
import com.bluepowermod.part.gate.supported.GateNullCell;
import com.bluepowermod.part.gate.wireless.GateTransceiver;
import com.bluepowermod.part.lamp.PartCageLamp;
import com.bluepowermod.part.lamp.PartFixture;
import com.bluepowermod.part.tube.Accelerator;
import com.bluepowermod.part.tube.MagTube;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.tube.PneumaticTubeOpaque;
import com.bluepowermod.part.tube.RestrictionTube;
import com.bluepowermod.part.tube.RestrictionTubeOpaque;
import com.bluepowermod.part.wire.redstone.PartRedwireFace;
import com.bluepowermod.part.wire.redstone.PartRedwireFreestanding;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import uk.co.qmunity.lib.part.IPartFactory;
import uk.co.qmunity.lib.part.PartRegistry;

public class PartManager {
    private static Map<String, PartInfo> parts = new LinkedHashMap<String, PartInfo>();

    public static void registerPart(Class<? extends BPPart> clazz, Object ... arguments) {
        if (clazz == null) {
            return;
        }
        PartInfo info = new PartInfo(clazz, arguments);
        if (info.getType() == null) {
            return;
        }
        parts.put(info.getType(), info);
    }

    public static PartInfo getPartInfo(String type) {
        if (parts.containsKey(type)) {
            return parts.get(type);
        }
        return null;
    }

    public static String getPartType(ItemStack item) {
        try {
            return ((ItemPart)item.func_77973_b()).getPartType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BPPart createPart(ItemStack item) {
        return PartManager.getPartInfo(PartManager.getPartType(item)).create();
    }

    public static BPPart getExample(ItemStack item) {
        return PartManager.getExample(PartManager.getPartType(item));
    }

    public static BPPart getExample(String type) {
        return PartManager.getPartInfo(type).getExample();
    }

    public static List<PartInfo> getRegisteredParts() {
        ArrayList<PartInfo> l = new ArrayList<PartInfo>();
        for (String s : parts.keySet()) {
            l.add(parts.get(s));
        }
        return l;
    }

    public static void registerParts() {
        MinecraftColor c;
        int n;
        int n2;
        MinecraftColor[] minecraftColorArray;
        int i;
        PartRegistry.registerFactory((IPartFactory)new PartFactory());
        PartManager.registerPart(GateAnd.class, new Object[0]);
        PartManager.registerPart(GateNot.class, new Object[0]);
        PartManager.registerPart(GateOr.class, new Object[0]);
        PartManager.registerPart(GateNand.class, new Object[0]);
        PartManager.registerPart(GateBuffer.class, new Object[0]);
        PartManager.registerPart(GateXor.class, new Object[0]);
        PartManager.registerPart(GateXnor.class, new Object[0]);
        PartManager.registerPart(GateNor.class, new Object[0]);
        PartManager.registerPart(GateTimer.class, new Object[0]);
        PartManager.registerPart(GateSequencer.class, new Object[0]);
        PartManager.registerPart(GateCounter.class, new Object[0]);
        PartManager.registerPart(GateMultiplexer.class, new Object[0]);
        PartManager.registerPart(GatePulseFormer.class, new Object[0]);
        PartManager.registerPart(GateRandomizer.class, new Object[0]);
        PartManager.registerPart(GateToggleLatch.class, new Object[0]);
        PartManager.registerPart(GateRSLatch.class, new Object[0]);
        PartManager.registerPart(GateStateCell.class, new Object[0]);
        PartManager.registerPart(GateRepeater.class, new Object[0]);
        PartManager.registerPart(GateTransparentLatch.class, new Object[0]);
        PartManager.registerPart(GateSynchronizer.class, new Object[0]);
        PartManager.registerPart(GateInverter.class, new Object[0]);
        PartManager.registerPart(GateComparator.class, new Object[0]);
        PartManager.registerPart(GateLightCell.class, new Object[0]);
        PartManager.registerPart(GateRegulableTorch.class, new Object[0]);
        PartManager.registerPart(GateTransceiver.class, false, false);
        PartManager.registerPart(GateTransceiver.class, true, false);
        PartManager.registerPart(GateTransceiver.class, false, true);
        PartManager.registerPart(GateTransceiver.class, true, true);
        PartManager.registerPart(GateIntegratedCircuit.class, 3);
        PartManager.registerPart(GateIntegratedCircuit.class, 5);
        PartManager.registerPart(GateIntegratedCircuit.class, 7);
        PartManager.registerPart(GateNullCell.class, new Object[0]);
        for (i = 0; i < 2; ++i) {
            minecraftColorArray = MinecraftColor.VALID_COLORS;
            n2 = minecraftColorArray.length;
            for (n = 0; n < n2; ++n) {
                c = minecraftColorArray[n];
                PartManager.registerPart(PartCageLamp.class, new Object[]{c, i == 1});
            }
        }
        for (i = 0; i < 2; ++i) {
            minecraftColorArray = MinecraftColor.VALID_COLORS;
            n2 = minecraftColorArray.length;
            for (n = 0; n < n2; ++n) {
                c = minecraftColorArray[n];
                PartManager.registerPart(PartFixture.class, new Object[]{c, i == 1});
            }
        }
        PartManager.registerPart(PneumaticTube.class, new Object[0]);
        PartManager.registerPart(PneumaticTubeOpaque.class, new Object[0]);
        PartManager.registerPart(RestrictionTube.class, new Object[0]);
        PartManager.registerPart(RestrictionTubeOpaque.class, new Object[0]);
        PartManager.registerPart(MagTube.class, new Object[0]);
        PartManager.registerPart(Accelerator.class, new Object[0]);
        for (RedwireType type : RedwireType.values()) {
            PartManager.registerPart(PartRedwireFace.PartRedwireFaceUninsulated.class, new Object[]{type});
            for (MinecraftColor color : MinecraftColor.VALID_COLORS) {
                PartManager.registerPart(PartRedwireFace.PartRedwireFaceInsulated.class, new Object[]{type, color});
            }
            PartManager.registerPart(PartRedwireFace.PartRedwireFaceBundled.class, new Object[]{type, MinecraftColor.NONE});
            for (MinecraftColor color : MinecraftColor.VALID_COLORS) {
                PartManager.registerPart(PartRedwireFace.PartRedwireFaceBundled.class, new Object[]{type, color});
            }
        }
        for (RedwireType type : RedwireType.values()) {
            PartManager.registerPart(PartRedwireFreestanding.PartRedwireFreestandingUninsulated.class, new Object[]{type});
            for (MinecraftColor color : MinecraftColor.VALID_COLORS) {
                PartManager.registerPart(PartRedwireFreestanding.PartRedwireFreestandingInsulated.class, new Object[]{type, color});
            }
            PartManager.registerPart(PartRedwireFreestanding.PartRedwireFreestandingBundled.class, new Object[]{type, MinecraftColor.NONE});
            for (MinecraftColor color : MinecraftColor.VALID_COLORS) {
                PartManager.registerPart(PartRedwireFreestanding.PartRedwireFreestandingBundled.class, new Object[]{type, color});
            }
        }
    }

    public static void registerItems() {
        for (String s : parts.keySet()) {
            parts.get(s).registerItem();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        for (String s : parts.keySet()) {
            parts.get(s).registerRenderer();
        }
    }
}

