/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.api.misc.Accessibility;
import com.bluepowermod.api.wireless.IWirelessDevice;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageWirelessFrequencySync;
import com.bluepowermod.part.gate.wireless.Frequency;
import com.bluepowermod.part.gate.wireless.IWirelessGate;
import com.bluepowermod.part.gate.wireless.WirelessManager;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.vec.IWorldLocation;

public class MessageWirelessNewFreq
extends LocatedPacket<MessageWirelessNewFreq> {
    private Accessibility acc;
    private String name;
    private boolean bundled;
    private ForgeDirection face;

    public MessageWirelessNewFreq(IWirelessGate gate, Accessibility newAccessibility, String newName, boolean bundled) {
        super((IWorldLocation)gate);
        this.acc = newAccessibility;
        this.name = newName;
        this.bundled = bundled;
        this.face = gate.getFace();
    }

    public MessageWirelessNewFreq() {
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        Frequency freq = (Frequency)WirelessManager.COMMON_INSTANCE.registerFrequency(player, this.name, this.acc, this.bundled);
        ITilePartHolder h = MultipartCompatibility.getPartHolder((World)player.field_70170_p, (int)this.x, (int)this.y, (int)this.z);
        if (h == null) {
            return;
        }
        IWirelessDevice p = null;
        for (IPart pa : h.getParts()) {
            if (!(pa instanceof IWirelessGate) || ((IWirelessGate)pa).getFace() != this.face) continue;
            p = (IWirelessGate)pa;
        }
        if (p == null) {
            return;
        }
        p.setFrequency(freq);
        BPNetworkHandler.INSTANCE.sendTo((IMessage)new MessageWirelessFrequencySync(player), (EntityPlayerMP)player);
    }

    public void write(DataOutput buffer) throws IOException {
        super.write(buffer);
        buffer.writeInt(this.acc.ordinal());
        buffer.writeUTF(this.name);
        buffer.writeBoolean(this.bundled);
        buffer.writeInt(this.face.ordinal());
    }

    public void read(DataInput buffer) throws IOException {
        super.read(buffer);
        this.acc = Accessibility.values()[buffer.readInt()];
        this.name = buffer.readUTF();
        this.bundled = buffer.readBoolean();
        this.face = ForgeDirection.getOrientation((int)buffer.readInt());
    }
}

