/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.machine.BlockLamp;
import com.bluepowermod.client.render.RenderHelper;
import com.bluepowermod.tile.tier1.TileLamp;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

@SideOnly(value=Side.CLIENT)
public class RenderLamp
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static int pass;

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return RENDER_ID;
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        if (!(te.func_145838_q() instanceof BlockLamp)) {
            return;
        }
        if (pass != 0) {
            BlockLamp bLamp = (BlockLamp)te.func_145838_q();
            int power = ((TileLamp)te).getPower();
            int color = bLamp.getColor((IBlockAccess)te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
            int redMask = 0xFF0000;
            int greenMask = 65280;
            int blueMask = 255;
            int r = (color & redMask) >> 16;
            int g = (color & greenMask) >> 8;
            int b = color & blueMask;
            if (bLamp.isInverted()) {
                power = 15 - power;
            }
            Vec3i vector = new Vec3i(te);
            Vec3dCube box = new Vec3dCube(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5).expand(0.05);
            boolean[] renderFaces = new boolean[]{true, true, true, true, true, true};
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                Vec3i v = vector.getRelative(d);
                Block bl = v.getBlock();
                if (!(bl instanceof BlockLamp) || ((BlockLamp)bl).getPower((IBlockAccess)v.getWorld(), v.getX(), v.getY(), v.getZ()) <= 0) continue;
                if (d.offsetX < 0) {
                    box.getMin().setX(-0.5);
                    renderFaces[2] = false;
                    continue;
                }
                if (d.offsetY < 0) {
                    box.getMin().setY(-0.5);
                    renderFaces[1] = false;
                    continue;
                }
                if (d.offsetZ < 0) {
                    box.getMin().setZ(-0.5);
                    renderFaces[4] = false;
                    continue;
                }
                if (d.offsetX > 0) {
                    box.getMax().setX(0.5);
                    renderFaces[3] = false;
                    continue;
                }
                if (d.offsetY > 0) {
                    box.getMax().setY(0.5);
                    renderFaces[0] = false;
                    continue;
                }
                if (d.offsetZ <= 0) continue;
                box.getMax().setZ(0.5);
                renderFaces[5] = false;
            }
            box.getMin().add(0.5, 0.5, 0.5);
            box.getMax().add(0.5, 0.5, 0.5);
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glBegin((int)7);
            double powerDivision = (double)power / 18.0;
            RenderHelper.drawColoredCube(box, (double)r / 256.0, (double)g / 256.0, (double)b / 256.0, powerDivision * 0.625, renderFaces);
            GL11.glEnd();
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        switch (type) {
            case ENTITY: {
                GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
                break;
            }
            case EQUIPPED: {
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
                break;
            }
            case INVENTORY: {
                GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
                break;
            }
        }
        BlockLamp block = (BlockLamp)Block.func_149634_a((Item)item.func_77973_b());
        int redMask = 0xFF0000;
        int greenMask = 65280;
        int blueMask = 255;
        int r = (block.getColor() & redMask) >> 16;
        int g = (block.getColor() & greenMask) >> 8;
        int b = block.getColor() & blueMask;
        Vec3dCube cube = new Vec3dCube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78376_a(r, g, b);
        uk.co.qmunity.lib.client.render.RenderHelper h = uk.co.qmunity.lib.client.render.RenderHelper.instance;
        h.reset();
        h.setColor(block.getColor());
        h.renderBox(cube, block.isInverted() ? BlockLamp.on : BlockLamp.off);
        h.reset();
        t.func_78381_a();
        if (block.isInverted()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glBegin((int)7);
            RenderHelper.drawColoredCube(cube.clone().expand(0.05), (double)r / 256.0, (double)g / 256.0, (double)b / 256.0, 0.625, new boolean[0]);
            GL11.glEnd();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }
}

