/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.widgets.ImageLabel;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ImageChoiceLabel
extends ImageLabel<ImageChoiceLabel> {
    private List<String> choiceList = new ArrayList<String>();
    private List<List<String>> tooltipList = new ArrayList<List<String>>();
    private List<ResourceLocation> imageList = new ArrayList<ResourceLocation>();
    private List<Integer> uList = new ArrayList<Integer>();
    private List<Integer> vList = new ArrayList<Integer>();
    private int currentChoice = -1;
    private List<ChoiceEvent> choiceEvents = null;

    public ImageChoiceLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    @Override
    public List<String> getTooltips() {
        if (this.currentChoice == -1) {
            return super.getTooltips();
        }
        return this.tooltipList.get(this.currentChoice);
    }

    public ImageChoiceLabel addChoice(String choice, String tooltips, ResourceLocation image, int u, int v) {
        this.choiceList.add(choice);
        this.tooltipList.add(Arrays.asList(StringUtils.split((String)tooltips, (String)"\n")));
        this.imageList.add(image);
        this.uList.add(u);
        this.vList.add(v);
        if (this.currentChoice == -1) {
            this.currentChoice = 0;
            this.setCurrentChoice(this.currentChoice);
        }
        return this;
    }

    public void clear() {
        this.choiceList.clear();
        this.tooltipList.clear();
        this.imageList.clear();
        this.uList.clear();
        this.vList.clear();
        this.currentChoice = -1;
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            ++this.currentChoice;
            if (this.currentChoice >= this.choiceList.size()) {
                this.currentChoice = 0;
            }
            this.setCurrentChoice(this.currentChoice);
            this.fireChoiceEvents(this.choiceList.get(this.currentChoice));
        }
        return null;
    }

    public void setCurrentChoice(int currentChoice) {
        this.currentChoice = currentChoice;
        this.setImage(this.imageList.get(currentChoice), this.uList.get(currentChoice), this.vList.get(currentChoice));
    }

    public int findChoice(String choice) {
        if (choice == null) {
            return -1;
        }
        int i = 0;
        for (String s : this.choiceList) {
            if (choice.equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setCurrentChoice(String choice) {
        int idx = this.findChoice(choice);
        if (idx != -1) {
            this.setCurrentChoice(idx);
        }
    }

    public int getCurrentChoiceIndex() {
        return this.currentChoice;
    }

    public String getCurrentChoice() {
        if (this.currentChoice == -1) {
            return null;
        }
        return this.choiceList.get(this.currentChoice);
    }

    public ImageChoiceLabel addChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(String choice) {
        if (this.choiceEvents != null) {
            for (ChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, choice);
            }
        }
    }
}

