/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature.vanilla;

import com.google.common.base.Objects;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractLargeVanillaTree
extends AbstractTree {
    private static final byte[] otherCoordPairs = new byte[]{2, 0, 0, 1, 2, 1};
    private static final double HEIGHT_ATTENUATION = 0.618;
    private static final double BRANCH_SLOPE = 0.381;
    private static final double SCALE_WIDTH = 1.1;
    private static final double LEAF_DENSITY = 1.0;
    private static final int HEIGHT_LIMIT_LIMIT = 12;
    private static final int LEAF_DISTANCE_LIMIT = 4;
    private final Random rng = new Random();
    private final int[] basePos = new int[]{0, 0, 0};
    private int heightLimit = 0;
    private int[][] leafNodes = null;
    private int logMetaMask = 0;

    protected AbstractLargeVanillaTree(boolean fromSapling) {
        super(fromSapling);
    }

    private static float leafSize(int distance) {
        return distance >= 0 && distance < 4 ? (distance != 0 && distance != 3 ? 3.0f : 2.0f) : -1.0f;
    }

    private int checkBlockLine(World world, int[] start, int[] end) {
        int[] current = new int[]{0, 0, 0};
        int xIndex = 0;
        for (int i = 0; i < 3; ++i) {
            current[i] = end[i] - start[i];
            if (Math.abs(current[i]) <= Math.abs(current[xIndex])) continue;
            xIndex = i;
        }
        if (current[xIndex] == 0) {
            return -1;
        }
        byte yIndex = otherCoordPairs[xIndex];
        byte zindex = otherCoordPairs[xIndex + 3];
        int xVariance = current[xIndex] > 0 ? 1 : -1;
        double ySlope = (double)current[yIndex] / (double)current[xIndex];
        double zSlope = (double)current[zindex] / (double)current[xIndex];
        int[] coord = new int[]{0, 0, 0};
        int xLimit = current[xIndex] + xVariance;
        for (int dX = 0; dX != xLimit; dX += xVariance) {
            coord[xIndex] = start[xIndex] + dX;
            coord[yIndex] = MathHelper.func_76128_c((double)((double)start[yIndex] + (double)dX * ySlope));
            coord[zindex] = MathHelper.func_76128_c((double)((double)start[zindex] + (double)dX * zSlope));
            if (this.isReplaceable(world, coord[0], coord[1], coord[2])) continue;
            return Math.abs(dX);
        }
        return -1;
    }

    @Override
    protected boolean isPoorGrowthConditions(World world, int x, int y, int z, int height, IPlantable plantable) {
        if (y < 1 || y + height + 1 > world.func_72800_K()) {
            return true;
        }
        Block block = world.func_147439_a(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        return !block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, plantable) || !this.hasRoomToGrow(world, x, y, z, height);
    }

    @Override
    protected boolean hasRoomToGrow(World world, int x, int y, int z, int height) {
        int[] bottom = new int[]{x, y, z};
        int[] top = new int[]{x, y + this.heightLimit - 1, z};
        int maxHeight = this.checkBlockLine(world, bottom, top);
        if (maxHeight == -1) {
            return true;
        }
        if (maxHeight < 6) {
            return false;
        }
        this.heightLimit = maxHeight;
        return true;
    }

    @Override
    protected final int getLogMetadata() {
        return this.getUnmaskedLogMeta() | this.logMetaMask;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("rng", (Object)this.rng).add("basePos", (Object)this.basePos).add("heightLimit", this.heightLimit).add("leafNodes", (Object)this.leafNodes).add("logMetaMask", this.logMetaMask).toString();
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        this.rng.setSeed(rand.nextLong());
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        this.heightLimit = 5 + rand.nextInt(12);
        if (this.isPoorGrowthConditions(world, x, y, z, this.heightLimit, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        int height = this.generateLeafNodeList(world);
        this.generateLeaves(world);
        this.generateTrunk(world, x, y, z, height);
        this.generateLeafNodeBases(world, x, y, z);
        return true;
    }

    private void generateLeafNodeBases(World world, int x, int y, int z) {
        int j = this.leafNodes.length;
        int[] aint = new int[]{x, y, z};
        for (int i = 0; i < j; ++i) {
            int[] aint1 = this.leafNodes[i];
            int[] aint2 = new int[]{aint1[0], aint1[1], aint1[2]};
            aint[1] = aint1[3];
            int k = aint[1] - this.basePos[1];
            if (!this.leafNodeNeedsBase(k)) continue;
            this.placeBlockLine(world, aint, aint2);
        }
    }

    boolean leafNodeNeedsBase(int distance) {
        return (double)distance >= (double)this.heightLimit * 0.2;
    }

    private void generateTrunk(World world, int x, int y, int z, int height) {
        int[] bottom = new int[]{x, y, z};
        int[] top = new int[]{x, y + height, z};
        this.placeBlockLine(world, bottom, top);
    }

    private void placeBlockLine(World world, int[] start, int[] end) {
        int[] aint2 = new int[]{0, 0, 0};
        int b1 = 0;
        for (int b0 = 0; b0 < 3; b0 = (int)((byte)(b0 + 1))) {
            aint2[b0] = end[b0] - start[b0];
            if (Math.abs(aint2[b0]) <= Math.abs(aint2[b1])) continue;
            b1 = b0;
        }
        if (aint2[b1] != 0) {
            byte b2 = otherCoordPairs[b1];
            byte b3 = otherCoordPairs[b1 + 3];
            int b4 = aint2[b1] > 0 ? 1 : -1;
            double d0 = (double)aint2[b2] / (double)aint2[b1];
            double d1 = (double)aint2[b3] / (double)aint2[b1];
            int[] aint3 = new int[]{0, 0, 0};
            int j = aint2[b1] + b4;
            for (int i = 0; i != j; i += b4) {
                int zDistance;
                aint3[b1] = MathHelper.func_76128_c((double)((double)(start[b1] + i) + 0.5));
                aint3[b2] = MathHelper.func_76128_c((double)((double)start[b2] + (double)i * d0 + 0.5));
                aint3[b3] = MathHelper.func_76128_c((double)((double)start[b3] + (double)i * d1 + 0.5));
                int xDistance = Math.abs(aint3[0] - start[0]);
                int distance = Math.max(xDistance, zDistance = Math.abs(aint3[2] - start[2]));
                if (distance > 0) {
                    if (xDistance == distance) {
                        this.logMetaMask = 4;
                    } else if (zDistance == distance) {
                        this.logMetaMask = 8;
                    }
                }
                this.placeLog(world, aint3[0], aint3[1], aint3[2]);
                this.logMetaMask = 0;
            }
        }
    }

    protected abstract int getUnmaskedLogMeta();

    private void generateLeaves(World world) {
        int length = this.leafNodes.length;
        for (int node = 0; node < length; ++node) {
            this.generateLeafNode(world, this.leafNodes[node][0], this.leafNodes[node][1], this.leafNodes[node][2]);
        }
    }

    private void generateLeafNode(World world, int x, int y, int z) {
        for (int y1 = y; y1 < y + 4; ++y1) {
            float size = AbstractLargeVanillaTree.leafSize(y1 - y);
            this.genTreeLayer(world, x, y1, z, size, (byte)1);
        }
    }

    private void genTreeLayer(World world, int x, int y, int z, float size, byte index) {
        int var7 = (int)((double)size + 0.618);
        byte var8 = otherCoordPairs[index];
        byte var9 = otherCoordPairs[index + 3];
        int[] var10 = new int[]{x, y, z};
        int[] var11 = new int[]{0, 0, 0};
        var11[index] = var10[index];
        for (int var12 = -var7; var12 <= var7; ++var12) {
            var11[var8] = var10[var8] + var12;
            int var13 = -var7;
            while (var13 <= var7) {
                double var15 = StrictMath.pow((double)Math.abs(var12) + 0.5, 2.0) + StrictMath.pow((double)Math.abs(var13) + 0.5, 2.0);
                if (var15 > (double)(size * size)) {
                    ++var13;
                    continue;
                }
                var11[var9] = var10[var9] + var13;
                Block block = world.func_147439_a(var11[0], var11[1], var11[2]);
                if (block != null && block.isLeaves((IBlockAccess)world, var11[0], var11[1], var11[2])) {
                    ++var13;
                    continue;
                }
                this.placeLeaves(world, var11[0], var11[1], var11[2]);
                ++var13;
            }
        }
    }

    private int generateLeafNodeList(World world) {
        int leavesPortion;
        int height = (int)((double)this.heightLimit * 0.618);
        if (height >= this.heightLimit) {
            height = this.heightLimit - 1;
        }
        if ((leavesPortion = (int)(1.382 + StrictMath.pow(1.0 * (double)this.heightLimit / 13.0, 2.0))) < 1) {
            leavesPortion = 1;
        }
        int[][] nodeList = new int[leavesPortion * this.heightLimit][4];
        int leafLimit = this.basePos[1] + this.heightLimit - 4;
        int trunkTopY = this.basePos[1] + height;
        int canopyHeight = leafLimit - this.basePos[1];
        nodeList[0][0] = this.basePos[0];
        nodeList[0][1] = leafLimit--;
        nodeList[0][2] = this.basePos[2];
        nodeList[0][3] = trunkTopY;
        int var4 = 1;
        while (canopyHeight >= 0) {
            float var8 = this.layerSize(canopyHeight);
            if (var8 < 0.0f) {
                --leafLimit;
                --canopyHeight;
                continue;
            }
            double var9 = 0.5;
            for (int var7 = 0; var7 < leavesPortion; ++var7) {
                int[] var18;
                int var16;
                double var13;
                double var11 = 1.1 * (double)var8 * ((double)this.rng.nextFloat() + 0.328);
                int var15 = MathHelper.func_76128_c((double)(var11 * StrictMath.sin(var13 = (double)this.rng.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + 0.5));
                int[] var17 = new int[]{var15, leafLimit, var16 = MathHelper.func_76128_c((double)(var11 * StrictMath.cos(var13) + (double)this.basePos[2] + 0.5))};
                if (this.checkBlockLine(world, var17, var18 = new int[]{var15, leafLimit + 4, var16}) != -1) continue;
                int[] var19 = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double var20 = Math.sqrt(StrictMath.pow(Math.abs(this.basePos[0] - var17[0]), 2.0) + StrictMath.pow(Math.abs(this.basePos[2] - var17[2]), 2.0));
                double var22 = var20 * 0.381;
                int n = var19[1] = (double)var17[1] - var22 > (double)trunkTopY ? trunkTopY : (int)((double)var17[1] - var22);
                if (this.checkBlockLine(world, var19, var17) != -1) continue;
                nodeList[var4][0] = var15;
                nodeList[var4][1] = leafLimit;
                nodeList[var4][2] = var16;
                nodeList[var4][3] = var19[1];
                ++var4;
            }
            --leafLimit;
            --canopyHeight;
        }
        this.leafNodes = new int[var4][4];
        System.arraycopy(nodeList, 0, this.leafNodes, 0, var4);
        return height;
    }

    private float layerSize(int level) {
        if ((double)level < (double)this.heightLimit * 0.3) {
            return -1.618f;
        }
        float maxSize = (float)this.heightLimit / 2.0f;
        float height = (float)this.heightLimit / 2.0f - (float)level;
        float size = height == 0.0f ? maxSize : (Math.abs(height) >= maxSize ? 0.0f : (float)Math.sqrt(StrictMath.pow(Math.abs(maxSize), 2.0) - StrictMath.pow(Math.abs(height), 2.0)));
        return size *= 0.5f;
    }
}

