/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.content.overworld;

import com.google.common.collect.ImmutableList;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class OverworldTreeGenerator
implements IWorldGenerator {
    private static final int GENERATOR_WEIGHT = 0;

    public void install() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        int x;
        BiomeGenBase biome;
        ImmutableList biomeTypes;
        Settings settings = Settings.INSTANCE;
        if (settings.isOverworldTreeGenEnabled() && !(biomeTypes = ImmutableList.copyOf((Object[])BiomeDictionary.getTypesForBiome((BiomeGenBase)(biome = world.func_72807_a(x = (chunkX << 4) + 8 + random.nextInt(16), z = (chunkZ << 4) + 8 + random.nextInt(16)))))).contains(BiomeDictionary.Type.NETHER) && !biomeTypes.contains(BiomeDictionary.Type.END) && random.nextInt(settings.overworldTreeGenRarity()) == 0) {
            OverworldTreeSpecies species = OverworldTreeSpecies.values()[random.nextInt(OverworldTreeSpecies.values().length)];
            WorldGenerator tree = species.worldTreeGenerator();
            int maxY = world.func_72976_f(x, z) * 2;
            int y = maxY > 0 ? random.nextInt(maxY) : 0;
            tree.func_76484_a(world, random, x, y, z);
        }
    }
}

