/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.forestry;

import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.koresample.compat.Integrator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.RecipeManagers;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class ForestryMod
extends Integrator {
    private static final String MOD_ID = "Forestry";
    private static final String MOD_NAME = "Forestry";

    private static void addBackpackItem(String backpack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        ForestryMod.addBackpackItem(backpack, stack.func_77973_b(), stack.func_77960_j());
    }

    private static void addBackpackItem(String backpack, Item item, int damage) {
        ForestryMod.sendBackpackMessage(String.format("%s@%s:%d", backpack, GameRegistry.findUniqueIdentifierFor((Item)item), damage));
    }

    private static void addBackpackItems() {
        TheMod.logger().info("Extending Forestry's backpacks.", new Object[0]);
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            ItemStack sapling = new ItemStack((Block)tree.saplingBlock(), 1, tree.saplingSubBlockIndex());
            ForestryMod.addBackpackItem("forester", sapling);
            ItemStack log = new ItemStack((Block)tree.logBlock(), 1, tree.logSubBlockIndex());
            ForestryMod.addBackpackItem("forester", log);
            ItemStack leaves = new ItemStack((Block)tree.leavesBlock(), 1, tree.leavesSubBlockIndex());
            ForestryMod.addBackpackItem("forester", leaves);
            ItemStack stairs = new ItemStack((Block)tree.stairsBlock());
            ForestryMod.addBackpackItem("builder", stairs);
        }
    }

    private static void addFarmables() {
        TheMod.logger().info("Adding farmable saplings to Forestry's farms.", new Object[0]);
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            ItemStack sapling = new ItemStack((Block)tree.saplingBlock(), 1, tree.saplingSubBlockIndex());
            ForestryMod.addFarmableSapling(sapling);
        }
    }

    private static void addFarmableSapling(ItemStack stack) {
        if (stack == null) {
            return;
        }
        ForestryMod.addFarmableSapling(stack.func_77973_b(), stack.func_77960_j());
    }

    private static void addFarmableSapling(Item item, int damage) {
        ForestryMod.sendFarmableMessage(String.format("farmArboreal@%s:%d", GameRegistry.findUniqueIdentifierFor((Item)item), damage));
    }

    @Optional.Method(modid="Forestry")
    private static void addSaplingRecipes() {
        TheMod.logger().info("Adding sapling recipes to Forestry's fermenter.", new Object[0]);
        int fermentationValue = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            ItemStack sapling = new ItemStack((Block)tree.saplingBlock(), 1, tree.saplingSubBlockIndex());
            RecipeManagers.fermenterManager.addRecipe(sapling, fermentationValue, 1.0f, ForestryMod.fluidStack("biomass"), ForestryMod.fluidStack("water"));
            RecipeManagers.fermenterManager.addRecipe(sapling, fermentationValue, 1.5f, ForestryMod.fluidStack("biomass"), ForestryMod.fluidStack("juice"));
            RecipeManagers.fermenterManager.addRecipe(sapling, fermentationValue, 1.5f, ForestryMod.fluidStack("biomass"), ForestryMod.fluidStack("honey"));
        }
    }

    private static void sendBackpackMessage(String message) {
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)message);
    }

    private static void sendFarmableMessage(String message) {
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)message);
    }

    private static FluidStack fluidStack(String fluidName) {
        return FluidRegistry.getFluidStack((String)fluidName, (int)1000);
    }

    private static void init() {
        ForestryMod.addFarmables();
    }

    @Optional.Method(modid="Forestry")
    private static void postInit() {
        ForestryMod.addBackpackItems();
        ForestryMod.addSaplingRecipes();
    }

    public void doIntegration(LoaderState.ModState modState) {
        if (Loader.isModLoaded((String)"Forestry") && Settings.INSTANCE.integrateForestry()) {
            switch (modState) {
                case INITIALIZED: {
                    ForestryMod.init();
                    break;
                }
                case POSTINITIALIZED: {
                    ForestryMod.postInit();
                    break;
                }
            }
        }
    }

    protected String modID() {
        return "Forestry";
    }

    protected String modName() {
        return "Forestry";
    }
}

