/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.OreCraftingBenchRecipe;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class ThaumicTinkererRecipeMulti
extends ThaumicTinkererRecipe {
    public List<ThaumicTinkererRecipe> recipes;

    public ThaumicTinkererRecipeMulti(ThaumicTinkererRecipe ... recipes) {
        this.recipes = Arrays.asList(recipes);
    }

    public ThaumicTinkererRecipeMulti() {
        this.recipes = new ArrayList<ThaumicTinkererRecipe>();
    }

    public void addRecipe(ThaumicTinkererRecipe recipe) {
        this.recipes.add(recipe);
    }

    public List<IRecipe> getIRecipies(int start, int end) {
        List<ThaumicTinkererRecipe> subsetRecipies = this.recipes.subList(start, end);
        ArrayList<IRecipe> result = new ArrayList<IRecipe>();
        for (ThaumicTinkererRecipe recipe : subsetRecipies) {
            if (recipe instanceof CraftingBenchRecipe) {
                result.add(((CraftingBenchRecipe)recipe).iRecipe);
            }
            if (!(recipe instanceof OreCraftingBenchRecipe)) continue;
            result.add(((OreCraftingBenchRecipe)recipe).iRecipe);
        }
        return result;
    }

    public List<IRecipe> getIRecipies() {
        return this.getIRecipies(0, this.recipes.size());
    }

    @Override
    public void registerRecipe() {
        for (ThaumicTinkererRecipe recipe : this.recipes) {
            recipe.registerRecipe();
        }
    }
}

