/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.main.ParticleEffects;

public class PacketBurst
implements IMessage,
IMessageHandler<PacketBurst, IMessage> {
    public static final String[] particles = new String[]{"spell", "magicCrit", "crit", "happyVillager", "fireworksSpark", "enchantmenttable", "square", "witchMagic"};
    public double x;
    public double y;
    public double z;
    public double r;
    public double g;
    public double b;
    public double comp;
    int type = 0;
    private World world;
    private CoordTuple from;
    private CoordTuple to;
    private String particle;

    public PacketBurst(CoordTuple from, CoordTuple to, String particle, double r, double g, double b, double comp) {
        this.from = from;
        this.to = to;
        this.particle = particle;
        this.type = 0;
        this.r = r;
        this.g = g;
        this.b = b;
        this.comp = comp;
    }

    public PacketBurst(int i, double x, double y, double z) {
        this.type = i;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketBurst(int i, double x, double y, double z, CoordTuple from) {
        this.type = i;
        this.x = x;
        this.y = y;
        this.z = z;
        this.from = from;
    }

    public PacketBurst() {
    }

    public IMessage onMessage(PacketBurst msg, MessageContext ctx) {
        if (msg.world.field_72995_K) {
            double posZ;
            double posY;
            double posX;
            double theta;
            double rho;
            if (msg.type == 0 && msg.comp != 0.0) {
                Vec3 velocity = CoordTuple.vec(msg.to.subtract(msg.from));
                velocity = velocity.func_72432_b();
                double dist = msg.to.dist(msg.from);
                int density = (int)(5.0 * msg.comp);
                int count = 0;
                while ((double)count < dist * (double)density) {
                    double i = (double)count / (double)density;
                    if (msg.comp < 1.0) {
                        i += new Random().nextDouble() * (double)(1 / density);
                    }
                    double xp = (double)msg.from.getX() + velocity.field_72450_a * i + 0.5;
                    double yp = (double)msg.from.getY() + velocity.field_72448_b * i + 0.5;
                    double zp = (double)msg.from.getZ() + velocity.field_72449_c * i + 0.5;
                    ParticleEffects.spawnParticle(msg.particle, xp, yp, zp, velocity.field_72450_a * 0.1, 0.15, velocity.field_72449_c * 0.1, msg.r, msg.g, msg.b);
                    ++count;
                }
            }
            if (msg.type == 1) {
                for (int i = 0; i < 50; ++i) {
                    Random rand = new Random();
                    msg.world.func_72869_a("flame", msg.x, msg.y, msg.z, (rand.nextDouble() - 0.5) / 16.0, rand.nextDouble() / 16.0, (rand.nextDouble() - 0.5) / 16.0);
                }
            }
            if (msg.type == 6) {
                for (int i = 0; i < 50; ++i) {
                    Random rand = new Random();
                    msg.world.func_72869_a("spell", msg.x, msg.y, msg.z, (rand.nextDouble() - 0.5) / 16.0, rand.nextDouble() / 16.0, (rand.nextDouble() - 0.5) / 16.0);
                }
            }
            if (msg.type == 2) {
                for (int i = 0; i < 50; ++i) {
                    Random rand = new Random();
                    msg.world.func_72869_a("explode", msg.x, msg.y, msg.z, (rand.nextDouble() - 0.5) / 4.0, rand.nextDouble() / 4.0, (rand.nextDouble() - 0.5) / 4.0);
                }
            }
            if (msg.type == 3) {
                for (int i = 0; i < 200; ++i) {
                    Random rand = new Random();
                    double posX2 = msg.x + rand.nextDouble() * 8.0 - 4.0;
                    double posY2 = msg.y + rand.nextDouble() * 8.0 - 4.0;
                    double posZ2 = msg.z + rand.nextDouble() * 8.0 - 4.0;
                    ParticleEffects.spawnParticle("fireworksSpark", posX2, posY2, posZ2, 0.1 * (msg.x - posX2), 0.1 * (msg.y - posY2), 0.1 * (msg.z - posZ2));
                }
            }
            if (msg.type == 4) {
                for (int i = 0; i < 200; ++i) {
                    Random rand = new Random();
                    rho = 3.0;
                    double phi = rand.nextDouble() * 2.0 * Math.PI;
                    theta = rand.nextDouble() * 2.0 * Math.PI;
                    posX = msg.x + rho * Math.cos(theta) * Math.sin(phi);
                    posY = msg.y + rho * Math.sin(theta) * Math.sin(phi);
                    posZ = msg.z + rho * Math.cos(phi);
                    msg.world.func_72869_a("witchMagic", posX, posY, posZ, 0.1 * (msg.x - posX), 0.1 * (msg.y - posY), 0.1 * (msg.z - posZ));
                }
            }
            if (msg.type == 5) {
                for (int i = 0; i < 200; ++i) {
                    Random rand = new Random();
                    rho = 3.0;
                    double phi = rand.nextDouble() * 2.0 * Math.PI;
                    theta = rand.nextDouble() * 2.0 * Math.PI;
                    posX = msg.x + rho * Math.cos(theta) * Math.sin(phi);
                    posY = msg.y + rho * Math.sin(theta) * Math.sin(phi);
                    posZ = msg.z + rho * Math.cos(phi);
                    msg.world.func_72869_a("heart", posX, posY, posZ, 0.1 * (msg.x - posX), 0.1 * (msg.y - posY), 0.1 * (msg.z - posZ));
                }
            }
            if (msg.type == 7) {
                for (int i = 0; i < 400; ++i) {
                    Random rand = new Random();
                    rho = 5.0;
                    double phi = rand.nextDouble() * 2.0 * Math.PI;
                    theta = rand.nextDouble() * 2.0 * Math.PI;
                    posX = msg.x + rho * Math.cos(theta) * Math.sin(phi);
                    posY = msg.y + rho * Math.sin(theta) * Math.sin(phi);
                    posZ = msg.z + rho * Math.cos(phi);
                    msg.world.func_72869_a("wake", posX, posY, posZ, 0.0, 0.0, 0.0);
                }
            }
            if (msg.type == 8) {
                for (int i = 0; i < 50; ++i) {
                    Random rand = new Random();
                    msg.world.func_72869_a("enchantmenttable", msg.x, msg.y, msg.z, (rand.nextDouble() - 0.5) * 4.0, rand.nextDouble() / 64.0, (rand.nextDouble() - 0.5) * 4.0);
                }
            }
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readInt();
        if (this.type == 0) {
            this.from = new CoordTuple(buf.readInt(), buf.readInt(), buf.readInt());
            this.to = new CoordTuple(buf.readInt(), buf.readInt(), buf.readInt());
            this.particle = particles[buf.readByte()];
            this.r = buf.readDouble();
            this.g = buf.readDouble();
            this.b = buf.readDouble();
            this.comp = buf.readDouble();
        } else {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }
        this.world = AuraCascade.proxy.getWorld();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type);
        if (this.type == 0) {
            buf.writeInt(this.from.getX());
            buf.writeInt(this.from.getY());
            buf.writeInt(this.from.getZ());
            buf.writeInt(this.to.getX());
            buf.writeInt(this.to.getY());
            buf.writeInt(this.to.getZ());
            for (int i = 0; i < particles.length; ++i) {
                if (!particles[i].equals(this.particle)) continue;
                buf.writeByte(i);
                break;
            }
            buf.writeDouble(this.r);
            buf.writeDouble(this.g);
            buf.writeDouble(this.b);
            buf.writeDouble(this.comp);
        } else {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }
    }
}

