/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon.page;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import pixlepix.auracascade.block.tile.CraftingCenterTile;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.recipe.PylonRecipe;
import pixlepix.auracascade.lexicon.IGuiLexiconEntry;
import pixlepix.auracascade.lexicon.LexiconEntry;
import pixlepix.auracascade.lexicon.LexiconRecipeMappings;
import pixlepix.auracascade.lexicon.VazkiiRenderHelper;
import pixlepix.auracascade.lexicon.page.PageRecipe;
import pixlepix.auracascade.registry.BlockRegistry;

public class PagePylon
extends PageRecipe {
    private static final ResourceLocation craftingOverlay = new ResourceLocation("aura:textures/gui/pylonOverlay.png");
    PylonRecipe recipe;

    public PagePylon(String unlocalizedName, PylonRecipe recipe) {
        super(unlocalizedName);
        this.recipe = recipe;
    }

    public PagePylon(String unlocalizedName, Class item) {
        super(unlocalizedName);
        if (Item.class.isAssignableFrom(item)) {
            this.recipe = (PylonRecipe)BlockRegistry.getFirstRecipeFromItem(item);
        }
        if (Block.class.isAssignableFrom(item)) {
            this.recipe = (PylonRecipe)BlockRegistry.getFirstRecipeFromBlock(item);
        }
    }

    @Override
    public void onPageAdded(LexiconEntry entry, int index) {
        LexiconRecipeMappings.map(this.recipe.result, entry, index);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        this.renderPylonRecipe(gui, this.recipe, mx, my);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(craftingOverlay);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        render.func_110577_a(craftingOverlay);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3042);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderPylonRecipe(IGuiLexiconEntry gui, PylonRecipe recipe, int mx, int my) {
        for (int i = 0; i < 4; ++i) {
            int yOffset;
            ForgeDirection direction = CraftingCenterTile.pedestalRelativeLocations.get(i);
            int x = 2 + direction.offsetX;
            int y = 2 + direction.offsetZ;
            this.renderItemAtGridPos(gui, x, y, recipe.componentList.get((int)i).itemStack, true);
            int xPos = gui.getLeft() + x * 29 + 7 + (y == 0 && x == 3 ? 10 : 0);
            int yPos = gui.getTop() + y * 29 + 24 - (y == 0 ? 7 : 0);
            AuraQuantity quantity = recipe.componentList.get((int)i).auraQuantity;
            LexiconRecipeMappings.EntryData data = LexiconRecipeMappings.getDataForStack(recipe.componentList.get((int)i).itemStack);
            int n = yOffset = data != null && (data.entry != gui.getEntry() || data.page != gui.getPageOn()) ? 32 : 16;
            if (mx < xPos || my < yPos || mx >= xPos + 16 || my >= yPos + 16) continue;
            VazkiiRenderHelper.renderTooltip(mx, my + yOffset, Arrays.asList("" + quantity.getNum() + "(" + (quantity.getType() == EnumAura.WHITE_AURA ? "Any" : quantity.getType().name) + ")"));
        }
        this.renderItemAtGridPos(gui, 2, 0, recipe.result, false);
    }
}

