/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon.page;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import pixlepix.auracascade.lexicon.GuiButtonManualNavigation;
import pixlepix.auracascade.lexicon.GuiLexiconEntry;
import pixlepix.auracascade.lexicon.IGuiLexiconEntry;
import pixlepix.auracascade.lexicon.page.PageText;

public class MultiblockPage
extends PageText {
    ItemStack[][][] multiblock;
    boolean canTick = true;
    int tick = 0;
    int showLayer = -1;
    int blockCount = 0;
    int[] countPerLevel;
    int structureHeight = 0;
    int structureLength = 0;
    int structureWidth = 0;

    public MultiblockPage(String text, ItemStack[][][] multiblock) {
        super(text);
        this.multiblock = multiblock;
    }

    @Override
    public void onOpened(IGuiLexiconEntry gui) {
        int yOff = 0;
        if (this.multiblock != null) {
            ItemStack[][][] structure = this.multiblock;
            this.structureHeight = structure.length;
            this.structureWidth = 0;
            this.structureLength = 0;
            this.countPerLevel = new int[this.structureHeight];
            this.blockCount = 0;
            for (int h = 0; h < structure.length; ++h) {
                if (structure[h].length - 1 > this.structureLength) {
                    this.structureLength = structure[h].length - 1;
                }
                int perLvl = 0;
                for (int l = 0; l < structure[h].length; ++l) {
                    if (structure[h][l].length - 1 > this.structureWidth) {
                        this.structureWidth = structure[h][l].length - 1;
                    }
                    for (ItemStack ss : structure[h][l]) {
                        if (ss == null) continue;
                        ++perLvl;
                    }
                }
                this.countPerLevel[h] = perLvl;
                this.blockCount += perLvl;
            }
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
            yOff = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5 + 16;
            yOff = Math.max(48, yOff);
            int x = gui.getLeft();
            int y = gui.getTop();
            gui.getButtonList().add(new GuiButtonManualNavigation(gui, this, 100, x + 20, y + 10 + yOff / 2 - 5, 10, 10, 4));
            if (this.structureHeight > 1) {
                gui.getButtonList().add(new GuiButtonManualNavigation(gui, this, 101, x + 20, y + 10 + yOff / 2 - 8 - 16, 10, 16, 3));
                gui.getButtonList().add(new GuiButtonManualNavigation(gui, this, 102, x + 20, y + 10 + yOff / 2 + 8, 10, 16, 2));
            }
        }
        super.onOpened(gui);
    }

    @Override
    public void renderScreen(IGuiLexiconEntry gui, int mx, int my) {
        int x = gui.getLeft();
        int y = gui.getTop();
        int yOffPartial = 0;
        if (this.multiblock != null) {
            if (this.canTick) {
                ++this.tick;
            }
            ItemStack[][][] structure = this.multiblock;
            int prevLayers = 0;
            if (this.showLayer != -1) {
                for (int ll = 0; ll < this.showLayer; ++ll) {
                    prevLayers += this.countPerLevel[ll];
                }
            }
            int limiter = prevLayers + this.tick / 40 % ((this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) + 4);
            int xHalf = this.structureWidth * 5 - this.structureLength * 5;
            yOffPartial = (this.structureHeight - 1) * 12 + this.structureWidth * 5 + this.structureLength * 5 + 16;
            int yOffTotal = Math.max(48, yOffPartial + 16);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)32826);
            RenderHelper.func_74520_c();
            RenderItem.getInstance().field_77024_a = true;
            int i = 0;
            ItemStack highlighted = null;
            for (int h = 0; h < structure.length; ++h) {
                if (this.showLayer != -1 && h > this.showLayer) continue;
                ItemStack[][] level = structure[h];
                for (int l = level.length - 1; l >= 0; --l) {
                    ItemStack[] row = level[l];
                    for (int w = row.length - 1; w >= 0; --w) {
                        int xx = 60 + xHalf - 10 * w + 10 * l - 7;
                        int yy = yOffPartial - 5 * w - 5 * l - 12 * h;
                        GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                        if (row[w] == null || i > limiter) continue;
                        ++i;
                        RenderItem.getInstance().func_77015_a(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71446_o, row[w], x + xx, y + yy);
                        if (mx < x + xx || mx >= x + xx + 16 || my < y + yy || my >= y + yy + 16) continue;
                        highlighted = row[w];
                    }
                }
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)(-i));
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2929);
            Minecraft.func_71410_x().field_71466_p.func_78264_a(false);
            if (highlighted != null) {
                ((GuiLexiconEntry)gui).func_146285_a(highlighted, mx, my);
            }
            RenderHelper.func_74518_a();
        }
        int width = gui.getWidth() - 34;
        x = gui.getLeft() + 16;
        y = gui.getTop() + 10 + yOffPartial;
        MultiblockPage.renderText(x, y, width, this.getUnlocalizedName());
    }

    @Override
    public void onActionPerformed(GuiButton button) {
        if (button.field_146127_k == 100) {
            boolean bl = this.canTick = !this.canTick;
        }
        if (button.field_146127_k == 101) {
            this.showLayer = Math.min(this.showLayer + 1, this.structureHeight - 1);
            this.tick = this.countPerLevel[this.showLayer] * 40;
        }
        if (button.field_146127_k == 102) {
            this.showLayer = Math.max(this.showLayer - 1, -1);
            this.tick = (this.showLayer == -1 ? this.blockCount : this.countPerLevel[this.showLayer]) * 40;
        }
        super.onActionPerformed(button);
    }
}

