/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import pixlepix.auracascade.lexicon.CategoryManager;
import pixlepix.auracascade.lexicon.ClientTickHandler;
import pixlepix.auracascade.lexicon.GuiLexiconIndex;
import pixlepix.auracascade.lexicon.IParented;
import pixlepix.auracascade.lexicon.LexiconCategory;
import pixlepix.auracascade.lexicon.LexiconEntry;
import pixlepix.auracascade.lexicon.LibResources;
import pixlepix.auracascade.lexicon.button.GuiButtonBookmark;
import pixlepix.auracascade.lexicon.button.GuiButtonCategory;
import pixlepix.auracascade.lexicon.button.GuiButtonInvisible;

public class GuiLexicon
extends GuiScreen {
    public static final int BOOKMARK_START = 1337;
    public static final ResourceLocation texture = new ResourceLocation(LibResources.GUI_LEXICON);
    private static final int TUTORIAL_ARROW_WIDTH = 10;
    private static final int TUTORIAL_ARROW_HEIGHT = 12;
    public static GuiLexicon currentOpenLexicon = new GuiLexicon();
    public static ItemStack stackUsed;
    public static List<GuiLexicon> bookmarks;
    public static Queue<LexiconEntry> tutorial;
    public static ArrayList<LexiconEntry> tutorialMaster;
    public float lastTime = 0.0f;
    public float partialTicks = 0.0f;
    public float timeDelta = 0.0f;
    boolean bookmarksNeedPopulation = false;
    List<LexiconCategory> allCategories;
    boolean hasTutorialArrow;
    int tutorialArrowX;
    int tutorialArrowY;
    String title;
    int guiWidth = 146;
    int guiHeight = 180;
    int left;
    int top;

    public static void startTutorial() {
        tutorial.clear();
        for (LexiconEntry entry : tutorialMaster) {
            tutorial.add(entry);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.allCategories = new ArrayList<LexiconCategory>(CategoryManager.getAllCategories());
        Collections.sort(this.allCategories);
        this.lastTime = ClientTickHandler.ticksInGame;
        currentOpenLexicon = this;
        this.title = stackUsed.func_82833_r();
        this.left = this.field_146294_l / 2 - this.guiWidth / 2;
        this.top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.field_146292_n.clear();
        if (this.isIndex()) {
            int x = 18;
            for (int i = 0; i < 12; ++i) {
                int y = 16 + i * 12;
                this.field_146292_n.add(new GuiButtonInvisible(i, this.left + x, this.top + y, 110, 10, ""));
            }
            this.populateIndex();
        } else if (this.isCategoryIndex()) {
            int categories = this.allCategories.size();
            for (int i = 0; i < categories + 1; ++i) {
                LexiconCategory category = i >= categories ? null : this.allCategories.get(i);
                int x = i % 4;
                int y = i / 4;
                int size = 27;
                GuiButtonCategory button = new GuiButtonCategory(i, this.left + 18 + x * size, this.top + 35 + y * size, this, category);
                this.field_146292_n.add(button);
            }
        }
        this.populateBookmarks();
        this.putTutorialArrow();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        float time = (float)ClientTickHandler.ticksInGame + par3;
        this.timeDelta = time - this.lastTime;
        this.lastTime = time;
        this.partialTicks = par3;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(this.left, this.top, 0, 0, this.guiWidth, this.guiHeight);
        this.drawBookmark(this.left + this.guiWidth / 2, this.top - this.getTitleHeight(), this.getTitle(), true);
        String subtitle = this.getSubtitle();
        if (subtitle != null) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            this.func_73732_a(this.field_146289_q, subtitle, this.left * 2 + this.guiWidth, (this.top - this.getTitleHeight() + 11) * 2, 65280);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        }
        this.drawHeader();
        if (this.bookmarksNeedPopulation) {
            this.populateBookmarks();
            this.bookmarksNeedPopulation = false;
        }
        super.func_73863_a(par1, par2, par3);
        if (this.hasTutorialArrow) {
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.7f + (float)(Math.sin(((float)ClientTickHandler.ticksInGame + par3) * 0.3f) + 1.0) * 0.15f));
            this.func_73729_b(this.tutorialArrowX, this.tutorialArrowY, 20, 200, 10, 12);
            GL11.glDisable((int)3042);
        }
    }

    public void drawBookmark(int x, int y, String s, boolean drawLeft) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = font.func_82883_a();
        font.func_78264_a(true);
        int l = font.func_78256_a(s);
        int fontOff = 0;
        if (!drawLeft) {
            x += l / 2;
            fontOff = 2;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x + l / 2 + 3, y - 1, 54, 180, 6, 11);
        if (drawLeft) {
            this.func_73729_b(x - l / 2 - 9, y - 1, 61, 180, 6, 11);
        }
        for (int i = 0; i < l + 6; ++i) {
            this.func_73729_b(x - l / 2 - 3 + i, y - 1, 60, 180, 1, 11);
        }
        font.func_85187_a(s, x - l / 2 + fontOff, y, 0x111111, false);
        font.func_78264_a(unicode);
    }

    void drawHeader() {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        this.field_146289_q.func_78279_b(String.format(StatCollector.func_74838_a((String)"aura.gui.lexicon.header"), new Object[0]), this.left + 18, this.top + 12, 110, 0);
        this.field_146289_q.func_78264_a(unicode);
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146127_k >= 1337) {
            this.handleBookmark(par1GuiButton);
        } else if (par1GuiButton instanceof GuiButtonCategory) {
            LexiconCategory category = ((GuiButtonCategory)par1GuiButton).getCategory();
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLexiconIndex(category));
            ClientTickHandler.notifyPageChange();
        }
    }

    public void handleBookmark(GuiButton par1GuiButton) {
        int i = par1GuiButton.field_146127_k - 1337;
        if (i == bookmarks.size()) {
            if (!bookmarks.contains((Object)this)) {
                bookmarks.add(this);
            }
        } else if (GuiLexicon.func_146272_n()) {
            bookmarks.remove(i);
        } else {
            GuiLexicon bookmark = bookmarks.get(i);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)bookmark);
            if (!bookmark.getTitle().equals(this.getTitle())) {
                if (bookmark instanceof IParented) {
                    ((IParented)((Object)bookmark)).setParent(this);
                }
                ClientTickHandler.notifyPageChange();
            }
        }
        this.bookmarksNeedPopulation = true;
    }

    public boolean func_73868_f() {
        return false;
    }

    public int bookmarkWidth(String b) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        int width = this.field_146289_q.func_78256_a(b) + 15;
        this.field_146289_q.func_78264_a(unicode);
        return width;
    }

    String getTitle() {
        return this.title;
    }

    String getSubtitle() {
        return null;
    }

    int getTitleHeight() {
        return this.getSubtitle() == null ? 12 : 16;
    }

    boolean isIndex() {
        return false;
    }

    boolean isCategoryIndex() {
        return true;
    }

    void populateIndex() {
        int shift;
        List<LexiconCategory> categoryList = CategoryManager.getAllCategories();
        for (int i = shift = 2; i < 12; ++i) {
            LexiconCategory category;
            int i_ = i - shift;
            GuiButtonInvisible button = (GuiButtonInvisible)((Object)this.field_146292_n.get(i));
            LexiconCategory lexiconCategory = category = i_ >= categoryList.size() ? null : categoryList.get(i_);
            if (category == null) {
                button.field_146126_j = StatCollector.func_74838_a((String)"auramisc.lexiconIndex");
                break;
            }
            button.field_146126_j = StatCollector.func_74838_a((String)category.getUnlocalizedName());
        }
    }

    void populateBookmarks() {
        ArrayList<GuiButton> remove = new ArrayList<GuiButton>();
        List buttons = this.field_146292_n;
        for (GuiButton button : buttons) {
            if (button.field_146127_k < 1337) continue;
            remove.add(button);
        }
        this.field_146292_n.removeAll(remove);
        int len = bookmarks.size();
        boolean thisExists = false;
        for (GuiLexicon lex : bookmarks) {
            if (!lex.getTitle().equals(this.getTitle())) continue;
            thisExists = true;
        }
        boolean addEnabled = len < 8 && this instanceof IParented && !thisExists;
        for (int i = 0; i < len + (addEnabled ? 1 : 0); ++i) {
            boolean isAdd = i == bookmarks.size();
            GuiLexicon gui = isAdd ? null : bookmarks.get(i);
            this.field_146292_n.add(new GuiButtonBookmark(1337 + i, this.left + 138, this.top + 18 + 14 * i, gui == null ? this : gui, gui == null ? "+" : gui.getTitle()));
        }
    }

    boolean closeScreenOnInvKey() {
        return true;
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.closeScreenOnInvKey() && this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == par2) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
        super.func_73869_a(par1, par2);
    }

    public final void putTutorialArrow() {
        boolean bl = this.hasTutorialArrow = !tutorial.isEmpty();
        if (this.hasTutorialArrow) {
            this.positionTutorialArrow();
        }
    }

    public void positionTutorialArrow() {
        LexiconEntry entry = tutorial.peek();
        LexiconCategory category = entry.category;
        List buttons = this.field_146292_n;
        for (GuiButton button : buttons) {
            GuiButtonCategory catButton;
            if (!(button instanceof GuiButtonCategory) || (catButton = (GuiButtonCategory)button).getCategory() != category) continue;
            this.orientTutorialArrowWithButton(button);
            break;
        }
    }

    public void orientTutorialArrowWithButton(GuiButton button) {
        if (button != null) {
            this.tutorialArrowX = button.field_146128_h - 10;
            this.tutorialArrowY = button.field_146129_i - 12;
        }
    }

    static {
        bookmarks = new ArrayList<GuiLexicon>();
        tutorial = new ArrayDeque<LexiconEntry>();
        tutorialMaster = new ArrayList();
    }
}

