/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.item.ItemMaterial;
import pixlepix.auracascade.main.EnumColor;
import pixlepix.auracascade.main.ParticleEffects;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererItem;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class ItemPrismaticWand
extends Item
implements ITTinkererItem {
    public static String[] modes = new String[]{(Object)((Object)EnumColor.AQUA) + "Selection", (Object)((Object)EnumColor.YELLOW) + "Copy", (Object)((Object)EnumColor.ORANGE) + "Paste"};

    public ItemPrismaticWand() {
        this.func_77625_d(1);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (!player.func_70093_af() && !world.field_72995_K) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            NBTTagCompound nbt = stack.field_77990_d;
            if (stack.func_77960_j() == 0) {
                if (nbt.func_74764_b("x1")) {
                    nbt.func_74768_a("x2", nbt.func_74762_e("x1"));
                    nbt.func_74768_a("y2", nbt.func_74762_e("y1"));
                    nbt.func_74768_a("z2", nbt.func_74762_e("z1"));
                }
                nbt.func_74768_a("x1", x);
                nbt.func_74768_a("y1", y);
                nbt.func_74768_a("z1", z);
                player.func_146105_b((IChatComponent)new ChatComponentText("Position set"));
                return true;
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        super.func_77624_a(stack, player, list, p_77624_4_);
        list.add(modes[stack.func_77960_j()]);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int mode = stack.func_77960_j();
        if (player.func_70093_af()) {
            NBTTagCompound nbt = stack.field_77990_d;
            ++mode;
            stack.func_77964_b(mode %= modes.length);
            stack.field_77990_d = nbt;
            if (!world.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Switched to: " + modes[mode]));
            }
        } else {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            NBTTagCompound nbt = stack.field_77990_d;
            switch (mode) {
                case 1: {
                    if (nbt.func_74764_b("x1") && nbt.func_74764_b("x2")) {
                        nbt.func_74768_a("cx1", nbt.func_74762_e("x1"));
                        nbt.func_74768_a("cy1", nbt.func_74762_e("y1"));
                        nbt.func_74768_a("cz1", nbt.func_74762_e("z1"));
                        nbt.func_74768_a("cx2", nbt.func_74762_e("x2"));
                        nbt.func_74768_a("cy2", nbt.func_74762_e("y2"));
                        nbt.func_74768_a("cz2", nbt.func_74762_e("z2"));
                        nbt.func_74768_a("cxo", nbt.func_74762_e("x1") - this.roundToZero(player.field_70165_t));
                        nbt.func_74768_a("cyo", nbt.func_74762_e("y1") - this.roundToZero(player.field_70163_u));
                        nbt.func_74768_a("czo", nbt.func_74762_e("z1") - this.roundToZero(player.field_70161_v));
                        if (world.field_72995_K) break;
                        player.func_146105_b((IChatComponent)new ChatComponentText("Copied to clipboard"));
                        break;
                    }
                    if (world.field_72995_K) break;
                    player.func_146105_b((IChatComponent)new ChatComponentText("Invalid selection"));
                    break;
                }
                case 2: {
                    int x = (int)player.field_70165_t;
                    int y = (int)player.field_70163_u;
                    int z = (int)player.field_70161_v;
                    if (nbt.func_74764_b("cx1")) {
                        int t;
                        int cx1 = nbt.func_74762_e("cx1");
                        int cy1 = nbt.func_74762_e("cy1");
                        int cz1 = nbt.func_74762_e("cz1");
                        int cx2 = nbt.func_74762_e("cx2");
                        int cy2 = nbt.func_74762_e("cy2");
                        int cz2 = nbt.func_74762_e("cz2");
                        int xo = nbt.func_74762_e("cxo");
                        int yo = nbt.func_74762_e("cyo");
                        int zo = nbt.func_74762_e("czo");
                        if (cx1 > cx2) {
                            xo += cx2 - cx1;
                            t = cx1;
                            cx1 = cx2;
                            cx2 = t;
                        }
                        if (cy1 > cy2) {
                            yo += cy2 - cy1;
                            t = cy1;
                            cy1 = cy2;
                            cy2 = t;
                        }
                        if (cz1 > cz2) {
                            zo += cz2 - cz1;
                            t = cz1;
                            cz1 = cz2;
                            cz2 = t;
                        }
                        int xi = cx1;
                        do {
                            int yi = cy1;
                            do {
                                int zi = cz1;
                                do {
                                    int dx = xi - cx1;
                                    int dy = yi - cy1;
                                    int dz = zi - cz1;
                                    int oldX = cx1 + dx;
                                    int oldY = cy1 + dy;
                                    int oldZ = cz1 + dz;
                                    int newX = x + dx + xo;
                                    int newY = y + dy + yo;
                                    int newZ = z + dz + zo;
                                    if (!world.func_147437_c(newX, newY, newZ)) continue;
                                    Block block = world.func_147439_a(oldX, oldY, oldZ);
                                    Item item = block.func_149694_d(world, oldX, oldY, oldZ);
                                    int worldDmg = world.func_72805_g(oldX, oldY, oldZ);
                                    int dmg = block.func_149643_k(world, oldX, oldY, oldZ);
                                    boolean usesMetadataForPlacing = false;
                                    ArrayList drops = block.getDrops(world, oldX, oldY, oldZ, dmg, 0);
                                    if (drops.size() == 1) {
                                        ItemStack dropStack = (ItemStack)drops.get(0);
                                        boolean bl = usesMetadataForPlacing = dropStack.func_77973_b() == item && dropStack.func_77960_j() == 0 && worldDmg != 0;
                                    }
                                    if (player.field_71075_bZ.field_75098_d) {
                                        if (world.field_72995_K) continue;
                                        world.func_147465_d(newX, newY, newZ, block, worldDmg, 3);
                                        this.particles(newX, newY, newZ);
                                        continue;
                                    }
                                    if (!player.field_71071_by.func_70431_c(new ItemStack(item, 1, dmg))) continue;
                                    int slot = this.slotOfItemStack(new ItemStack(item, 1, dmg), player.field_71071_by);
                                    if (!(item instanceof ItemBlock)) continue;
                                    if (!world.field_72995_K) {
                                        ((ItemBlock)item).placeBlockAt(player.field_71071_by.func_70301_a(slot), player, world, x + dx + xo, y + dy + yo, z + dz + zo, 0, 0.0f, 0.0f, 0.0f, dmg);
                                        if (usesMetadataForPlacing) {
                                            world.func_72921_c(newX, newY, newZ, worldDmg, 3);
                                        }
                                    }
                                    this.particles(newX, newY, newZ);
                                    player.field_71071_by.func_70298_a(slot, 1);
                                } while (++zi <= cz2);
                            } while (++yi <= cy2);
                        } while (++xi <= cx2);
                        if (world.field_72995_K) break;
                        player.func_146105_b((IChatComponent)new ChatComponentText("Successfully pasted building"));
                        break;
                    }
                    if (world.field_72995_K) break;
                    player.func_146105_b((IChatComponent)new ChatComponentText("Nothing copied"));
                }
            }
        }
        return stack;
    }

    public int roundToZero(double d) {
        return (int)(d > 0.0 ? Math.floor(d) : Math.ceil(d));
    }

    private void particles(int bx, int by, int bz) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (int i = 0; i < 3; ++i) {
                Random random = new Random();
                double x = (double)bx + random.nextDouble();
                double y = (double)by + random.nextDouble();
                double z = (double)bz + random.nextDouble();
                ParticleEffects.spawnParticle("witchMagic", x, y, z, 0.0, 0.0, 0.0, 0.0, 34.0, 264.0);
            }
        }
    }

    public int slotOfItemStack(ItemStack stack, InventoryPlayer inv) {
        for (int i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null || !inv.field_70462_a[i].func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return null;
    }

    @Override
    public String getItemName() {
        return "prismaticWand";
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        return new CraftingBenchRecipe(new ItemStack((Item)this), " P ", " I ", " I ", Character.valueOf('P'), ItemMaterial.getPrism(), Character.valueOf('I'), new ItemStack(Items.field_151072_bj));
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("aura:prismaticWand");
    }

    @Override
    public int getCreativeTabPriority() {
        return -25;
    }
}

