/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.QuestManager;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.item.ItemAuraCrystal;
import pixlepix.auracascade.lexicon.CategoryManager;
import pixlepix.auracascade.lexicon.ILexiconable;
import pixlepix.auracascade.lexicon.LexiconEntry;
import pixlepix.auracascade.lexicon.common.core.helper.ItemNBTHelper;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererItem;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class ItemLexicon
extends Item
implements ITTinkererItem {
    private static final String TAG_KNOWLEDGE_PREFIX = "knowledge.";
    private static final String TAG_FORCED_MESSAGE = "forcedMessage";
    private static final String TAG_QUEUE_TICKS = "queueTicks";
    private static final String name = "lexicon";
    boolean skipSound = false;

    public ItemLexicon() {
        this.func_77625_d(1);
    }

    public static void setForcedPage(ItemStack stack, String forced) {
        ItemNBTHelper.setString(stack, TAG_FORCED_MESSAGE, forced);
    }

    public static String getForcedPage(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_FORCED_MESSAGE, "");
    }

    private static LexiconEntry getEntryFromForce(ItemStack stack) {
        String force = ItemLexicon.getForcedPage(stack);
        for (LexiconEntry entry : CategoryManager.getAllEntries()) {
            if (!entry.unlocalizedName.equals(force)) continue;
            return entry;
        }
        return null;
    }

    public static int getQueueTicks(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_QUEUE_TICKS, 0);
    }

    public static void setQueueTicks(ItemStack stack, int ticks) {
        ItemNBTHelper.setInt(stack, TAG_QUEUE_TICKS, ticks);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("aura:book");
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        LexiconEntry entry;
        Block block;
        if (par2EntityPlayer.func_70093_af() && (block = par3World.func_147439_a(par4, par5, par6)) != null && block instanceof ILexiconable && (entry = ((ILexiconable)block).getEntry(par3World, par4, par5, par6, par2EntityPlayer, par1ItemStack)) != null) {
            AuraCascade.proxy.setEntryToOpen(entry);
            AuraCascade.proxy.setLexiconStack(par1ItemStack);
            par2EntityPlayer.openGui((Object)AuraCascade.instance, 0, par3World, 0, 0, 0);
            if (!par3World.field_72995_K) {
                par3World.func_72956_a((Entity)par2EntityPlayer, "aura:lexiconOpen", 0.5f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        String force = ItemLexicon.getForcedPage(par1ItemStack);
        if (force != null && !force.isEmpty()) {
            LexiconEntry entry = ItemLexicon.getEntryFromForce(par1ItemStack);
            if (entry != null) {
                AuraCascade.proxy.setEntryToOpen(entry);
            } else {
                par3EntityPlayer.func_145747_a(new ChatComponentTranslation("aura.misc.cantOpen", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
            ItemLexicon.setForcedPage(par1ItemStack, "");
        }
        QuestManager.check(par3EntityPlayer);
        AuraCascade.proxy.setLexiconStack(par1ItemStack);
        par3EntityPlayer.openGui((Object)AuraCascade.instance, 0, par2World, 0, 0, 0);
        if (!par2World.field_72995_K && !this.skipSound) {
            par2World.func_72956_a((Entity)par3EntityPlayer, "aura:lexiconOpen", 0.5f, 1.0f);
        }
        this.skipSound = false;
        return par1ItemStack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int idk, boolean something) {
        int ticks = ItemLexicon.getQueueTicks(stack);
        if (ticks > 0 && entity instanceof EntityPlayer) {
            boolean bl = this.skipSound = ticks < 5;
            if (ticks == 1) {
                this.func_77659_a(stack, world, (EntityPlayer)entity);
            }
            ItemLexicon.setQueueTicks(stack, ticks - 1);
        }
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.uncommon;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return null;
    }

    @Override
    public String getItemName() {
        return name;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        return new CraftingBenchRecipe(new ItemStack((Item)this), "CB", "  ", Character.valueOf('C'), ItemAuraCrystal.getCrystalFromAura(EnumAura.WHITE_AURA), Character.valueOf('B'), new ItemStack(Items.field_151122_aG));
    }

    @Override
    public int getCreativeTabPriority() {
        return 150;
    }
}

