/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.IAngelsteelTool;
import pixlepix.auracascade.item.AngelsteelToolHelper;
import pixlepix.auracascade.item.ItemAngelsteelIngot;
import pixlepix.auracascade.item.ItemAuraCrystal;
import pixlepix.auracascade.main.ParticleEffects;
import pixlepix.auracascade.potions.PotionManager;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererItem;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;
import pixlepix.auracascade.registry.ThaumicTinkererRecipeMulti;

public class ItemAngelsteelSword
extends ItemSword
implements ITTinkererItem,
IAngelsteelTool {
    public static final String name = "angelsteelSword";
    public static String[] patrons = new String[]{"Pixlepix", "JGPhoenix"};
    public int degree = 0;
    public EnumAura[] auraSwords = new EnumAura[]{EnumAura.BLUE_AURA, EnumAura.GREEN_AURA, EnumAura.ORANGE_AURA, EnumAura.RED_AURA, EnumAura.VIOLET_AURA, EnumAura.YELLOW_AURA};
    public HashMap<EnumAura, IIcon> iconHashMap = new HashMap();

    public ItemAngelsteelSword(Integer i) {
        super(AngelsteelToolHelper.materials[i]);
        this.degree = i;
        this.func_77637_a(null);
    }

    public ItemAngelsteelSword() {
        this(0);
    }

    public static ItemStack getStackFirstDegree(EnumAura aura) {
        return ((ItemAngelsteelSword)BlockRegistry.getFirstItemFromClass(ItemAngelsteelSword.class)).getStack(aura);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("aura:angel_sword");
        for (EnumAura aura : this.auraSwords) {
            this.iconHashMap.put(aura, register.func_94245_a("aura:angel_sword" + aura.name));
        }
    }

    @Override
    public int getCreativeTabPriority() {
        return -5;
    }

    public boolean func_150894_a(ItemStack p_150894_1_, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        return true;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("aura")) {
            EnumAura aura = EnumAura.values()[stack.field_77990_d.func_74762_e("aura")];
            return this.iconHashMap.get((Object)aura);
        }
        return super.func_77650_f(stack);
    }

    public EnumAura getAura(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("aura")) {
            return EnumAura.values()[stack.field_77990_d.func_74762_e("aura")];
        }
        return EnumAura.RED_AURA;
    }

    public ItemStack getStack(EnumAura aura) {
        ItemStack stack = new ItemStack((Item)this);
        stack.field_77990_d = new NBTTagCompound();
        stack.field_77990_d.func_74768_a("aura", aura.ordinal());
        return stack;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return AngelsteelToolHelper.getDegreeList();
    }

    @Override
    public String getItemName() {
        return name + this.degree;
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return this.degree == 0 || this.degree == 11;
    }

    public boolean func_77614_k() {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (EnumAura aura : this.auraSwords) {
            list.add(this.getStack(aura));
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase attacker) {
        EnumAura aura = this.getAura(stack);
        if (aura == EnumAura.RED_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionRed.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        if (aura == EnumAura.ORANGE_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionOrange.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        if (aura == EnumAura.YELLOW_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionYellow.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        if (aura == EnumAura.GREEN_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionGreen.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        if (aura == EnumAura.BLUE_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionBlue.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        if (aura == EnumAura.VIOLET_AURA) {
            entity.func_70690_d(new PotionEffect(PotionManager.potionPurple.func_76396_c(), this.degree * this.degree * 100 + 100));
        }
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        EntityPlayer player = AuraCascade.proxy.getPlayer();
        if (player != null && Arrays.asList(patrons).contains(player.getDisplayName())) {
            return "Sword of the Patron";
        }
        return this.getAura((ItemStack)stack).name + " " + super.func_77653_i(stack);
    }

    public void func_77663_a(ItemStack stack, World w, Entity e, int p_77663_4_, boolean p_77663_5_) {
        if (w.field_72995_K && e instanceof EntityPlayer && Arrays.asList(patrons).contains(((EntityPlayer)e).getDisplayName())) {
            float hue = (float)(w.func_82737_E() % 1200L) / 1200.0f;
            Color color = Color.getHSBColor(hue, 1.0f, 0.5f);
            Random r = new Random();
            ParticleEffects.spawnParticle("squareLong", e.field_70165_t, e.field_70163_u + 0.5, e.field_70161_v, r.nextFloat() / 5.0f, 0.5, r.nextFloat() / 5.0f, color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        ThaumicTinkererRecipeMulti result = new ThaumicTinkererRecipeMulti();
        ArrayList<ThaumicTinkererRecipe> recipes = new ArrayList<ThaumicTinkererRecipe>();
        for (EnumAura aura : this.auraSwords) {
            recipes.add(new CraftingBenchRecipe(this.getStack(aura), " A ", " A ", " C ", Character.valueOf('A'), new ItemStack(BlockRegistry.getFirstItemFromClass(ItemAngelsteelIngot.class), 1, this.degree), Character.valueOf('C'), ItemAuraCrystal.getCrystalFromAura(aura)));
        }
        result.recipes = recipes;
        return result;
    }

    @Override
    public int getDegree() {
        return this.degree;
    }
}

