/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.data;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CoordTuple {
    private int x;
    private int y;
    private int z;

    public CoordTuple(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CoordTuple(TileEntity tileEntity) {
        this.x = tileEntity.field_145851_c;
        this.y = tileEntity.field_145848_d;
        this.z = tileEntity.field_145849_e;
    }

    public static Vec3 vec(CoordTuple tuple) {
        return Vec3.func_72443_a((double)tuple.getX(), (double)tuple.getY(), (double)tuple.getZ());
    }

    public void setBlockToAir(World world) {
        world.func_147468_f(this.x, this.y, this.z);
    }

    public CoordTuple add(ForgeDirection dir) {
        return new CoordTuple(this.x + dir.offsetX, this.y + dir.offsetY, this.z + dir.offsetZ);
    }

    public CoordTuple add(ForgeDirection dir, int mult) {
        return new CoordTuple(this.x + dir.offsetX * mult, this.y + dir.offsetY * mult, this.z + dir.offsetZ * mult);
    }

    public double dist(CoordTuple other) {
        return Math.sqrt((this.x - other.x) * (this.x - other.x) + (this.y - other.y) * (this.y - other.y) + (this.z - other.z) * (this.z - other.z));
    }

    public CoordTuple scale(int scalar) {
        return new CoordTuple(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public CoordTuple subtract(CoordTuple other) {
        return new CoordTuple(this.x - other.getX(), this.y - other.getY(), this.z - other.getZ());
    }

    public double dist(TileEntity te) {
        return this.dist(new CoordTuple(te));
    }

    public TileEntity getTile(World w) {
        return w.func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock(World w) {
        return w.func_147439_a(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public ForgeDirection getDirectionTo(CoordTuple other) {
        int xDiff = other.x - this.x;
        int yDiff = other.y - this.y;
        int zDiff = other.z - this.z;
        int count = 0;
        if (xDiff != 0) {
            ++count;
        }
        if (yDiff != 0) {
            ++count;
        }
        if (zDiff != 0) {
            ++count;
        }
        if (count == 1) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (direction.offsetX != (int)Math.signum(xDiff) || direction.offsetY != (int)Math.signum(yDiff) || direction.offsetZ != (int)Math.signum(zDiff)) continue;
                return direction;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public boolean equals(Object obj) {
        return obj instanceof CoordTuple && ((CoordTuple)obj).x == this.x && ((CoordTuple)obj).y == this.y && ((CoordTuple)obj).z == this.z;
    }

    public int hashCode() {
        return this.x * 3542 + this.y * 234523 + this.z * 43258796;
    }

    public AxisAlignedBB getBoundingBox(int range) {
        return AxisAlignedBB.func_72330_a((double)(this.x - range), (double)(this.y - range), (double)(this.z - range), (double)(this.x + range + 1), (double)(this.y + range + 1), (double)(this.z + range + 1));
    }

    public List<CoordTuple> inRange(int range) {
        LinkedList<CoordTuple> result = new LinkedList<CoordTuple>();
        for (int xi = -range; xi < range + 1; ++xi) {
            for (int yi = -range; yi < range + 1; ++yi) {
                for (int zi = -range; zi < range + 1; ++zi) {
                    result.add(new CoordTuple(this.x + xi, this.y + yi, this.z + zi));
                }
            }
        }
        return result;
    }

    public int getMeta(World worldObj) {
        return worldObj.func_72805_g(this.x, this.y, this.z);
    }
}

