/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.data.recipe.ProcessorRecipe;
import pixlepix.auracascade.data.recipe.ProcessorRecipeRegistry;
import pixlepix.auracascade.main.AuraUtil;

public class ProcessorTile
extends ConsumerTile {
    public static int MAX_PROGRESS = 60;
    public static int POWER_PER_PROGRESS = 150;

    public static ItemStack getDoubleResult(ItemStack stack) {
        int[] oreIds;
        for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String dustName;
            String oreName = OreDictionary.getOreName((int)id);
            if (!StringUtils.startsWith((CharSequence)oreName, (CharSequence)"ore") || OreDictionary.getOres((String)(dustName = StringUtils.replace((String)oreName, (String)"ore", (String)"dust"))).size() == 0) continue;
            return ((ItemStack)OreDictionary.getOres((String)dustName).get(0)).func_77946_l();
        }
        return null;
    }

    @Override
    public int getMaxProgress() {
        return MAX_PROGRESS;
    }

    @Override
    public int getPowerPerProgress() {
        return POWER_PER_PROGRESS;
    }

    @Override
    public boolean validItemsNearby() {
        int range = 3;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            if (ProcessorTile.getDoubleResult(stack) == null) continue;
            return true;
        }
        return ProcessorRecipeRegistry.getRecipeFromEntity(nearbyItems, this.isPrismatic()) != null;
    }

    public boolean isPrismatic() {
        return false;
    }

    public int oreMultFactor() {
        return 2;
    }

    @Override
    public void onUsePower() {
        AuraCascade.analytics.eventDesign(this.isPrismatic() ? "consumerProcessorPrism" : "consumerProcessor", AuraUtil.formatLocation(this));
        int range = 3;
        ItemStack resultStack = null;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            if (ProcessorTile.getDoubleResult(stack) == null) continue;
            resultStack = ProcessorTile.getDoubleResult(stack);
            resultStack.field_77994_a = this.oreMultFactor();
            --stack.field_77994_a;
            this.spawnInWorld(resultStack, entityItem);
            return;
        }
        ProcessorRecipe recipe = ProcessorRecipeRegistry.getRecipeFromEntity(nearbyItems, this.isPrismatic());
        if (recipe != null) {
            EntityItem spawnNear = (EntityItem)nearbyItems.get(0);
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(recipe.componentList);
            block1: for (EntityItem entityItem : nearbyItems) {
                ItemStack entityStack = entityItem.func_92059_d();
                Iterator recipeItemIter = ingredients.iterator();
                while (recipeItemIter.hasNext()) {
                    ItemStack curStack = (ItemStack)recipeItemIter.next();
                    if (curStack.field_77994_a > entityStack.field_77994_a || curStack.func_77960_j() != entityStack.func_77960_j() || curStack.func_77973_b() != entityStack.func_77973_b()) continue;
                    spawnNear = entityItem;
                    entityStack.field_77994_a -= curStack.field_77994_a;
                    recipeItemIter.remove();
                    continue block1;
                }
            }
            this.spawnInWorld(recipe.result.func_77946_l(), spawnNear);
        }
    }

    public boolean spawnInWorld(ItemStack resultStack, EntityItem entityItem) {
        if (resultStack != null) {
            AuraUtil.respawnItemWithParticles(this.field_145850_b, entityItem, resultStack);
            return true;
        }
        return false;
    }
}

